/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.BrowserClient;
import org.netbeans.modules.subversion.ui.browser.BrowserPanel;
import org.netbeans.modules.subversion.ui.browser.RepositoryPathNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Browser
implements VetoableChangeListener,
BrowserClient,
TreeExpansionListener {
    public static final int BROWSER_SHOW_FILES = 1;
    public static final int BROWSER_SINGLE_SELECTION_ONLY = 2;
    public static final int BROWSER_FILES_SELECTION_ONLY = 4;
    public static final int BROWSER_FOLDERS_SELECTION_ONLY = 8;
    public static final int BROWSER_SELECT_ANYTHING = 12;
    public static final String BROWSER_HELP_ID_SEARCH_HISTORY = "org.netbeans.modules.subversion.ui.browser.searchhistory";
    public static final String BROWSER_HELP_ID_CHECKOUT = "org.netbeans.modules.subversion.ui.browser.checkout";
    public static final String BROWSER_HELP_ID_URL_PATTERN = "org.netbeans.modules.subversion.ui.browser.urlpattern";
    public static final String BROWSER_HELP_ID_MERGE = "org.netbeans.modules.subversion.ui.browser.merge";
    public static final String BROWSER_HELP_ID_MERGE_TAG = "org.netbeans.modules.subversion.ui.browser.mergetag";
    public static final String BROWSER_HELP_ID_SWITCH_TO = "org.netbeans.modules.subversion.ui.browser.switchto";
    public static final String BROWSER_HELP_ID_COPY = "org.netbeans.modules.subversion.ui.browser.copy";
    public static final String BROWSER_HELP_ID_IMPORT = "org.netbeans.modules.subversion.ui.browser.import";
    private final int mode;
    private final String helpID;
    private final String username;
    private final char[] password;
    private static final RepositoryFile[] EMPTY_ROOT = new RepositoryFile[0];
    private static final Action[] EMPTY_ACTIONS = new Action[0];
    private final BrowserPanel panel;
    private RepositoryFile repositoryRoot;
    private Action[] nodeActions;
    private boolean keepWarning = false;
    private boolean initialSelection = true;
    private List<SvnProgressSupport> supportList = new ArrayList<SvnProgressSupport>();
    private volatile boolean cancelled = false;
    private Node[] selectedNodes;

    public Browser(String title, int mode, RepositoryFile repositoryRoot, RepositoryFile[] select, BrowserAction[] nodeActions, String helpID) {
        this(title, mode, repositoryRoot, select, null, null, nodeActions, helpID);
    }

    public Browser(String title, int mode, RepositoryFile repositoryRoot, RepositoryFile[] select, String username, char[] password, BrowserAction[] nodeActions, String helpID) {
        this.mode = mode;
        this.helpID = helpID;
        this.username = username;
        this.password = username == null ? null : password;
        this.panel = new BrowserPanel(title, NbBundle.getMessage(Browser.class, (String)"ACSN_RepositoryTree"), NbBundle.getMessage(Browser.class, (String)"ACSD_RepositoryTree"), (mode & 2) == 2);
        this.panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryPathNode.class, (String)"CTL_Browser_Prompt"));
        this.panel.addTreeExpansionListener(this);
        this.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        if (nodeActions != null) {
            this.nodeActions = nodeActions;
            this.panel.setActions(nodeActions);
            for (int i = 0; i < nodeActions.length; ++i) {
                nodeActions[i].setBrowser(this);
            }
        } else {
            this.nodeActions = EMPTY_ACTIONS;
        }
        this.repositoryRoot = repositoryRoot;
        RepositoryPathNode rootNode = RepositoryPathNode.createRepositoryRootNode(this, repositoryRoot);
        Node[] selectedNodes = this.getSelectedNodes(rootNode, repositoryRoot, select);
        this.getExplorerManager().setRootContext((Node)rootNode);
        this.panel.expandNode(rootNode);
        if (selectedNodes == null) {
            selectedNodes = new Node[]{};
        }
        if (selectedNodes.length > 0) {
            for (Node selectedNode : selectedNodes) {
                this.panel.expandNode((RepositoryPathNode)selectedNode);
            }
            try {
                this.getExplorerManager().setSelectedNodes(selectedNodes);
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
    }

    public RepositoryFile[] getRepositoryFiles() {
        if (!this.show()) {
            this.cancel();
            return EMPTY_ROOT;
        }
        Node[] nodes = this.selectedNodes;
        this.cancel();
        if (nodes == null || nodes.length == 0) {
            return EMPTY_ROOT;
        }
        ArrayList<RepositoryFile> ret = new ArrayList<RepositoryFile>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof RepositoryPathNode)) continue;
            ret.add(((RepositoryPathNode)nodes[i]).getEntry().getRepositoryFile());
        }
        return ret.toArray(new RepositoryFile[ret.size()]);
    }

    private boolean show() {
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.getBrowserPanel(), NbBundle.getMessage(Browser.class, (String)"CTL_Browser_BrowseFolders_Title"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.helpID));
        dialogDescriptor.setValid(false);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node[] nodes;
                if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = Browser.this.getSelectedNodes()) != null && nodes.length > 0) {
                    Browser.access$002(Browser.this, nodes);
                    dialogDescriptor.setValid(nodes.length > 0);
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Browser.class, (String)"CTL_Browser_BrowseFolders_Title"));
        dialog.setVisible(true);
        return DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue());
    }

    private Node[] getSelectedNodes(RepositoryPathNode rootNode, RepositoryFile repositoryRoot, RepositoryFile[] select) {
        if (select == null || select.length <= 0) {
            return null;
        }
        RepositoryPathNode segmentParentNode = null;
        ArrayList<RepositoryPathNode> nodesToSelect = new ArrayList<RepositoryPathNode>(select.length);
        for (int i = 0; i < select.length; ++i) {
            String[] segments = select[i].getPathSegments();
            segmentParentNode = rootNode;
            RepositoryFile segmentFile = repositoryRoot;
            for (int j = 0; j < segments.length; ++j) {
                segmentFile = segmentFile.appendPath(segments[j]);
                RepositoryPathNode segmentNode = j == segments.length - 1 ? RepositoryPathNode.createRepositoryPathNode((BrowserClient)this, segmentFile) : RepositoryPathNode.createPreselectedPathNode(this, segmentFile);
                segmentParentNode.getChildren().add(new Node[]{segmentNode});
                segmentParentNode = segmentNode;
            }
            nodesToSelect.add(segmentParentNode);
        }
        return nodesToSelect.toArray(new Node[nodesToSelect.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        SvnProgressSupport[] progressSupports = null;
        List<SvnProgressSupport> list = this.supportList;
        synchronized (list) {
            this.cancelled = true;
            progressSupports = this.supportList.toArray(new SvnProgressSupport[this.supportList.size()]);
            this.supportList.clear();
        }
        Node rootNode = this.getExplorerManager().getRootContext();
        if (rootNode != null) {
            this.getExplorerManager().setRootContext(Node.EMPTY);
            try {
                rootNode.destroy();
                if (progressSupports != null && progressSupports.length > 0) {
                    for (SvnProgressSupport sps : progressSupports) {
                        sps.cancel();
                    }
                }
            }
            catch (IOException ex) {
                Subversion.LOG.log(Level.INFO, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RepositoryPathNode.RepositoryPathEntry> listRepositoryPath(RepositoryPathNode.RepositoryPathEntry entry, SvnProgressSupport support) throws SVNClientException {
        ArrayList<RepositoryPathNode.RepositoryPathEntry> ret = new ArrayList<RepositoryPathNode.RepositoryPathEntry>();
        List<SvnProgressSupport> list = this.supportList;
        synchronized (list) {
            if (this.cancelled) {
                support.cancel();
                return ret;
            }
            this.supportList.add(support);
        }
        try {
            SvnClient client;
            if (entry.getSvnNodeKind().equals((Object)SVNNodeKind.FILE)) {
                list = ret;
                return list;
            }
            Subversion subversion = Subversion.getInstance();
            SVNUrl svnUrl = this.repositoryRoot.getRepositoryUrl();
            SvnClient svnClient = client = this.username != null ? subversion.getClient(svnUrl, this.username, this.password, support) : subversion.getClient(svnUrl, support);
            if (support.isCanceled()) {
                List<RepositoryPathNode.RepositoryPathEntry> list2 = null;
                return list2;
            }
            ISVNDirEntry[] dirEntries = client.getList(entry.getRepositoryFile().getFileUrl(), entry.getRepositoryFile().getRevision(), false);
            if (dirEntries == null || dirEntries.length == 0) {
                ArrayList<RepositoryPathNode.RepositoryPathEntry> arrayList = ret;
                return arrayList;
            }
            for (int i = 0; i < dirEntries.length; ++i) {
                if (support.isCanceled()) {
                    List<RepositoryPathNode.RepositoryPathEntry> list3 = null;
                    return list3;
                }
                ISVNDirEntry dirEntry = dirEntries[i];
                if (dirEntry.getNodeKind() != SVNNodeKind.DIR && (dirEntry.getNodeKind() != SVNNodeKind.FILE || (this.mode & 1) != 1)) continue;
                RepositoryFile repositoryFile = new RepositoryFile(entry.getRepositoryFile().getRepositoryUrl(), entry.getRepositoryFile().getFileUrl().appendPath(dirEntry.getPath()), (SVNRevision)dirEntry.getLastChangedRevision());
                RepositoryPathNode.RepositoryPathEntry e = new RepositoryPathNode.RepositoryPathEntry(repositoryFile, dirEntry.getNodeKind(), (SVNRevision)dirEntry.getLastChangedRevision(), dirEntry.getLastChangedDate(), dirEntry.getLastCommitAuthor());
                ret.add(e);
            }
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isWrongURLInRevision(ex.getMessage())) {
                List<RepositoryPathNode.RepositoryPathEntry> list4 = null;
                return list4;
            }
            support.annotate(ex);
            throw ex;
        }
        finally {
            List<SvnProgressSupport> list5 = this.supportList;
            synchronized (list5) {
                this.supportList.remove(support);
            }
        }
        return ret;
    }

    private JPanel getBrowserPanel() {
        return this.panel;
    }

    public Node[] getSelectedNodes() {
        return this.getExplorerManager().getSelectedNodes();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            boolean initialSelectionDone = !this.initialSelection;
            this.initialSelection = false;
            if (!this.keepWarning) {
                this.panel.warning(null);
            }
            this.keepWarning = false;
            Node[] newSelection = (Node[])evt.getNewValue();
            Node[] oldSelection = (Node[])evt.getOldValue();
            if (newSelection == null || newSelection.length == 0) {
                return;
            }
            if ((this.mode & 4) == 4 && this.checkForNodeType(newSelection, SVNNodeKind.DIR)) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_FileSelectionOnly"));
                if (initialSelectionDone) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", evt);
            }
            if ((this.mode & 8) == 8 && this.checkForNodeType(newSelection, SVNNodeKind.FILE)) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_FolderSelectionOnly"));
                if (initialSelectionDone) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", evt);
            }
            if (oldSelection.length == 0 && newSelection.length == 1) {
                return;
            }
            if (oldSelection.length != 0 && this.areDisjunct(oldSelection, newSelection)) {
                return;
            }
            Node selectedNode = null;
            selectedNode = oldSelection.length > 0 ? oldSelection[0] : newSelection[0];
            if (!this.selectionIsAtLevel(newSelection, this.getNodeLevel(selectedNode))) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_NoMultiSelection"));
                if (initialSelectionDone) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", evt);
            }
        }
    }

    private boolean checkForNodeType(Node[] newSelection, SVNNodeKind nodeKind) {
        for (int i = 0; i < newSelection.length; ++i) {
            RepositoryPathNode node;
            if (!(newSelection[i] instanceof RepositoryPathNode) || (node = (RepositoryPathNode)newSelection[i]).getEntry().getSvnNodeKind() != nodeKind) continue;
            return true;
        }
        return false;
    }

    private boolean selectionIsAtLevel(Node[] newSelection, int level) {
        for (int i = 0; i < newSelection.length; ++i) {
            if (this.getNodeLevel(newSelection[i]) == level) continue;
            return false;
        }
        return true;
    }

    private boolean areDisjunct(Node[] oldSelection, Node[] newSelection) {
        for (int i = 0; i < oldSelection.length; ++i) {
            if (!this.isInArray(oldSelection[i], newSelection)) continue;
            return false;
        }
        return true;
    }

    private int getNodeLevel(Node node) {
        int level = 0;
        while (node != null) {
            node = node.getParentNode();
            ++level;
        }
        return level;
    }

    private boolean isInArray(Node node, Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            if (node != nodeArray[i]) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getExplorerManager().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getExplorerManager().removePropertyChangeListener(listener);
    }

    ExplorerManager getExplorerManager() {
        return this.panel.getExplorerManager();
    }

    @Override
    public Action[] getActions() {
        return this.nodeActions;
    }

    void setSelectedNodes(Node[] selection) throws PropertyVetoException {
        this.getExplorerManager().setSelectedNodes(selection);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        Object obj = event.getPath().getLastPathComponent();
        if (obj == null) {
            return;
        }
        Node n = Visualizer.findNode((Object)obj);
        if (n instanceof RepositoryPathNode) {
            RepositoryPathNode node = (RepositoryPathNode)n;
            node.expand();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    static /* synthetic */ Node[] access$002(Browser x0, Node[] x1) {
        x0.selectedNodes = x1;
        return x1;
    }
}

