/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.svnclientadapter.SvnClientAdapterFactory;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientCallback;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientInvocationHandler;
import org.netbeans.modules.subversion.client.SvnCmdLineClientInvocationHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnClientFactory {
    public static final String JAVAHL_MODULE_CODE_NAME = "org.netbeans.libs.svnjavahlwin32";
    private static final String SUBVERSION_NATIVE_LIBRARY = "subversion.native.library";
    private static SvnClientFactory instance;
    private static ClientAdapterFactory factory;
    private static SVNClientException exception;
    private static boolean javahlCrash;
    private static final int JAVAHL_INIT_SUCCESS = 1;
    private static final int JAVAHL_INIT_STOP_REPORTING = 2;
    private static final Logger LOG;

    private SvnClientFactory() {
    }

    public static synchronized SvnClientFactory getInstance() {
        SvnClientFactory.init();
        return instance;
    }

    public static synchronized void init() {
        if (instance == null) {
            SvnClientFactory fac = new SvnClientFactory();
            fac.setup();
            instance = fac;
        }
    }

    public static synchronized void reset() {
        instance = null;
    }

    public static boolean isCLI() {
        SvnClientFactory.init();
        assert (factory != null);
        return factory.connectionType() == ConnectionType.cli;
    }

    public static boolean isJavaHl() {
        SvnClientFactory.init();
        assert (factory != null);
        return factory.connectionType() == ConnectionType.javahl;
    }

    public static boolean isSvnKit() {
        SvnClientFactory.init();
        assert (factory != null);
        return factory.connectionType() == ConnectionType.svnkit;
    }

    public SvnClient createSvnClient() throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        return factory.createSvnClient();
    }

    public SvnClient createSvnClient(SVNUrl repositoryUrl, SvnProgressSupport support, String username, char[] password, int handledExceptions) throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        return factory.createSvnClient(repositoryUrl, support, username, password, handledExceptions);
    }

    private void setup() {
        block7: {
            try {
                String factoryType = System.getProperty("svnClientAdapterFactory");
                SvnConfigFiles.getInstance();
                if (factoryType == null || factoryType.trim().equals("") || factoryType.trim().equals("javahl")) {
                    if (!this.setupJavaHl()) {
                        this.setupCommandline();
                    }
                    break block7;
                }
                if (factoryType.trim().equals("svnkit")) {
                    if (!this.setupSvnKit()) {
                        this.setupCommandline();
                    }
                    break block7;
                }
                if (factoryType.trim().equals("commandline")) {
                    this.setupCommandline();
                    break block7;
                }
                throw new SVNClientException("Unknown factory: " + factoryType);
            }
            catch (SVNClientException e) {
                exception = e;
            }
        }
    }

    public static void checkClientAvailable() throws SVNClientException {
        SvnClientFactory.init();
        if (exception != null) {
            throw exception;
        }
    }

    public static boolean isClientAvailable() {
        SvnClientFactory.init();
        return exception == null;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static boolean wasJavahlCrash() {
        SvnClientFactory.init();
        if (javahlCrash) {
            javahlCrash = false;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupJavaHl() {
        String jhlInitFile = System.getProperty("netbeans.user") + "/config/svn/jhlinit";
        File initFile = new File(jhlInitFile);
        if (this.checkJavahlCrash(initFile)) {
            return false;
        }
        try {
            if (!initFile.exists()) {
                initFile.createNewFile();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        this.presetJavahl();
        try {
            if (!SvnClientAdapterFactory.getInstance().setup(SvnClientAdapterFactory.Client.javahl)) {
                LOG.log(Level.INFO, "Could not setup subversion java bindings. Falling back on commandline.");
                boolean ex = false;
                return ex;
            }
            if (!this.checkJavaHlVersion()) {
                LOG.log(Level.INFO, "Unsupported version of subversion javahl bindings. Falling back on commandline.");
                boolean ex = false;
                return ex;
            }
        }
        catch (SVNClientException e) {
            LOG.log(Level.WARNING, null, e);
        }
        finally {
            this.writeJavahlInitFlag(initFile, 1);
        }
        factory = new ClientAdapterFactory(){

            @Override
            protected ISVNClientAdapter createAdapter() {
                return SvnClientAdapterFactory.getInstance().createClient();
            }

            @Override
            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
                return new SvnClientInvocationHandler(adapter, desc, support, handledExceptions);
            }

            @Override
            protected ISVNPromptUserPassword createCallback(SVNUrl repositoryUrl, int handledExceptions) {
                return new SvnClientCallback(repositoryUrl, handledExceptions);
            }

            @Override
            protected ConnectionType connectionType() {
                return ConnectionType.javahl;
            }
        };
        LOG.info("running on javahl");
        return true;
    }

    private void presetJavahl() {
        if (Utilities.isUnix() && !Utilities.isMac()) {
            this.presetJavahlUnix();
        } else if (Utilities.isWindows()) {
            this.presetJavahlWindows();
        }
    }

    private void presetJavahlUnix() {
        LOG.log(Level.FINE, "looking for svn native library...");
        String libPath = System.getProperty(SUBVERSION_NATIVE_LIBRARY);
        if (libPath != null && !libPath.trim().equals("")) {
            LOG.log(Level.FINE, "won't preset javahl due to subversion.native.library={0}", new Object[]{libPath});
            return;
        }
        String name = "libsvnjavahl-1.so";
        String[] locations = new String[]{"/usr/lib/", "/usr/lib/jni/", "/usr/local/lib/"};
        File location = null;
        for (String loc : locations) {
            File file = new File(loc, name);
            LOG.log(Level.FINE, " checking existence of {0}", new Object[]{file.getAbsolutePath()});
            if (!file.exists()) continue;
            location = file;
            break;
        }
        if (location == null) {
            location = this.getJavahlFromExecutablePath(name);
        }
        if (location != null) {
            System.setProperty(SUBVERSION_NATIVE_LIBRARY, location.getAbsolutePath());
            LOG.log(Level.FINE, "   found javahl library. Setting subversion.native.library={0}", new Object[]{location.getAbsolutePath()});
        }
    }

    private void presetJavahlWindows() {
        String libPath = System.getProperty(SUBVERSION_NATIVE_LIBRARY);
        if (libPath != null && !libPath.trim().equals("")) {
            LOG.log(Level.FINE, "preset subversion.native.library={0}", new Object[]{libPath});
            int idx = libPath.lastIndexOf(File.separator);
            if (idx > -1) {
                libPath = libPath.substring(0, idx);
                LOG.log(Level.FINE, "loading dependencies from ", new Object[]{libPath});
                this.loadJavahlDependencies(libPath);
            }
            return;
        }
        File location = InstalledFileLocator.getDefault().locate("modules/lib/libsvnjavahl-1.dll", JAVAHL_MODULE_CODE_NAME, false);
        if (location == null) {
            LOG.fine("could not find location for bundled javahl library");
            location = this.getJavahlFromExecutablePath("libsvnjavahl-1.dll");
            if (location == null) {
                return;
            }
        }
        LOG.fine("libsvnjavahl-1.dll located : " + location.getAbsolutePath());
        String locationPath = location.getParentFile().getAbsolutePath();
        this.loadJavahlDependencies(locationPath);
        locationPath = location.getAbsolutePath();
        LOG.log(Level.FINE, "setting subversion.native.library={0}", new Object[]{locationPath});
        System.setProperty(SUBVERSION_NATIVE_LIBRARY, locationPath);
    }

    private void loadJavahlDependencies(String locationPath) {
        try {
            System.load(locationPath + "/libapr-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libapriconv-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libeay32.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libdb44.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/ssleay32.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libaprutil-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/intl3_svn.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/dbghelp.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsasl.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_subr-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_delta-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_diff-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_wc-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_fs-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_repos-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_ra-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_client-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private File getJavahlFromExecutablePath(String libName) {
        String executablePath = SvnModuleConfig.getDefault().getExecutableBinaryPath();
        LOG.log(Level.FINE, "looking for svn native library in executable path={0}", new Object[]{executablePath});
        File location = new File(executablePath);
        if (location.isFile()) {
            location = location.getParentFile();
        }
        if (location != null && (location = new File(location.getAbsolutePath() + File.separatorChar + libName)).exists()) {
            LOG.log(Level.FINE, "found svn native library in executable path={0}", new Object[]{location.getAbsolutePath()});
            return location;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkJavahlCrash(File initFile) {
        if (!initFile.exists()) {
            LOG.fine("trying to init javahl first time.");
            return false;
        }
        FileReader r = null;
        try {
            r = new FileReader(initFile);
            int i = r.read();
            try {
                r.close();
                r = null;
            }
            catch (IOException e) {
                // empty catch block
            }
            switch (i) {
                case -1: {
                    this.writeJavahlInitFlag(initFile, 2);
                    javahlCrash = true;
                    LOG.log(Level.WARNING, "It appears that subversion java bindings initialization caused trouble in a previous Netbeans session. Please report.");
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    LOG.fine("won't init javahl due to problem in a previous try.");
                    boolean bl = true;
                    return bl;
                }
                case 1: {
                    LOG.fine("will try init javahl.");
                    boolean bl = false;
                    return bl;
                }
            }
            return false;
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
            return false;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavahlInitFlag(File initFile, int flag) {
        FileWriter w = null;
        try {
            w = new FileWriter(initFile);
            w.write(flag);
            w.flush();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private boolean setupSvnKit() {
        try {
            if (!SvnClientAdapterFactory.getInstance().setup(SvnClientAdapterFactory.Client.svnkit)) {
                LOG.log(Level.INFO, "Svnkit not available. Falling back on commandline!");
                return false;
            }
        }
        catch (SVNClientException ex) {
            LOG.log(Level.INFO, null, ex);
            LOG.log(Level.INFO, null, ex.getCause());
            LOG.log(Level.INFO, "Could not setup svnkit. Falling back on commandline!");
            return false;
        }
        factory = new ClientAdapterFactory(){

            @Override
            protected ISVNClientAdapter createAdapter() {
                return SvnClientAdapterFactory.getInstance().createClient();
            }

            @Override
            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
                return new SvnClientInvocationHandler(adapter, desc, support, handledExceptions);
            }

            @Override
            protected ISVNPromptUserPassword createCallback(SVNUrl repositoryUrl, int handledExceptions) {
                return new SvnClientCallback(repositoryUrl, handledExceptions);
            }

            @Override
            protected ConnectionType connectionType() {
                return ConnectionType.svnkit;
            }
        };
        LOG.info("svnClientAdapter running on svnkit");
        return true;
    }

    public void setupCommandline() {
        if (!this.checkCLIExecutable()) {
            return;
        }
        factory = new ClientAdapterFactory(){

            @Override
            protected ISVNClientAdapter createAdapter() {
                return new CommandlineClient();
            }

            @Override
            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
                return new SvnCmdLineClientInvocationHandler(adapter, desc, support, handledExceptions);
            }

            @Override
            protected ISVNPromptUserPassword createCallback(SVNUrl repositoryUrl, int handledExceptions) {
                return null;
            }

            @Override
            protected ConnectionType connectionType() {
                return ConnectionType.cli;
            }
        };
        LOG.info("running on commandline");
    }

    private boolean checkCLIExecutable() {
        exception = null;
        SVNClientException ex = null;
        try {
            this.checkVersion();
        }
        catch (SVNClientException e) {
            ex = e;
        }
        if (ex == null) {
            LOG.fine("svn client returns correct version");
            return true;
        }
        String execPath = SvnModuleConfig.getDefault().getExecutableBinaryPath();
        if (execPath != null && !execPath.trim().equals("")) {
            exception = ex;
            LOG.log(Level.WARNING, "executable binary path set to {0} yet client not available.", new Object[]{execPath});
            return false;
        }
        if (Utilities.isUnix()) {
            LOG.fine("svn client isn't set on path yet. Will check known locations...");
            String[] locations = new String[]{"/usr/local/bin/", "/usr/bin/"};
            String name = "svn";
            for (String loc : locations) {
                File file = new File(loc, name);
                LOG.log(Level.FINE, "checking existence of {0}", new Object[]{file.getAbsolutePath()});
                if (!file.exists()) continue;
                SvnModuleConfig.getDefault().setExecutableBinaryPath(loc);
                try {
                    this.checkVersion();
                }
                catch (SVNClientException e) {
                    ex = e;
                    continue;
                }
                LOG.log(Level.INFO, "found svn executable binary. Setting executable binary path to {0}", new Object[]{loc});
                return true;
            }
        }
        exception = ex;
        return false;
    }

    private void checkVersion() throws SVNClientException {
        CommandlineClient cc = new CommandlineClient();
        try {
            this.setConfigDir(cc);
            cc.checkSupportedVersion();
        }
        catch (SVNClientException e) {
            LOG.log(Level.FINE, "checking version", e);
            throw e;
        }
    }

    private boolean checkJavaHlVersion() throws SVNClientException {
        return SvnClientAdapterFactory.getInstance().isSupportedJavahlVersion();
    }

    private void setConfigDir(ISVNClientAdapter client) {
        if (client != null) {
            File configDir = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath()));
            try {
                client.setConfigDirectory(configDir);
            }
            catch (SVNClientException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
    }

    static {
        exception = null;
        javahlCrash = false;
        LOG = Logger.getLogger("org.netbeans.modules.subversion.client.SvnClientFactory");
    }

    private abstract class ClientAdapterFactory {
        private ClientAdapterFactory() {
        }

        protected abstract ISVNClientAdapter createAdapter();

        protected abstract SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter var1, SvnClientDescriptor var2, SvnProgressSupport var3, int var4);

        protected abstract ISVNPromptUserPassword createCallback(SVNUrl var1, int var2);

        protected abstract ConnectionType connectionType();

        SvnClient createSvnClient() {
            SvnClientInvocationHandler handler = this.getInvocationHandler(this.createAdapter(), this.createDescriptor(null), null, -1);
            SvnClient client = this.createSvnClient(handler);
            SvnClientFactory.this.setConfigDir(client);
            return client;
        }

        public SvnClient createSvnClient(SVNUrl repositoryUrl, SvnProgressSupport support, String username, char[] password, int handledExceptions) {
            ISVNClientAdapter adapter = this.createAdapter();
            SvnClientInvocationHandler handler = this.getInvocationHandler(adapter, this.createDescriptor(repositoryUrl), support, handledExceptions);
            this.setupAdapter(adapter, username, password, this.createCallback(repositoryUrl, handledExceptions));
            return this.createSvnClient(handler);
        }

        private SvnClientDescriptor createDescriptor(final SVNUrl repositoryUrl) {
            return new SvnClientDescriptor(){

                @Override
                public SVNUrl getSvnUrl() {
                    return repositoryUrl;
                }
            };
        }

        private SvnClient createSvnClient(SvnClientInvocationHandler handler) {
            Class<?> proxyClass = Proxy.getProxyClass(SvnClient.class.getClassLoader(), SvnClient.class);
            Subversion.getInstance().cleanupFilesystem();
            try {
                return (SvnClient)proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, null, e);
                return null;
            }
        }

        protected void setupAdapter(ISVNClientAdapter adapter, String username, char[] password, ISVNPromptUserPassword callback) {
            adapter.setUsername(username);
            if (callback != null) {
                adapter.addPasswordCallback(callback);
            } else {
                adapter.setPassword(password == null ? "" : new String(password));
            }
            try {
                File configDir = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath()));
                adapter.setConfigDirectory(configDir);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
    }

    public static enum ConnectionType {
        javahl,
        cli,
        svnkit;

    }
}

