/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.Color;
import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.versioning.util.KeyringSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbPreferences;

public class SvnModuleConfig {
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_DEFAULT_VALUES = "defaultValues";
    public static final String KEY_EXECUTABLE_BINARY = "svnExecBinary";
    public static final String KEY_ANNOTATION_FORMAT = "annotationFormat";
    public static final String SAVE_PASSWORD = "savePassword";
    private static final String FILE_SELECTOR_PREFIX = "fileSelector";
    private static final String SEARCH_HISTORY_ALL_INFO = "histAllInfo";
    public static final String KEY_RECENT_URL = "repository.recentURL";
    private static final String SHOW_CHECKOUT_COMPLETED = "checkoutCompleted.showCheckoutCompleted";
    private static final String URL_EXP = "annotator.urlExp";
    private static final String ANNOTATION_EXP = "annotator.annotationExp";
    public static final String TEXT_ANNOTATIONS_FORMAT_DEFAULT = "{DEFAULT}";
    private static final String AUTO_OPEN_OUTPUT_WINDOW = "autoOpenOutput";
    private static final String LAST_USED_MODIFICATION_CONTEXT = "lastUsedModificationContext";
    public static final String KEY_PASSWORD = "versioning.subversion.";
    public static final String KEY_CERT_PASSWORD = "versioning.subversion.cert.";
    private static final String PROP_EXCLUDE_NEW_FILES = "excludeNewFiles";
    private static final String PREFIX_REPOSITORY_PATH = "prefixRepositoryPath";
    private static final String SEPARATOR = "###";
    private static final String KEY_SORTING = "sortingStatus.";
    private static final SvnModuleConfig INSTANCE = new SvnModuleConfig();
    private Map<String, Object[]> urlCredentials;
    private Set<String> exclusions;
    private String lastCanceledCommitMessage;

    public static SvnModuleConfig getDefault() {
        return INSTANCE;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(SvnModuleConfig.class);
    }

    public boolean getShowCheckoutCompleted() {
        return this.getPreferences().getBoolean(SHOW_CHECKOUT_COMPLETED, true);
    }

    public Pattern[] getIgnoredFilePatterns() {
        return SvnModuleConfig.getDefaultFilePatterns();
    }

    public boolean isExcludedFromCommit(String path) {
        return this.getCommitExclusions().contains(path);
    }

    public void addExclusionPaths(Collection<String> paths) {
        Set<String> exclusions = this.getCommitExclusions();
        if (exclusions.addAll(paths)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(exclusions));
        }
    }

    public void removeExclusionPaths(Collection<String> paths) {
        Set<String> exclusions = this.getCommitExclusions();
        if (exclusions.removeAll(paths)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(exclusions));
        }
    }

    public String getExecutableBinaryPath() {
        return this.getPreferences().get(KEY_EXECUTABLE_BINARY, "");
    }

    public void setExecutableBinaryPath(String path) {
        this.getPreferences().put(KEY_EXECUTABLE_BINARY, path);
    }

    public String getAnnotationFormat() {
        return this.getPreferences().get(KEY_ANNOTATION_FORMAT, this.getDefaultAnnotationFormat());
    }

    public String getDefaultAnnotationFormat() {
        return "[{" + Annotator.ANNOTATION_STATUS + "} {" + Annotator.ANNOTATION_FOLDER + "}]";
    }

    public void setAnnotationFormat(String annotationFormat) {
        this.getPreferences().put(KEY_ANNOTATION_FORMAT, annotationFormat);
    }

    public void setShowCheckoutCompleted(boolean bl) {
        this.getPreferences().putBoolean(SHOW_CHECKOUT_COMPLETED, bl);
    }

    public boolean getSavePassword() {
        return this.getPreferences().getBoolean(SAVE_PASSWORD, true);
    }

    public void setSavePassword(boolean bl) {
        this.getPreferences().putBoolean(SAVE_PASSWORD, bl);
    }

    public String getFileSelectorPreset(String hash) {
        return this.getPreferences().get("fileSelector-" + hash, "");
    }

    public void setFileSelectorPreset(String hash, String path) {
        this.getPreferences().put("fileSelector-" + hash, path);
    }

    public boolean getShowFileAllInfo() {
        return this.getPreferences().getBoolean(SEARCH_HISTORY_ALL_INFO, false);
    }

    public void setShowFileAllInfo(boolean value) {
        this.getPreferences().putBoolean(SEARCH_HISTORY_ALL_INFO, value);
    }

    public boolean getAutoOpenOutput() {
        return this.getPreferences().getBoolean(AUTO_OPEN_OUTPUT_WINDOW, true);
    }

    public void setAutoOpenOutputo(boolean value) {
        this.getPreferences().putBoolean(AUTO_OPEN_OUTPUT_WINDOW, value);
    }

    public RepositoryConnection getRepositoryConnection(String url) {
        RepositoryConnection rc = this.getRepositoryConnectionIntern(url.toString());
        if (rc == null) {
            try {
                rc = this.getRepositoryConnectionIntern(new RepositoryConnection(url).getSvnUrl().toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return rc;
    }

    public void insertRecentUrl(RepositoryConnection rc) {
        Preferences prefs = this.getPreferences();
        List urlValues = Utils.getStringList((Preferences)prefs, (String)KEY_RECENT_URL);
        for (String rcOldString : urlValues) {
            RepositoryConnection rcOld = RepositoryConnection.parse(rcOldString);
            if (!rcOld.equals(rc)) continue;
            Utils.removeFromArray((Preferences)prefs, (String)KEY_RECENT_URL, (String)rcOldString);
        }
        this.handleCredentials(rc);
        this.storeCredentials(rc);
        String url = RepositoryConnection.getString(rc);
        if (!"".equals(url)) {
            Utils.insert((Preferences)prefs, (String)KEY_RECENT_URL, (String)url, (int)-1);
        }
    }

    public void setRecentUrls(List<RepositoryConnection> recentUrls) {
        ArrayList<String> urls = new ArrayList<String>(recentUrls.size());
        int idx = 0;
        Iterator<RepositoryConnection> it = recentUrls.iterator();
        while (it.hasNext()) {
            ++idx;
            RepositoryConnection rc = it.next();
            this.handleCredentials(rc);
            this.storeCredentials(rc);
            String url = RepositoryConnection.getString(rc);
            if ("".equals(url)) continue;
            urls.add(url);
        }
        Preferences prefs = this.getPreferences();
        Utils.put((Preferences)prefs, (String)KEY_RECENT_URL, urls);
    }

    public List<RepositoryConnection> getRecentUrls() {
        Preferences prefs = this.getPreferences();
        List urls = Utils.getStringList((Preferences)prefs, (String)KEY_RECENT_URL);
        ArrayList<RepositoryConnection> ret = new ArrayList<RepositoryConnection>(urls.size());
        LinkedList<RepositoryConnection> withPassword = new LinkedList<RepositoryConnection>();
        for (String urlString : urls) {
            RepositoryConnection rc = RepositoryConnection.parse(urlString);
            if (rc.getPassword() != null || rc.getCertPassword() != null) {
                withPassword.add(rc);
                continue;
            }
            if (this.getUrlCredentials().containsKey(rc.getUrl())) {
                Object[] creds = this.getUrlCredentials().get(rc.getUrl());
                if (creds.length < 2) continue;
                rc = new RepositoryConnection(rc.getUrl(), (String)creds[0], (char[])creds[1], rc.getExternalCommand(), rc.getSavePassword(), rc.getCertFile(), rc.getCertPassword());
            } else if (!EventQueue.isDispatchThread()) {
                char[] password = KeyringSupport.read((String)KEY_PASSWORD, (String)rc.getUrl().toString());
                char[] certPassword = KeyringSupport.read((String)KEY_CERT_PASSWORD, (String)rc.getUrl().toString());
                rc = new RepositoryConnection(rc.getUrl(), rc.getUsername(), password, rc.getExternalCommand(), rc.getSavePassword(), rc.getCertFile(), certPassword);
            }
            ret.add(rc);
        }
        if (withPassword.size() > 0) {
            for (RepositoryConnection conn : withPassword) {
                this.insertRecentUrl(conn);
            }
            return this.getRecentUrls();
        }
        return ret;
    }

    public void setAnnotationExpresions(List<AnnotationExpression> exps) {
        ArrayList<String> urlExp = new ArrayList<String>(exps.size());
        ArrayList<String> annotationExp = new ArrayList<String>(exps.size());
        int idx = 0;
        Iterator<AnnotationExpression> it = exps.iterator();
        while (it.hasNext()) {
            ++idx;
            AnnotationExpression exp = it.next();
            urlExp.add(exp.getUrlExp());
            annotationExp.add(exp.getAnnotationExp());
        }
        Preferences prefs = this.getPreferences();
        Utils.put((Preferences)prefs, (String)URL_EXP, urlExp);
        Utils.put((Preferences)prefs, (String)ANNOTATION_EXP, annotationExp);
    }

    public List<AnnotationExpression> getAnnotationExpresions() {
        Preferences prefs = this.getPreferences();
        List urlExp = Utils.getStringList((Preferences)prefs, (String)URL_EXP);
        List annotationExp = Utils.getStringList((Preferences)prefs, (String)ANNOTATION_EXP);
        List<AnnotationExpression> ret = new ArrayList<AnnotationExpression>(urlExp.size());
        for (int i = 0; i < urlExp.size(); ++i) {
            ret.add(new AnnotationExpression((String)urlExp.get(i), (String)annotationExp.get(i)));
        }
        if (ret.size() < 1) {
            ret = this.getDefaultAnnotationExpresions();
        }
        return ret;
    }

    public List<AnnotationExpression> getDefaultAnnotationExpresions() {
        ArrayList<AnnotationExpression> ret = new ArrayList<AnnotationExpression>(1);
        ret.add(new AnnotationExpression(".*/(branches|tags)/(.+?)(/.*)?", "\\2"));
        return ret;
    }

    public int getLastUsedModificationContext() {
        int lastUsedContext = this.getPreferences().getInt(LAST_USED_MODIFICATION_CONTEXT, 0);
        if (lastUsedContext != 0 && lastUsedContext != 1 && lastUsedContext != 2) {
            lastUsedContext = 0;
        }
        return lastUsedContext;
    }

    public void setLastUsedModificationContext(int lastUsedContext) {
        this.getPreferences().putInt(LAST_USED_MODIFICATION_CONTEXT, lastUsedContext);
    }

    public boolean getExludeNewFiles() {
        return this.getPreferences().getBoolean(PROP_EXCLUDE_NEW_FILES, false);
    }

    public void setExcludeNewFiles(boolean excludeNewFiles) {
        this.getPreferences().putBoolean(PROP_EXCLUDE_NEW_FILES, excludeNewFiles);
    }

    public Color getColor(String colorName, Color defaultColor) {
        int colorRGB = this.getPreferences().getInt(colorName, defaultColor.getRGB());
        return new Color(colorRGB);
    }

    public void setColor(String colorName, Color value) {
        this.getPreferences().putInt(colorName, value.getRGB());
    }

    public String getLastCanceledCommitMessage() {
        return this.lastCanceledCommitMessage == null ? "" : this.lastCanceledCommitMessage;
    }

    public void setLastCanceledCommitMessage(String message) {
        this.lastCanceledCommitMessage = message;
    }

    public boolean isRepositoryPathPrefixed() {
        return this.getPreferences().getBoolean(PREFIX_REPOSITORY_PATH, false);
    }

    public void setRepositoryPathPrefixed(boolean prefixRepositoryPath) {
        this.getPreferences().putBoolean(PREFIX_REPOSITORY_PATH, prefixRepositoryPath);
    }

    public LinkedHashMap<String, Integer> getSortingStatus(String panel) {
        LinkedHashMap<String, Integer> sortingState = null;
        String packed = this.getPreferences().get(KEY_SORTING + panel, null);
        if (packed != null) {
            String[] tokens = packed.split(SEPARATOR);
            sortingState = new LinkedHashMap<String, Integer>(tokens.length >> 1);
            int i = 0;
            while (i < tokens.length - 1) {
                String column = tokens[i++];
                try {
                    Integer colState = Integer.parseInt(tokens[i++]);
                    sortingState.put(column, colState);
                }
                catch (NumberFormatException ex) {}
            }
        }
        return sortingState;
    }

    public void setSortingStatus(String panel, Map<String, Integer> sortingState) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> e : sortingState.entrySet()) {
            sb.append(e.getKey()).append(SEPARATOR).append(e.getValue().toString()).append(SEPARATOR);
        }
        if (sb.length() > 0) {
            this.getPreferences().put(KEY_SORTING + panel, sb.toString());
        } else {
            this.getPreferences().remove(KEY_SORTING + panel);
        }
    }

    private synchronized Set<String> getCommitExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<String>(Utils.getStringList((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS));
        }
        return this.exclusions;
    }

    private static Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }

    private void handleCredentials(RepositoryConnection rc) {
        if (!rc.getSavePassword()) {
            this.getUrlCredentials().put(rc.getUrl(), new Object[]{rc.getUsername(), rc.getPassword()});
        } else {
            this.getUrlCredentials().remove(rc.getUrl());
        }
    }

    private Map<String, Object[]> getUrlCredentials() {
        if (this.urlCredentials == null) {
            this.urlCredentials = new HashMap<String, Object[]>();
        }
        return this.urlCredentials;
    }

    private RepositoryConnection getRepositoryConnectionIntern(String url) {
        String rcUrl;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        List<RepositoryConnection> rcs = this.getRecentUrls();
        for (RepositoryConnection rc : rcs) {
            rcUrl = rc.getUrl();
            if (rcUrl.endsWith("/")) {
                rcUrl = rcUrl.substring(0, rcUrl.length() - 1);
            }
            if (!url.equals(rcUrl)) continue;
            return rc;
        }
        for (RepositoryConnection rc : rcs) {
            rcUrl = rc.getUrl();
            if (rcUrl.endsWith("/")) {
                rcUrl = rcUrl.substring(0, rcUrl.length() - 1);
            }
            if (!rcUrl.startsWith(url)) continue;
            return rc;
        }
        return null;
    }

    private void storeCredentials(final RepositoryConnection rc) {
        if (rc.getSavePassword() && rc.getPassword() != null || rc.getCertPassword() != null) {
            Runnable outOfAWT = new Runnable(){

                @Override
                public void run() {
                    if (rc.getSavePassword() && rc.getPassword() != null) {
                        KeyringSupport.save((String)SvnModuleConfig.KEY_PASSWORD, (String)rc.getUrl().toString(), (char[])((char[])rc.getPassword().clone()), null);
                    }
                    if (rc.getCertPassword() != null) {
                        KeyringSupport.save((String)SvnModuleConfig.KEY_CERT_PASSWORD, (String)rc.getUrl().toString(), (char[])((char[])rc.getCertPassword().clone()), null);
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                Subversion.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }
    }
}

