/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.spi.editor.AbstractEditorAction;

public final class GotoAction
extends AbstractEditorAction {
    private static final Logger LOG = Logger.getLogger(GotoAction.class.getName());
    private static final long serialVersionUID = 1L;

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        String actionName = this.actionName();
        if ("goto-declaration".equals(actionName)) {
            this.resetCaretMagicPosition(target);
            BaseDocument doc = Utilities.getDocument((JTextComponent)target);
            if (doc != null) {
                try {
                    int decPos;
                    Caret caret = target.getCaret();
                    int dotPos = caret.getDot();
                    int[] idBlk = Utilities.getIdentifierBlock((BaseDocument)doc, (int)dotPos);
                    ExtSyntaxSupport extSup = (ExtSyntaxSupport)doc.getSyntaxSupport();
                    if (idBlk != null && (decPos = extSup.findDeclarationPosition(doc.getText(idBlk), idBlk[1])) >= 0) {
                        caret.setDot(decPos);
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }
    }
}

