/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.util.NbBundle;

public class ValidatorsPanel
extends JPanel {
    private WSDLComponent comp;
    private Project p;
    private boolean inSync = false;
    private String profile;
    private ConfigVersion cfgVersion = null;
    private JButton certificateValidatorButton;
    private JLabel certificateValidatorLabel;
    private JTextField certificateValidatorTextField;
    private JToggleButton jToggleButton1;
    private JButton samlValidatorButton;
    private JLabel samlValidatorLabel;
    private JTextField samlValidatorTextField;
    private JButton timestampValidatorButton;
    private JLabel timestampValidatorLabel;
    private JTextField timestampValidatorTextField;
    private JButton usernameValidatorButton;
    private JLabel usernameValidatorLabel;
    private JTextField usernameValidatorTextField;

    public ValidatorsPanel(WSDLComponent wSDLComponent, Project project, String string, ConfigVersion configVersion) {
        this.comp = wSDLComponent;
        this.p = project;
        this.profile = string;
        this.cfgVersion = configVersion;
        this.initComponents();
        this.usernameValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.usernameValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.timestampValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.timestampValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certificateValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certificateValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.samlValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.samlValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
    }

    private String getValidator(String string) {
        if ("usernameValidator".equals(string)) {
            return this.usernameValidatorTextField.getText();
        }
        if ("timestampValidator".equals(string)) {
            return this.timestampValidatorTextField.getText();
        }
        if ("certificateValidator".equals(string)) {
            return this.certificateValidatorTextField.getText();
        }
        if ("samlAssertionValidator".equals(string)) {
            return this.samlValidatorTextField.getText();
        }
        return null;
    }

    private void setValidator(String string, String string2) {
        if ("usernameValidator".equals(string)) {
            this.usernameValidatorTextField.setText(string2);
        }
        if ("timestampValidator".equals(string)) {
            this.timestampValidatorTextField.setText(string2);
        }
        if ("certificateValidator".equals(string)) {
            this.certificateValidatorTextField.setText(string2);
        }
        if ("samlAssertionValidator".equals(string)) {
            this.samlValidatorTextField.setText(string2);
        }
    }

    private void sync() {
        String string;
        String string2;
        String string3;
        this.inSync = true;
        String string4 = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "usernameValidator");
        if (string4 != null) {
            this.setValidator("usernameValidator", string4);
        }
        if ((string3 = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "timestampValidator")) != null) {
            this.setValidator("timestampValidator", string3);
        }
        if ((string2 = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "certificateValidator")) != null) {
            this.setValidator("certificateValidator", string2);
        }
        if ((string = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "samlAssertionValidator")) != null) {
            this.setValidator("samlAssertionValidator", string);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void enableDisable() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        if (ComboConstants.PROF_USERNAME.equals(this.profile)) {
            bl = false;
            bl3 = false;
            bl4 = false;
        }
        if (ComboConstants.PROF_MUTUALCERT.equals(this.profile) || ComboConstants.PROF_ENDORSCERT.equals(this.profile)) {
            bl = false;
            bl2 = false;
            bl4 = false;
        }
        if (ComboConstants.PROF_MSGAUTHSSL.equals(this.profile)) {
            bl = false;
            bl4 = false;
        }
        if (ComboConstants.PROF_SAMLSSL.equals(this.profile) || ComboConstants.PROF_SAMLHOLDER.equals(this.profile) || ComboConstants.PROF_SAMLSENDER.equals(this.profile)) {
            bl3 = false;
            bl2 = false;
            bl4 = false;
        }
        this.samlValidatorButton.setEnabled(bl);
        this.samlValidatorLabel.setEnabled(bl);
        this.samlValidatorTextField.setEnabled(bl);
        this.usernameValidatorButton.setEnabled(bl2);
        this.usernameValidatorLabel.setEnabled(bl2);
        this.usernameValidatorTextField.setEnabled(bl2);
        this.timestampValidatorButton.setEnabled(bl4);
        this.timestampValidatorLabel.setEnabled(bl4);
        this.timestampValidatorTextField.setEnabled(bl4);
        this.certificateValidatorButton.setEnabled(bl3);
        this.certificateValidatorLabel.setEnabled(bl3);
        this.certificateValidatorTextField.setEnabled(bl3);
    }

    public void storeState() {
        String string = this.getValidator("usernameValidator");
        if (string == null || string.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "usernameValidator", null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "usernameValidator", string, false);
        }
        String string2 = this.getValidator("certificateValidator");
        if (string2 == null || string2.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "certificateValidator", null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "certificateValidator", string2, false);
        }
        String string3 = this.getValidator("timestampValidator");
        if (string3 == null || string3.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "timestampValidator", null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "timestampValidator", string3, false);
        }
        String string4 = this.getValidator("samlAssertionValidator");
        if (string4 == null || string4.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "samlAssertionValidator", null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "samlAssertionValidator", string4, false);
        }
    }

    private void initComponents() {
        this.jToggleButton1 = new JToggleButton();
        this.usernameValidatorLabel = new JLabel();
        this.timestampValidatorLabel = new JLabel();
        this.certificateValidatorLabel = new JLabel();
        this.samlValidatorLabel = new JLabel();
        this.usernameValidatorTextField = new JTextField();
        this.timestampValidatorTextField = new JTextField();
        this.certificateValidatorTextField = new JTextField();
        this.samlValidatorTextField = new JTextField();
        this.usernameValidatorButton = new JButton();
        this.timestampValidatorButton = new JButton();
        this.certificateValidatorButton = new JButton();
        this.samlValidatorButton = new JButton();
        this.jToggleButton1.setText("jToggleButton1");
        this.usernameValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_UsernameVLabel"));
        this.timestampValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_TimestampVLabel"));
        this.certificateValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_CertificateVLabel"));
        this.samlValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_SAMLVLabel"));
        this.usernameValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.usernameValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorsPanel.this.usernameValidatorButtonActionPerformed(actionEvent);
            }
        });
        this.timestampValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.timestampValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorsPanel.this.timestampValidatorButtonActionPerformed(actionEvent);
            }
        });
        this.certificateValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.certificateValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorsPanel.this.certificateValidatorButtonActionPerformed(actionEvent);
            }
        });
        this.samlValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.samlValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorsPanel.this.samlValidatorButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.timestampValidatorLabel).add((Component)this.certificateValidatorLabel).add((Component)this.samlValidatorLabel).add((Component)this.usernameValidatorLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.samlValidatorTextField, -2, 296, -2).addPreferredGap(0)).add((Component)this.certificateValidatorTextField, -2, 305, -2).add((Component)this.timestampValidatorTextField, -2, 308, -2)).add((Component)this.usernameValidatorTextField, -2, 308, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.samlValidatorButton).add((Component)this.certificateValidatorButton).add((Component)this.timestampValidatorButton).add((Component)this.usernameValidatorButton)).addPreferredGap(0).add((Component)this.jToggleButton1, -2, 0, -2)));
        groupLayout.linkSize(new Component[]{this.certificateValidatorTextField, this.samlValidatorTextField, this.timestampValidatorTextField, this.usernameValidatorTextField}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(69, 69, 69).add((Component)this.jToggleButton1)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.usernameValidatorLabel).add((Component)this.usernameValidatorButton).add((Component)this.usernameValidatorTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.timestampValidatorLabel).add((Component)this.timestampValidatorButton).add((Component)this.timestampValidatorTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.certificateValidatorLabel).add((Component)this.certificateValidatorButton).add((Component)this.certificateValidatorTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.samlValidatorLabel).add((Component)this.samlValidatorButton).add((Component)this.samlValidatorTextField, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void samlValidatorButtonActionPerformed(ActionEvent actionEvent) {
        block1: {
            Set<String> set;
            Iterator<String> iterator;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.SAMLAssertionValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (set = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String string = iterator.next();
                this.setValidator("samlAssertionValidator", string);
            }
        }
    }

    private void certificateValidatorButtonActionPerformed(ActionEvent actionEvent) {
        block1: {
            Set<String> set;
            Iterator<String> iterator;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.CertificateValidationCallback.CertificateValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (set = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String string = iterator.next();
                this.setValidator("certificateValidator", string);
            }
        }
    }

    private void timestampValidatorButtonActionPerformed(ActionEvent actionEvent) {
        block1: {
            Set<String> set;
            Iterator<String> iterator;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.TimestampValidationCallback.TimestampValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (set = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String string = iterator.next();
                this.setValidator("timestampValidator", string);
            }
        }
    }

    private void usernameValidatorButtonActionPerformed(ActionEvent actionEvent) {
        block1: {
            Set<String> set;
            Iterator<String> iterator;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.PasswordValidationCallback.PasswordValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (set = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String string = iterator.next();
                this.setValidator("usernameValidator", string);
            }
        }
    }
}

