/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsruntimemodel;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.xml.namespace.QName;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.websvc.wsitconf.util.AbstractTask;
import org.netbeans.modules.websvc.wsitconf.util.SourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JavaWsdlMapper {
    public static final String RESPONSE = "Response";
    public static final String RETURN = "return";
    public static final String BEAN = "Bean";
    public static final String SERVICE = "Service";
    public static final String PORT = "Port";
    public static final String PORT_TYPE = "PortType";
    public static final String BINDING = "Binding";
    private static final String JAVAX_JWS_WEBSERVICE = "javax.jws.WebService";
    private static final String UTF8 = "UTF-8";
    public static final int UNKNOWN = -1;
    public static final int OUTPUTINPUT = 0;
    public static final int OUTPUT = 1;
    public static final int INPUT = 2;

    public static String getNamespace(String string) {
        String[] stringArray;
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() == 0) {
            stringArray = new String[]{};
        } else {
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = stringTokenizer.countTokens() - 1; i >= 0; --i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        }
        StringBuilder stringBuilder = new StringBuilder("http://");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append('/');
        return stringBuilder.toString();
    }

    public static QName getServiceName(FileObject fileObject) {
        final String[] stringArray = new String[2];
        if (fileObject == null) {
            return null;
        }
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(compilationController);
                    if (sourceUtils == null) {
                        return;
                    }
                    TypeElement typeElement = sourceUtils.getTypeElement();
                    stringArray[0] = typeElement.getSimpleName().toString() + JavaWsdlMapper.SERVICE;
                    String string = JavaWsdlMapper.getPackageFromClass(typeElement.getQualifiedName().toString());
                    stringArray[1] = JavaWsdlMapper.getNamespace(string);
                    List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                    for (AnnotationMirror annotationMirror : list) {
                        Name name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
                        if (!name.contentEquals(JavaWsdlMapper.JAVAX_JWS_WEBSERVICE)) continue;
                        String string2 = null;
                        String string3 = null;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                            ExecutableElement executableElement = entry.getKey();
                            String string4 = (String)entry.getValue().getValue();
                            if (executableElement.getSimpleName().contentEquals("serviceName")) {
                                string2 = string4;
                                if (string2 != null) {
                                    string2 = URLEncoder.encode(string2, JavaWsdlMapper.UTF8);
                                }
                            } else if (executableElement.getSimpleName().contentEquals("targetNamespace") && (string3 = string4) != null) {
                                string3 = URLEncoder.encode(string3, JavaWsdlMapper.UTF8);
                            }
                            if (string3 == null || string2 == null) continue;
                            break;
                        }
                        if (string2 != null) {
                            stringArray[0] = string2;
                        }
                        if (string3 == null) continue;
                        stringArray[1] = string3;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (stringArray[0] == null) {
            return null;
        }
        return new QName(stringArray[1], stringArray[0]);
    }

    public static String getBindingName(FileObject fileObject, String string) {
        QName qName = JavaWsdlMapper.getPortName(fileObject, string);
        if (qName != null) {
            return qName.getLocalPart() + BINDING;
        }
        return null;
    }

    public static List<String> getOperationFaults(FileObject fileObject, final String string) {
        if (fileObject == null || string == null) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(compilationController);
                    TypeElement typeElement = sourceUtils.getTypeElement();
                    List<? extends Element> list = typeElement.getEnclosedElements();
                    List<ExecutableElement> list2 = ElementFilter.methodsIn(list);
                    for (ExecutableElement executableElement : list2) {
                        Set<Modifier> set = executableElement.getModifiers();
                        if (!set.contains((Object)Modifier.PUBLIC)) continue;
                        List<? extends AnnotationMirror> list3 = executableElement.getAnnotationMirrors();
                        boolean bl = false;
                        String string4 = null;
                        block1: for (AnnotationMirror annotationMirror : list3) {
                            TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebMethod");
                            if (typeElement2 == null || !compilationController.getTypes().isSameType(typeElement2.asType(), annotationMirror.getAnnotationType())) continue;
                            bl = true;
                            Object object = annotationMirror.getElementValues();
                            for (Map.Entry entry : object.entrySet()) {
                                ExecutableElement executableElement2 = (ExecutableElement)entry.getKey();
                                String string2 = (String)((AnnotationValue)entry.getValue()).getValue();
                                if (executableElement2.getSimpleName().contentEquals("operationName") && (string4 = string2) != null) {
                                    string4 = URLEncoder.encode(string4, JavaWsdlMapper.UTF8);
                                }
                                if (string4 == null) continue;
                                break block1;
                            }
                        }
                        Object object4 = executableElement.getSimpleName().toString();
                        if (bl && string4 != null) {
                            object4 = string4;
                        }
                        if (!string.equals(object4)) continue;
                        List<? extends TypeMirror> list4 = executableElement.getThrownTypes();
                        for (Object object : list4) {
                            String string3 = JavaWsdlMapper.getTypeName(compilationController, (TypeMirror)object);
                            if (string3 == null) continue;
                            arrayList.add(string3);
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return arrayList;
    }

    static String getTypeName(CompilationController compilationController, TypeMirror typeMirror) {
        TypeKind typeKind = typeMirror.getKind();
        switch (typeKind) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case SHORT: {
                return "short";
            }
            case VOID: {
                return "void";
            }
            case DECLARED: {
                Element element = compilationController.getTypes().asElement(typeMirror);
                return ((TypeElement)element).getSimpleName().toString();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                Element element = compilationController.getTypes().asElement(arrayType.getComponentType());
                return ((TypeElement)element).getSimpleName().toString() + "[]";
            }
        }
        return null;
    }

    public static List<String> getOperationNames(FileObject fileObject) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        if (fileObject == null) {
            return null;
        }
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(compilationController);
                    TypeElement typeElement = sourceUtils.getTypeElement();
                    List<? extends Element> list = typeElement.getEnclosedElements();
                    List<ExecutableElement> list2 = ElementFilter.methodsIn(list);
                    boolean bl = false;
                    for (ExecutableElement executableElement : list2) {
                        Set<Modifier> set = executableElement.getModifiers();
                        if (!set.contains((Object)Modifier.PUBLIC)) continue;
                        List<? extends AnnotationMirror> list3 = executableElement.getAnnotationMirrors();
                        boolean bl2 = false;
                        String string = null;
                        block1: for (AnnotationMirror annotationMirror : list3) {
                            TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebMethod");
                            if (typeElement2 == null || !compilationController.getTypes().isSameType(typeElement2.asType(), annotationMirror.getAnnotationType())) continue;
                            bl2 = true;
                            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                                ExecutableElement executableElement2 = entry.getKey();
                                String string2 = (String)entry.getValue().getValue();
                                if (executableElement2.getSimpleName().contentEquals("operationName") && (string = string2) != null) {
                                    string = URLEncoder.encode(string, JavaWsdlMapper.UTF8);
                                }
                                if (string == null) continue;
                                break block1;
                            }
                        }
                        if (bl2) {
                            if (!bl) {
                                bl = true;
                                if (!arrayList.isEmpty()) {
                                    arrayList.clear();
                                }
                            }
                            if (string != null) {
                                arrayList.add(string);
                                continue;
                            }
                            arrayList.add(executableElement.getSimpleName().toString());
                            continue;
                        }
                        arrayList.add(executableElement.getSimpleName().toString());
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return arrayList;
    }

    public static QName getPortTypeName(FileObject fileObject) {
        final String[] stringArray = new String[2];
        if (fileObject == null) {
            return null;
        }
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                /*
                 * WARNING - void declaration
                 */
                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(compilationController);
                    TypeElement typeElement = sourceUtils.getTypeElement();
                    stringArray[0] = typeElement.getSimpleName().toString();
                    List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                    for (AnnotationMirror annotationMirror : list) {
                        void object2;
                        Name name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
                        if (!name.contentEquals(JavaWsdlMapper.JAVAX_JWS_WEBSERVICE)) continue;
                        String string = null;
                        String string2 = null;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                            ExecutableElement executableElement = entry.getKey();
                            String string3 = (String)entry.getValue().getValue();
                            if (executableElement.getSimpleName().contentEquals("name")) {
                                string = string3;
                                if (string != null) {
                                    string = URLEncoder.encode(string, JavaWsdlMapper.UTF8);
                                }
                            } else if (executableElement.getSimpleName().contentEquals("targetNamespace") && (string2 = string3) != null) {
                                string2 = URLEncoder.encode(string2, JavaWsdlMapper.UTF8);
                            }
                            if (string2 == null || string == null) continue;
                            break;
                        }
                        if (string != null && string.length() > 0) {
                            stringArray[0] = string;
                        }
                        String string4 = JavaWsdlMapper.getPackageFromClass(typeElement.getQualifiedName().toString());
                        String string5 = string2;
                        if (string5 == null || string5.length() == 0) {
                            String string6 = JavaWsdlMapper.getNamespace(string4);
                        }
                        stringArray[1] = object2;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return new QName(stringArray[1], stringArray[0]);
    }

    public static String getWsdlLocation(FileObject fileObject) {
        final String[] stringArray = new String[1];
        try {
            if (fileObject == null) {
                return null;
            }
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(compilationController);
                    TypeElement typeElement = sourceUtils.getTypeElement();
                    List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                    for (AnnotationMirror annotationMirror : list) {
                        Name name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
                        if (!name.contentEquals(JavaWsdlMapper.JAVAX_JWS_WEBSERVICE)) continue;
                        String string = null;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                            ExecutableElement executableElement = entry.getKey();
                            String string2 = (String)entry.getValue().getValue();
                            if (executableElement.getSimpleName().contentEquals("wsdlLocation") && (string = string2) != null) {
                                string = URLEncoder.encode(string, JavaWsdlMapper.UTF8);
                            }
                            if (string == null) continue;
                            break;
                        }
                        stringArray[1] = string;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringArray[0];
    }

    public static QName getPortName(FileObject fileObject, final String string) {
        final String[] stringArray = new String[2];
        if (fileObject == null) {
            return null;
        }
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(compilationController);
                    TypeElement typeElement = sourceUtils.getTypeElement();
                    String string7 = typeElement.getSimpleName().toString();
                    List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                    for (AnnotationMirror annotationMirror : list) {
                        Name name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
                        if (!name.contentEquals(JavaWsdlMapper.JAVAX_JWS_WEBSERVICE)) continue;
                        String string2 = null;
                        String string3 = null;
                        String string4 = null;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                            ExecutableElement executableElement = entry.getKey();
                            String string5 = (String)entry.getValue().getValue();
                            if (executableElement.getSimpleName().contentEquals("name")) {
                                string3 = string5;
                                if (string3 != null) {
                                    string3 = URLEncoder.encode(string3, JavaWsdlMapper.UTF8);
                                }
                            } else if (executableElement.getSimpleName().contentEquals("portName")) {
                                string2 = string5;
                                if (string2 != null) {
                                    string2 = URLEncoder.encode(string2, JavaWsdlMapper.UTF8);
                                }
                            } else if (executableElement.getSimpleName().contentEquals("targetNamespace") && (string4 = string5) != null) {
                                string4 = URLEncoder.encode(string4, JavaWsdlMapper.UTF8);
                            }
                            if (string4 == null || string3 == null || string2 == null) continue;
                            break;
                        }
                        stringArray[0] = string2 != null && string2.length() > 0 ? string2 : (string3 != null && string3.length() > 0 ? string3 + JavaWsdlMapper.PORT : string7 + JavaWsdlMapper.PORT);
                        if (string != null) continue;
                        if (string4 != null && string4.length() > 0) {
                            stringArray[1] = string4;
                            continue;
                        }
                        String string6 = JavaWsdlMapper.getPackageFromClass(string7);
                        stringArray[1] = JavaWsdlMapper.getNamespace(string6);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return new QName(stringArray[1], stringArray[0]);
    }

    public static String getPackageFromClass(String string) {
        return string.substring(0, string.lastIndexOf(46));
    }
}

