/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.refactoring;

import java.io.IOException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.netbeans.modules.web.common.refactoring.RenamePanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private RenamePanel panel;
    private final FileObject file;

    public RenameRefactoringUI(FileObject file) {
        this.file = file;
        this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{file}));
    }

    public String getName() {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)"LBL_Rename");
    }

    public String getDescription() {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)"LBL_FolderRefactoring");
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new RenamePanel(this.file.getName(), parent, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename"));
        }
        return this.panel;
    }

    public Problem setParameters() {
        String newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(newName);
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.panel.getNameValue());
        }
        return this.refactoring.fastCheckParameters();
    }

    public boolean hasParameters() {
        return true;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public boolean isRefactoringBypassRequired() {
        return this.panel.isRenameWithoutRefactoring();
    }

    public void doRefactoringBypass() throws IOException {
        DataObject dob = DataObject.find((FileObject)this.file);
        if (dob != null) {
            dob.rename(this.panel.getNameValue());
        }
    }
}

