/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.ui;

import com.sun.javacard.AID;
import com.sun.javacard.filemodels.AppletXmlAppletEntry;
import com.sun.javacard.filemodels.AppletXmlModel;
import com.sun.javacard.filemodels.DeploymentXmlAppletEntry;
import com.sun.javacard.filemodels.DeploymentXmlModel;
import com.sun.javacard.filemodels.FileModelEntry;
import com.sun.javacard.filemodels.ParseErrorHandler;
import com.sun.javacard.filemodels.WebXmlModel;
import com.sun.javacard.filemodels.WebXmlServletEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public class FileModelFactory {
    public static final String ORDER = "order";
    public static final String DISPLAY_NAME = "display-name";
    public static final String APPLET_CLASS = "applet-class";
    public static final String APPLET_AID = "applet-AID";
    public static final String DEFAULT = "default";
    public static final String SERVLET_MAPPING = "mapping";
    public static final String SERVLET_NAME = "servletName";
    public static final String DEPLOYMENT_ENTRY = "deploymentInfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppletXmlModel appletXmlModel(FileObject fo, ParseErrorHandler handler) throws IOException {
        InputStream in = fo.getInputStream();
        try {
            AppletXmlModel mdl;
            AppletXmlModel appletXmlModel = mdl = new AppletXmlModel(in, handler);
            return appletXmlModel;
        }
        finally {
            in.close();
        }
    }

    public static AppletXmlModel appletXmlModel(Node[] nodes) {
        AppletXmlModel result = new AppletXmlModel();
        for (Node n : nodes) {
            String name = (String)n.getValue(DISPLAY_NAME);
            AID aid = (AID)n.getValue(APPLET_AID);
            Integer order = (Integer)n.getValue(ORDER);
            String clazz = (String)n.getLookup().lookup(String.class);
            boolean selected = Boolean.TRUE.equals(n.getValue("selected"));
            if (clazz == null || !selected) continue;
            int o = order == null ? Integer.MAX_VALUE : order;
            AppletXmlAppletEntry info = new AppletXmlAppletEntry(name, clazz, aid, o);
            result.add((FileModelEntry)info);
        }
        result.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebXmlModel webXmlModel(FileObject fo, ParseErrorHandler handler) throws IOException {
        InputStream in = fo.getInputStream();
        try {
            WebXmlModel mdl;
            WebXmlModel webXmlModel = mdl = new WebXmlModel(in, handler);
            return webXmlModel;
        }
        finally {
            in.close();
        }
    }

    public static WebXmlModel webXmlModel(Node[] nodes) {
        WebXmlModel result = new WebXmlModel();
        for (Node n : nodes) {
            String mapping = (String)n.getValue(SERVLET_MAPPING);
            String name = (String)n.getValue(SERVLET_NAME);
            Integer order = (Integer)n.getValue(ORDER);
            String clazz = (String)n.getLookup().lookup(String.class);
            boolean selected = Boolean.TRUE.equals(n.getValue("selected"));
            boolean isDefault = Boolean.TRUE.equals(n.getValue(DEFAULT));
            if (isDefault) {
                result.setDefaultServlet(name);
                result.setDefaultMapping(mapping);
            }
            if (clazz == null || !selected) continue;
            int o = order == null ? Integer.MAX_VALUE : order;
            WebXmlServletEntry info = new WebXmlServletEntry(name, clazz, mapping, o);
            result.add((FileModelEntry)info);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentXmlModel deploymentXmlModel(FileObject fo, ParseErrorHandler handler) throws IOException {
        InputStream in = fo.getInputStream();
        try {
            DeploymentXmlModel deploymentXmlModel = new DeploymentXmlModel(in, handler);
            return deploymentXmlModel;
        }
        finally {
            in.close();
        }
    }

    public static DeploymentXmlModel deploymentXmlModel(Node[] nodes) {
        DeploymentXmlModel result = new DeploymentXmlModel();
        for (Node n : nodes) {
            String displayName;
            if (!Boolean.TRUE.equals(n.getValue("selected"))) continue;
            String classname = (String)n.getLookup().lookup(String.class);
            AID aid = (AID)n.getValue(APPLET_AID);
            DeploymentXmlAppletEntry entry = (DeploymentXmlAppletEntry)n.getValue(DEPLOYMENT_ENTRY);
            if (!classname.equals(entry.getClazzHint())) {
                entry.setClazzHint(classname);
            }
            if (entry.getAppletAid() == null || aid != null && !aid.equals((Object)entry.getAppletAid())) {
                entry.setAppletAid(aid);
            }
            if ((displayName = (String)n.getValue(DISPLAY_NAME)) != null && !displayName.equals(entry.getDisplayNameHint())) {
                entry.setDisplayNameHint(displayName);
            }
            if (entry.isEmpty()) continue;
            result.add((FileModelEntry)entry);
        }
        result.close();
        return result;
    }

    public static void writeTo(DeploymentXmlModel mdl, Node[] nodes) {
        for (Node n : nodes) {
            String classname = (String)n.getLookup().lookup(String.class);
            DeploymentXmlAppletEntry byAid = null;
            DeploymentXmlAppletEntry byClassName = null;
            DeploymentXmlAppletEntry byDisplayName = null;
            for (DeploymentXmlAppletEntry e : mdl.getData()) {
                String displayName;
                AID aid = e.getAppletAid();
                if (aid != null && aid.equals(n.getValue(APPLET_AID))) {
                    byAid = e;
                }
                if (classname.equals(e.getClazzHint())) {
                    byClassName = e;
                }
                if ((displayName = e.getDisplayNameHint()) != null && displayName.equals(n.getValue(DISPLAY_NAME))) {
                    byDisplayName = e;
                }
                if (byClassName == null || byAid == null) continue;
                break;
            }
            DeploymentXmlAppletEntry entry = byAid != null ? byAid : (byClassName != null ? byClassName : (byDisplayName != null ? byDisplayName : null));
            entry = entry == null ? new DeploymentXmlAppletEntry() : (DeploymentXmlAppletEntry)entry.clone();
            n.setValue(DEPLOYMENT_ENTRY, (Object)entry);
        }
    }

    public static void writeTo(AppletXmlModel mdl, Node[] nodes) {
        if (mdl.isError()) {
            return;
        }
        List dataCopy = mdl.getData();
        for (Node n : nodes) {
            String classname = (String)n.getLookup().lookup(String.class);
            if (classname == null) continue;
            boolean matched = false;
            for (AppletXmlAppletEntry info : dataCopy) {
                if (!classname.equals(info.getClassname())) continue;
                matched = true;
                if (info.getAID() != null) {
                    n.setValue(APPLET_AID, (Object)info.getAID());
                }
                if (info.getDisplayName() != null) {
                    n.setValue(DISPLAY_NAME, (Object)info.getDisplayName());
                }
                n.setValue(ORDER, (Object)info.getOrder());
                n.setValue("selected", (Object)Boolean.TRUE);
                break;
            }
            if (matched) continue;
            n.setValue("selected", (Object)Boolean.FALSE);
        }
    }

    public static void writeTo(WebXmlModel mdl, Node[] nodes) {
        if (mdl.isError()) {
            return;
        }
        List dataCopy = mdl.getData();
        for (Node n : nodes) {
            String classname = (String)n.getLookup().lookup(String.class);
            if (classname == null) continue;
            boolean matched = false;
            for (WebXmlServletEntry info : dataCopy) {
                if (!classname.equals(info.getType())) continue;
                matched = true;
                if (info.getMapping() != null) {
                    n.setValue(SERVLET_MAPPING, (Object)info.getMapping());
                }
                if (info.getName() != null) {
                    n.setValue(SERVLET_NAME, (Object)info.getName());
                }
                n.setValue(ORDER, (Object)info.getOrder());
                n.setValue("selected", (Object)Boolean.TRUE);
                break;
            }
            if (matched) continue;
            n.setValue("selected", (Object)Boolean.FALSE);
        }
    }
}

