/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.project.ui.customizer.SourceRootsUi;
import org.netbeans.modules.javacard.JCUtil;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.JCStoreGroup;
import org.netbeans.modules.javacard.project.SourceLevelComboBoxModel;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.DependenciesProvider;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.project.deps.ResolvedDependency;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.PlatformAndDeviceProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class JCProjectProperties
implements PlatformAndDeviceProvider {
    protected final JCProject project;
    protected String platformName = "";
    protected String activeDevice = "Default Device";
    public DefaultTableModel SOURCE_ROOTS_MODEL;
    private SourceLevelComboBoxModel JAVAC_SOURCE_MODEL;
    private String sourceEncoding;
    private String javacSourceLevel;
    private String javacTargetLevel;
    public DefaultListModel classPathModel;
    public JToggleButton.ToggleButtonModel COMPILE_ON_SAVE_BUTTON_MODEL;
    public Document ADDITIONAL_COMPILER_OPTIONS_DOCUMENT;
    public Document KEYSTORE_ALIAS_DOCUMENT;
    public Document KEYSTORE_PASSWORD_DOCUMENT;
    public Document KEYSTORE_ALIAS_PASSWORD_DOCUMENT;
    public JToggleButton.ToggleButtonModel GENERATE_DEBUG_INFO_BUTTON_MODEL;
    public JToggleButton.ToggleButtonModel ENABLE_DEPRECATION_BUTTON_MODEL;
    public JToggleButton.ToggleButtonModel SIGN_JAR_BUTTON_MODEL;
    public Document KEYSTORE_DOCUMENT;
    private JCStoreGroup group = new JCStoreGroup();
    private StoreGroup passwordsGroup = new StoreGroup();
    ResolvedDependencies deps;

    public JCProjectProperties(JCProject project) {
        this.project = project;
        if (project != null) {
            this.init(project);
        }
    }

    public JCProjectProperties() {
        this(null);
    }

    private void init(JCProject project) {
        this.SOURCE_ROOTS_MODEL = SourceRootsUi.createModel((SourceRoots)project.getRoots());
        PropertyEvaluator eval = project.evaluator();
        this.COMPILE_ON_SAVE_BUTTON_MODEL = this.group.createToggleButtonModel(eval, "compile.on.save");
        this.ADDITIONAL_COMPILER_OPTIONS_DOCUMENT = this.group.createStringDocument(eval, "javac.args");
        this.GENERATE_DEBUG_INFO_BUTTON_MODEL = this.group.createToggleButtonModel(eval, "javac.debug");
        this.ENABLE_DEPRECATION_BUTTON_MODEL = this.group.createToggleButtonModel(eval, "javac.deprecation");
        this.SIGN_JAR_BUTTON_MODEL = this.group.createToggleButtonModel(eval, "sign.bundle");
        this.KEYSTORE_DOCUMENT = this.group.createResolvingDocument(eval, "sign.keystore", "javacard.home", "javacard.ri.home", "basedir");
        this.KEYSTORE_ALIAS_DOCUMENT = this.group.createStringDocument(eval, "sign.alias");
        this.KEYSTORE_PASSWORD_DOCUMENT = this.passwordsGroup.createStringDocument(eval, "sign.storepass");
        this.KEYSTORE_ALIAS_PASSWORD_DOCUMENT = this.passwordsGroup.createStringDocument(eval, "sign.passkey");
        this.sourceEncoding = eval.getProperty("source.encoding");
        this.javacSourceLevel = eval.getProperty("javac.source");
        this.javacTargetLevel = eval.getProperty("javac.target");
        this.activeDevice = eval.getProperty("active.device");
        this.platformName = eval.getProperty("platform.active");
        if (this.platformName == null) {
            this.platformName = "javacard_default";
        }
        if (this.activeDevice == null) {
            this.activeDevice = "Default Device";
        }
        if (this.javacSourceLevel == null) {
            this.javacSourceLevel = "1.6";
        }
        if (this.javacTargetLevel == null) {
            this.javacTargetLevel = "1.6";
        }
        if (this.sourceEncoding == null) {
            this.sourceEncoding = "UTF-8";
        }
        this.JAVAC_SOURCE_MODEL = new SourceLevelComboBoxModel(this, this.javacSourceLevel, this.javacTargetLevel, new SpecificationVersion("1.3"));
        this.classPathModel = new DefaultListModel();
        String str = project.evaluator().getProperty("class.path");
        if (str == null) {
            str = "";
        }
        for (String s : str.split(File.pathSeparator)) {
            this.classPathModel.addElement(s);
        }
    }

    public JComboBox createSourceLevelComboBox() {
        JComboBox box = new JComboBox(this.JAVAC_SOURCE_MODEL);
        box.setRenderer(new SourceLevelComboBoxModel.SourceLevelListCellRenderer());
        return box;
    }

    public String getJavacSourceLevel() {
        return this.javacSourceLevel;
    }

    public void setJavacSourceLevel(String javacSourceLevel) {
        this.javacSourceLevel = javacSourceLevel;
    }

    public String getJavacTargetLevel() {
        return this.javacTargetLevel;
    }

    public void setJavacTargetLevel(String javacTargetLevel) {
        this.javacTargetLevel = javacTargetLevel;
    }

    public JCProject getProject() {
        return this.project;
    }

    public String getActiveDevice() {
        return this.activeDevice;
    }

    public void setActiveDevice(String val) {
        this.activeDevice = val;
    }

    public void setSourceEncoding(String encName) {
        this.sourceEncoding = encName;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public final void storeProperties() {
        try {
            this.onBeforeStoreProperties();
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    EditableProperties props = JCProjectProperties.this.project.getAntProjectHelper().getProperties("nbproject/project.properties");
                    EditableProperties priv = JCProjectProperties.this.project.getAntProjectHelper().getProperties("nbproject/private/private.properties");
                    JCProjectProperties.this.storeCommonProperties(props, priv);
                    Boolean result = JCProjectProperties.this.onStoreProperties(props);
                    if (result.booleanValue()) {
                        JCProjectProperties.this.project.getAntProjectHelper().putProperties("nbproject/project.properties", props);
                        JCProjectProperties.this.project.getAntProjectHelper().putProperties("nbproject/private/private.properties", priv);
                    }
                    JCProjectProperties.this.storeDependencies();
                    return result;
                }
            });
        }
        catch (MutexException me) {
            Exceptions.printStackTrace((Throwable)me);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDependencies() throws IOException {
        ResolvedDependencies d;
        JCProjectProperties jCProjectProperties = this;
        synchronized (jCProjectProperties) {
            d = this.deps;
        }
        if (d != null && d.isModified()) {
            d.save();
            this.legacyStoreDependencies(d);
        }
    }

    protected Boolean onStoreProperties(EditableProperties props) throws IOException {
        return true;
    }

    protected void onBeforeStoreProperties() throws IOException {
    }

    private void storeCommonProperties(EditableProperties props, EditableProperties priv) throws IOException {
        props.put("source.encoding", this.sourceEncoding);
        props.put("javac.source", this.javacSourceLevel);
        props.put("javac.target", this.javacTargetLevel);
        props.put("active.device", this.activeDevice);
        props.put("platform.active", this.platformName);
        StringBuilder sb = new StringBuilder();
        for (Object o : this.classPathModel.toArray()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(o);
        }
        props.setProperty("class.path", sb.toString());
        this.passwordsGroup.store(priv);
        this.storeRoots(this.project.getRoots(), this.SOURCE_ROOTS_MODEL, props);
        this.group.store(props);
        if (!this.SIGN_JAR_BUTTON_MODEL.isSelected()) {
            props.remove((Object)"sign.bundle");
        }
    }

    private void storeRoots(SourceRoots roots, DefaultTableModel tableModel, EditableProperties props) throws MalformedURLException {
        Vector<Vector> data = tableModel.getDataVector();
        URL[] rootURLs = new URL[data.size()];
        String[] rootLabels = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            Vector v = data.elementAt(i);
            File f = (File)v.elementAt(0);
            rootURLs[i] = JCProjectProperties.getRootURL(f, null);
            rootLabels[i] = (String)v.elementAt(1);
        }
        roots.putRoots(rootURLs, rootLabels);
        String[] rootPropertyNames = roots.getRootProperties();
        FileObject[] rootFolders = roots.getRoots();
        LinkedList<Integer> foreignRootIndices = new LinkedList<Integer>();
        FileObject projectDir = this.project.getProjectDirectory();
        for (int i = 0; i < rootFolders.length; ++i) {
            String rootProp = rootPropertyNames[i];
            if (FileUtil.isParentOf((FileObject)projectDir, (FileObject)rootFolders[i])) {
                String relPath = FileUtil.getRelativePath((FileObject)projectDir, (FileObject)rootFolders[i]);
                props.setProperty(rootProp, relPath);
                continue;
            }
            foreignRootIndices.add(i);
        }
        if (!foreignRootIndices.isEmpty()) {
            EditableProperties privProps = this.project.getAntProjectHelper().getProperties("nbproject/private/private.properties");
            ReferenceHelper rh = this.project.getReferenceHelper();
            Iterator i$ = foreignRootIndices.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                String rootProp = rootPropertyNames[i];
                File file = FileUtil.toFile((FileObject)rootFolders[i]);
                String val = rh.createForeignFileReference(file, "java");
                privProps.put(rootProp, val);
            }
            this.project.getAntProjectHelper().putProperties("nbproject/private/private.properties", privProps);
        }
    }

    public static URL getRootURL(File root, String offset) throws MalformedURLException {
        URL url = FileUtil.urlForArchiveOrDir((File)root);
        if (url == null) {
            throw new IllegalArgumentException(root.getAbsolutePath());
        }
        if (offset != null) {
            assert (offset.endsWith("/"));
            url = new URL(url.toExternalForm() + offset);
        }
        return url;
    }

    public final DefaultListModel getClassPathModel() {
        return this.classPathModel;
    }

    public final String getPlatformName() {
        return this.platformName;
    }

    public final JavacardPlatform getPlatform() {
        return this.platformName == null ? null : JCUtil.findPlatformNamed(this.platformName);
    }

    public void setPlatformName(String platformName) {
        if (!platformName.equals(this.platformName)) {
            this.platformName = platformName;
            if (this.JAVAC_SOURCE_MODEL != null) {
                this.JAVAC_SOURCE_MODEL.platformChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cancellable getDependencies(DependenciesProvider.Receiver r) {
        ResolvedDependencies d = null;
        JCProjectProperties jCProjectProperties = this;
        synchronized (jCProjectProperties) {
            if (this.deps != null) {
                d = this.deps;
            }
        }
        if (d != null) {
            r.receive(d);
            return null;
        }
        DependenciesProvider p = (DependenciesProvider)this.project.getLookup().lookup(DependenciesProvider.class);
        if (p != null) {
            R receiver = new R(r);
            return p.requestDependencies(receiver);
        }
        return null;
    }

    @Deprecated
    private void legacyStoreDependencies(ResolvedDependencies d) {
        StringBuilder sb = new StringBuilder();
        for (ResolvedDependency resolvedDependency : d.all()) {
            String path = resolvedDependency.getPath(ArtifactKind.ORIGIN);
            if (path == null || sb.length() <= 0) continue;
            sb.append(File.pathSeparatorChar);
            sb.append(path);
        }
        EditableProperties p = this.project.getAntProjectHelper().getProperties("nbproject/project.properties");
        p.put("class.path", sb.toString());
    }

    private class R
    implements DependenciesProvider.Receiver {
        private final DependenciesProvider.Receiver r;

        private R(DependenciesProvider.Receiver r) {
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(ResolvedDependencies deps) {
            ResolvedDependencies d = deps;
            JCProjectProperties jCProjectProperties = JCProjectProperties.this;
            synchronized (jCProjectProperties) {
                d = JCProjectProperties.this.deps == null ? (JCProjectProperties.this.deps = deps) : JCProjectProperties.this.deps;
            }
            this.r.receive(d);
        }

        @Override
        public boolean failed(Throwable failure) {
            return this.r.failed(failure);
        }
    }
}

