/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.platformdefinition;

import java.awt.Component;
import java.text.MessageFormat;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.platformdefinition.BrokenPlatformCustomizer;
import org.netbeans.modules.j2me.cdc.platform.platformdefinition.CDCPlatformCustomizer;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class CDCPlatformNode
extends AbstractNode {
    private CDCPlatform platform;
    private String toolTip;

    public CDCPlatformNode(CDCPlatform platform, DataObject definition) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{platform, definition}));
        this.platform = platform;
        super.setIconBaseWithExtension("org/netbeans/modules/j2me/cdc/platform/resources/cdcPlatform.png");
    }

    public String getDisplayName() {
        return this.platform.getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (this.isBroken()) {
            return "<font color=\"#A40000\">" + this.platform.getDisplayName() + "</font>";
        }
        return null;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public void setName(String name) {
        this.platform.setDisplayName(name);
    }

    public void setDisplayName(String name) {
        this.setName(name);
    }

    public synchronized String getShortDescription() {
        if (this.toolTip == null) {
            this.toolTip = MessageFormat.format(NbBundle.getMessage(CDCPlatformNode.class, (String)"TXT_J2SEPlatformToolTip"), this.platform.getSpecification().getVersion());
        }
        return this.toolTip;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        if (this.isBroken()) {
            return new BrokenPlatformCustomizer(this.platform);
        }
        return new CDCPlatformCustomizer(this.platform);
    }

    private boolean isBroken() {
        return this.platform.getInstallFolders().size() == 0;
    }
}

