/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors.table;

import java.util.Vector;
import javax.swing.table.DefaultTableModel;

class CustomEditorTableModel
extends DefaultTableModel {
    private Vector<String> header = new Vector();
    private boolean hasHeader;

    CustomEditorTableModel() {
    }

    public void removeLastColumn() {
        int columnCount;
        if (this.hasHeader && this.header.size() > 0) {
            this.header.remove(this.header.size() - 1);
        }
        if ((columnCount = this.getColumnCount()) > 0) {
            int size = this.dataVector.size();
            for (int i = 0; i < size; ++i) {
                Vector row = (Vector)this.dataVector.elementAt(i);
                row.remove(columnCount - 1);
            }
        }
        this.fireTableStructureChanged();
    }

    @Override
    public void removeRow(int row) {
        this.dataVector.removeElementAt(row);
        this.fireTableStructureChanged();
    }

    @Override
    public void addRow(Object[] rowData) {
        this.dataVector.addElement(CustomEditorTableModel.convertToVector(rowData));
        this.fireTableStructureChanged();
    }

    public void addColumn(String columnName, boolean needRow) {
        if (this.hasHeader) {
            this.header.addElement(columnName);
        }
        if (this.dataVector.size() > 0) {
            for (int i = 0; i < this.dataVector.size(); ++i) {
                Vector row = (Vector)this.dataVector.elementAt(i);
                row.addElement(columnName);
            }
        } else if (needRow) {
            Vector<String> row = new Vector<String>(1);
            row.add(columnName);
            this.dataVector.addElement(row);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size() + (this.hasHeader ? 1 : 0);
    }

    @Override
    public int getColumnCount() {
        if (this.hasHeader) {
            return this.header.size();
        }
        if (this.dataVector.size() > 0) {
            return ((Vector)this.dataVector.get(0)).size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = this.hasHeader ? (row == 0 ? this.header.elementAt(column) : super.getValueAt(row - 1, column)) : super.getValueAt(row, column);
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.hasHeader) {
            if (row == 0) {
                this.header.setElementAt((String)aValue, column);
                this.fireTableStructureChanged();
            } else {
                super.setValueAt(aValue, row - 1, column);
            }
        } else {
            super.setValueAt(aValue, row, column);
        }
    }

    @Override
    public void setDataVector(Object[][] dataArrays, Object[] columnArray) {
        if (this.hasHeader) {
            this.header.clear();
            for (int i = 0; i < columnArray.length; ++i) {
                this.header.addElement((String)columnArray[i]);
            }
        }
        this.dataVector = CustomEditorTableModel.nonNullVector(CustomEditorTableModel.convertToVector(dataArrays));
        this.fireTableStructureChanged();
    }

    private static Vector nonNullVector(Vector v) {
        return v != null ? v : new Vector();
    }

    public void clear() {
        this.dataVector.clear();
        this.fireTableStructureChanged();
    }

    public void setUseHeader(boolean useHeader) {
        if (useHeader && this.header.size() != this.getColumnCount()) {
            this.header.clear();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.header.addElement("");
            }
        }
        this.hasHeader = useHeader;
        this.fireTableStructureChanged();
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public Vector<String> getHeader() {
        return this.header;
    }
}

