/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Trouble;

abstract class TestRecognizerHandler {
    private static final Logger LOGGER = Logger.getLogger(TestRecognizerHandler.class.getName());
    private static final Pattern[] STRING_COMPARISON = new Pattern[]{Pattern.compile("<\"(.*)\"> expected but was <\"(.*)\">.*"), Pattern.compile(".*expected \"(.*)\", got \"(.*)\".*")};
    protected final Pattern pattern;
    protected Matcher matcher;

    TestRecognizerHandler(String regex) {
        if (!regex.endsWith(".*")) {
            regex = regex + ".*";
        }
        if (!regex.startsWith(".*")) {
            regex = ".*" + regex;
        }
        this.pattern = Pattern.compile(regex, 32);
    }

    final boolean matches(String line) {
        return this.match(line).matches();
    }

    final Matcher match(String line) {
        this.matcher = this.pattern.matcher(line);
        return this.matcher;
    }

    abstract void updateUI(Manager var1, TestSession var2);

    List<String> getRecognizedOutput() {
        return Collections.emptyList();
    }

    protected static int toMillis(String timeInSeconds) {
        try {
            Double elapsedTimeMillis = Double.parseDouble(timeInSeconds) * 1000.0;
            return elapsedTimeMillis.intValue();
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.WARNING, "Could not parse time, returning 0", nfe);
            return 0;
        }
    }

    protected static Trouble.ComparisonFailure getComparisonFailure(String msg) {
        if (msg == null) {
            return null;
        }
        for (Pattern pattern : STRING_COMPARISON) {
            Matcher comparisonMatcher = pattern.matcher(msg);
            if (!comparisonMatcher.matches()) continue;
            return new Trouble.ComparisonFailure(TestRecognizerHandler.toMultipleLines(comparisonMatcher.group(1)), TestRecognizerHandler.toMultipleLines(comparisonMatcher.group(2)));
        }
        return null;
    }

    private static String toMultipleLines(String toConvert) {
        return toConvert.replace("\\n", "\n");
    }

    protected static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }
}

