/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import javax.swing.ImageIcon;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.schema.completion.CompletionPaintComponent;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.model.Attribute;

public class ElementResultItem
extends CompletionResultItem {
    private int caretPosition = 0;
    private String replacingText;

    public ElementResultItem(AbstractElement element, CompletionContext context) {
        this(element, context, null);
    }

    public ElementResultItem(AbstractElement element, CompletionContext context, TokenSequence tokenSequence) {
        super((AXIComponent)element, context, tokenSequence);
        this.itemText = element.getName();
        this.icon = new ImageIcon(CompletionResultItem.class.getResource("/org/netbeans/modules/xml/schema/completion/resources/element.png"));
    }

    public ElementResultItem(AbstractElement element, String prefix, CompletionContext context) {
        super((AXIComponent)element, context);
        this.itemText = prefix + ":" + element.getName();
        this.icon = new ImageIcon(CompletionResultItem.class.getResource("/org/netbeans/modules/xml/schema/completion/resources/element.png"));
    }

    @Override
    public String getDisplayText() {
        AbstractElement element = (AbstractElement)this.axiComponent;
        String cardinality = null;
        if (this.axiComponent.supportsCardinality() && element.getMinOccurs() != null && element.getMaxOccurs() != null) {
            cardinality = "[" + element.getMinOccurs() + ".." + element.getMaxOccurs() + "]";
        }
        String displayText = this.itemText;
        if (cardinality != null) {
            displayText = displayText + " " + cardinality;
        }
        return displayText;
    }

    @Override
    public String getReplacementText() {
        this.replacingText = null;
        AbstractElement element = (AbstractElement)this.axiComponent;
        StringBuffer buffer = new StringBuffer();
        boolean firstAttr = false;
        for (AbstractAttribute aa : element.getAttributes()) {
            Attribute a;
            if (aa instanceof AnyAttribute || (a = (Attribute)aa).getUse() != Attribute.Use.REQUIRED) continue;
            if (buffer.length() == 0) {
                firstAttr = true;
            }
            buffer.append(" " + a.getName() + "=\"\"");
            if (!firstAttr) continue;
            this.caretPosition = buffer.length() - 1;
            firstAttr = false;
        }
        this.replacingText = "<" + this.itemText + buffer.toString() + ">";
        return this.replacingText;
    }

    @Override
    public CompletionPaintComponent getPaintComponent() {
        if (this.component == null) {
            this.component = new CompletionPaintComponent.ElementPaintComponent(this);
        }
        return this.component;
    }

    @Override
    public int getCaretPosition() {
        return (this.replacingText == null ? 0 : this.replacingText.length()) + this.caretPosition;
    }
}

