/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class Utils {
    public static final String VERSIONED_JAR_SUFFIX_MATCHER = "(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final int PORT_CHECK_TIMEOUT = 4000;
    private static byte[] TEST_QUERY = new byte[]{22, 3, 0, 0, 83, 1, 0, 0, 79, 3, 0, 63, 71, -41, -9, -70, 44, -18, -22, -78, 96, 126, -13, 0, -3, -126, 123, -71, -43, -106, -56, 119, -101, -26, -60, -37, 60, 61, -37, 111, -17, 16, 110, 0, 0, 40, 0, 22, 0, 19, 0, 10, 0, 102, 0, 5, 0, 4, 0, 101, 0, 100, 0, 99, 0, 98, 0, 97, 0, 96, 0, 21, 0, 18, 0, 9, 0, 20, 0, 17, 0, 8, 0, 6, 0, 3, 1, 0, 71, 69, 84, 32, 47, 99, 111, 109, 95, 115, 117, 110, 95, 119, 101, 98, 95, 117, 105, 32, 72, 84, 84, 80, 47, 49, 46, 48, 10, 10};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File f) {
        if (Utilities.isWindows()) {
            boolean retVal = true;
            File tmp = null;
            if (!f.exists()) {
                retVal = false;
            } else if (f.isDirectory()) {
                try {
                    tmp = File.createTempFile("foo", ".tmp", f);
                }
                catch (IOException ex) {
                    retVal = false;
                }
                finally {
                    if (null != tmp) {
                        tmp.delete();
                    }
                }
            } else {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(f, true);
                }
                catch (FileNotFoundException ex) {
                    retVal = false;
                }
                finally {
                    if (null != fos) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            Logger.getLogger(Utils.class.getName()).log(Level.FINEST, null, ioe);
                        }
                    }
                }
            }
            return retVal;
        }
        return f.canWrite();
    }

    public static File getFileFromPattern(String jarNamePattern, File modulesDir) {
        assert (jarNamePattern != null) : "jarNamePattern should not be null";
        if (null == jarNamePattern) {
            Logger.getLogger("glassfish").log(Level.INFO, "caller passed invalid jarNamePattern", new NullPointerException("jarNamePattern"));
            return null;
        }
        assert (modulesDir != null) : "modulesDir  should not be null";
        if (null == modulesDir) {
            Logger.getLogger("glassfish").log(Level.INFO, "caller passed invalid param", new NullPointerException("modulesDir"));
            return null;
        }
        int subindex = jarNamePattern.lastIndexOf("/");
        if (subindex != -1) {
            String subdir = jarNamePattern.substring(0, subindex);
            jarNamePattern = jarNamePattern.substring(subindex + 1);
            modulesDir = new File(modulesDir, subdir);
        }
        if (modulesDir.canRead() && modulesDir.isDirectory()) {
            String expressPattern = jarNamePattern.replace(VERSIONED_JAR_SUFFIX_MATCHER, ".jar");
            File candidate = new File(modulesDir, expressPattern);
            if (!"".equals(expressPattern) && candidate.exists()) {
                return candidate;
            }
            File[] candidates = modulesDir.listFiles(new VersionFilter(jarNamePattern));
            if (candidates != null && candidates.length > 0) {
                return candidates[0];
            }
        }
        return null;
    }

    public static String sanitizeName(String name) {
        if (null == name || name.matches("[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_./;#]*")) {
            return name;
        }
        return "_" + name.replaceAll("[^\\p{L}\\p{N}\\-_./;#]", "_");
    }

    public static final String escapePath(String path) {
        return path.replace("\\", "\\\\").replace("$", "\\$");
    }

    public static String getHttpListenerProtocol(String hostname, String port) {
        String retVal = "http";
        try {
            retVal = Utils.getHttpListenerProtocol(hostname, Integer.parseInt(port));
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger("glassfish").log(Level.INFO, "returning http due to exception", nfe);
        }
        return retVal;
    }

    public static String getHttpListenerProtocol(String hostname, int port) {
        String retVal = "http";
        try {
            if (Utils.isSecurePort(hostname, port)) {
                retVal = "https";
            }
        }
        catch (ConnectException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
        catch (SocketException ex) {
            Logger.getLogger("glassfish").log(Level.FINE, null, ex);
        }
        catch (SocketTimeoutException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
        return retVal;
    }

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        return Utils.isSecurePort(hostname, port, 0);
    }

    private static boolean isSecurePort(String hostname, int port, int depth) throws IOException, ConnectException, SocketTimeoutException {
        Socket socket;
        block11: {
            socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(hostname, port), 4000);
                socket.setSoTimeout(4000);
            }
            catch (SocketException ex) {
                String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block11;
                String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                System.setProperty("socksNonProxyHosts", socksNonProxyHosts + localhost);
                if (depth < 1) {
                    return Utils.isSecurePort(hostname, port, 1);
                }
                ConnectException ce = new ConnectException();
                ce.initCause(ex);
                throw ce;
            }
        }
        OutputStream ostream = socket.getOutputStream();
        ostream.write(TEST_QUERY);
        InputStream istream = socket.getInputStream();
        byte[] input = new byte[8192];
        istream.read(input);
        socket.close();
        String response = new String(input).toLowerCase(Locale.ENGLISH);
        boolean isSecure = true;
        if (response.length() == 0) {
            throw new ConnectException();
        }
        if (response.startsWith("http/1.")) {
            isSecure = false;
        } else if (response.indexOf("<html") != -1) {
            isSecure = false;
        } else if (response.indexOf("</html") != -1) {
            isSecure = false;
        } else if (response.indexOf("connection: ") != -1) {
            isSecure = false;
        }
        return isSecure;
    }

    public static void doCopy(FileObject from, FileObject toParent) throws IOException {
        if (null != from) {
            if (from.isFolder()) {
                FileObject copy = FileUtil.createFolder((FileObject)toParent, (String)from.getNameExt());
                FileObject[] kids = from.getChildren();
                for (int i = 0; i < kids.length; ++i) {
                    Utils.doCopy(kids[i], copy);
                }
            } else {
                assert (from.isData());
                FileObject target = toParent.getFileObject(from.getName(), from.getExt());
                if (null == target) {
                    FileUtil.copyFile((FileObject)from, (FileObject)toParent, (String)from.getName(), (String)from.getExt());
                }
            }
        }
    }

    private static class VersionFilter
    implements FileFilter {
        private final Pattern pattern;

        public VersionFilter(String namePattern) {
            this.pattern = Pattern.compile(namePattern);
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }
}

