/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ServerCommand {
    public static final char QUERY_SEPARATOR = '?';
    public static final char PARAM_SEPARATOR = '&';
    protected final String command;
    protected String query = null;
    protected boolean retry = false;

    public ServerCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRequestMethod() {
        return "GET";
    }

    public boolean getDoOutput() {
        return false;
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() {
        return null;
    }

    public String getInputName() {
        return null;
    }

    public String getLastModified() {
        return null;
    }

    public boolean retry() {
        return this.retry;
    }

    public boolean handleResponse(int responseCode) {
        return responseCode == 200;
    }

    public boolean readResponse(InputStream in) throws IOException {
        boolean result = false;
        Manifest m = new Manifest();
        m.read(in);
        String outputCode = m.getMainAttributes().getValue("exit-code");
        if (outputCode.equalsIgnoreCase("Success")) {
            this.readManifest(m);
            result = true;
        } else {
            String message = m.getMainAttributes().getValue("message");
            if (message != null && message.contains("please wait")) {
                this.retry = true;
            }
            Logger.getLogger("glassfish").log(Level.WARNING, message);
        }
        return result;
    }

    public void readManifest(Manifest manifest) throws IOException {
    }

    public boolean processResponse() {
        return true;
    }

    public String toString() {
        return this.query == null ? this.command : this.command + '?' + this.query;
    }

    public static final class SetPropertyCommand
    extends ServerCommand {
        private Manifest info;

        public SetPropertyCommand(String property, String value, String format) {
            super("set");
            this.query = MessageFormat.format(format, property, value);
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            return this.info != null;
        }
    }

    public static final class GetPropertyCommand
    extends ServerCommand {
        private Manifest info;
        private Map<String, String> propertyMap;

        public GetPropertyCommand(String property) {
            super("get");
            this.query = "pattern=" + property;
            this.propertyMap = new HashMap<String, String>();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            if (this.info == null) {
                return false;
            }
            for (String key : this.info.getEntries().keySet()) {
                int equalsIndex = key.indexOf(61);
                if (equalsIndex >= 0) {
                    try {
                        this.propertyMap.put(key.substring(0, equalsIndex), URLDecoder.decode(URLDecoder.decode(key.substring(equalsIndex + 1), "UTF-8"), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException ex) {}
                    continue;
                }
                this.propertyMap.put(key, "");
            }
            return true;
        }

        public Map<String, String> getData() {
            return this.propertyMap;
        }
    }
}

