/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.testrunner.spi;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.TestSession;

public abstract class TestRecognizerHandler {
    private static final Logger LOGGER = Logger.getLogger(TestRecognizerHandler.class.getName());
    protected final Pattern pattern;
    protected Matcher matcher;

    public TestRecognizerHandler(String regex) {
        if (!regex.endsWith(".*")) {
            regex = regex + ".*";
        }
        if (!regex.startsWith(".*") && !regex.startsWith("(.*)")) {
            regex = ".*" + regex;
        }
        this.pattern = Pattern.compile(regex, 32);
    }

    public final boolean matches(String line) {
        return this.match(line).matches();
    }

    public final Matcher match(String line) {
        this.matcher = this.pattern.matcher(line);
        return this.matcher;
    }

    public abstract void updateUI(Manager var1, TestSession var2);

    public List<String> getRecognizedOutput() {
        return Collections.emptyList();
    }

    protected static int toMillis(String timeInSeconds) {
        try {
            Double elapsedTimeMillis = Double.parseDouble(timeInSeconds) * 1000.0;
            return elapsedTimeMillis.intValue();
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.WARNING, "Could not parse time, returning 0", nfe);
            return 0;
        }
    }
}

