/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

public class DLightMath {
    private DLightMath() {
    }

    public static int map(int value, int a, int b, int x, int y) {
        if (value <= a) {
            return x;
        }
        if (value < b) {
            return x + (value - a) * (y - x) / (b - a);
        }
        return y;
    }

    public static long map(long value, long a, long b, long x, long y) {
        if (value <= a) {
            return x;
        }
        if (value < b) {
            return x + (value - a) * (y - x) / (b - a);
        }
        return y;
    }

    public static <T extends Comparable<? super T>> T max(T a, T b) {
        if (a == null || b == null) {
            return null;
        }
        if (0 < a.compareTo(b)) {
            return a;
        }
        return b;
    }

    public static <T extends Comparable<? super T>> T min(T a, T b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.compareTo(b) <= 0) {
            return a;
        }
        return b;
    }

    public static long nearestMultipleOf(long multiplier, long value) {
        long remainder = value % multiplier;
        if (remainder < multiplier / 2L) {
            return value - remainder;
        }
        return value - remainder + multiplier;
    }

    public static long prevMultipleOf(long multiplier, long value) {
        long remainder = value % multiplier;
        if (remainder == 0L) {
            return value - multiplier;
        }
        return value - remainder;
    }

    public static long nextMultipleOf(long multiplier, long value) {
        long remainder = value % multiplier;
        return value - remainder + multiplier;
    }

    public static float[] ensureSumLessOrEqual(float limit, float ... values) {
        float[] result = (float[])values.clone();
        float sum = 0.0f;
        for (float value : values) {
            sum += value;
        }
        if (limit < sum) {
            float scale = limit / sum;
            int i = 0;
            while (i < values.length) {
                int n = i++;
                result[n] = result[n] * scale;
            }
        }
        return result;
    }
}

