/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi;

import java.util.Map;

public interface SourceFileInfoProvider {
    public SourceFileInfo getSourceFileInfo(String var1, int var2, long var3, Map<String, String> var5);

    public static final class SourceFileInfo {
        private static final String UNKNOWN_NAME = "(unknown)";
        private final CharSequence fileName;
        private final int lineNumber;
        private final long offset;
        private final int column;

        public SourceFileInfo(CharSequence fileName, int lineNumber, int column) {
            this(fileName, lineNumber, column, -1L);
        }

        private SourceFileInfo(CharSequence fileName, int lineNumber, int column, long offset) {
            this.fileName = fileName == null ? UNKNOWN_NAME : fileName;
            this.lineNumber = lineNumber;
            this.offset = offset;
            this.column = column;
        }

        public SourceFileInfo(String fileName, long offset) {
            this(fileName, -1, -1, offset);
        }

        public boolean isSourceKnown() {
            return this.fileName != null && !((Object)this.fileName).toString().equals(UNKNOWN_NAME);
        }

        public boolean hasOffset() {
            return this.offset != -1L;
        }

        public String getFileName() {
            return ((Object)this.fileName).toString();
        }

        public int getLine() {
            return this.lineNumber;
        }

        public int getColumn() {
            return this.column;
        }

        public long getOffset() {
            return this.offset;
        }

        public String toString() {
            return ((Object)this.fileName).toString() + ':' + this.lineNumber + ':' + this.column;
        }

        static SourceFileInfo valueOf(String toParse) {
            if (toParse == null) {
                return null;
            }
            int index = toParse.lastIndexOf(":");
            if (index == -1) {
                return null;
            }
            String fileName = toParse.substring(0, index);
            int lineNumber = -1;
            try {
                lineNumber = Integer.parseInt(toParse.substring(index + 1, toParse.length()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            SourceFileInfo result = new SourceFileInfo(fileName, lineNumber, 1);
            return result;
        }
    }
}

