/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DbgpMethodBreakpointPanel
extends JPanel
implements Controller {
    private static final long serialVersionUID = 4967178020173186468L;
    private static final String EMPTY_METHOD_NAME = "LBL_EmptyMethodName";
    private static final String METHOD_RETURN = NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_MethodReturn");
    private static final String METHOD_CALL = NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_MethodCall");
    private JLabel myMethodLbl;
    private JTextField myMethodName;
    private JLabel myStopOnLbl;
    private JComboBox myStopType;
    private static final ComboBoxModel METHOD_TYPES_MODEL = new DefaultComboBoxModel<MethodType>(MethodType.values());

    public DbgpMethodBreakpointPanel() {
        this.initComponents();
        this.myStopOnLbl.setVisible(false);
        this.myStopType.setVisible(false);
    }

    public boolean cancel() {
        return true;
    }

    public boolean ok() {
        String methodName = this.myMethodName.getText();
        if (methodName == null || methodName.trim().length() == 0) {
            String msg = NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)EMPTY_METHOD_NAME);
            NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
            return false;
        }
        MethodType type = (MethodType)((Object)METHOD_TYPES_MODEL.getSelectedItem());
        FunctionBreakpoint breakpoint = new FunctionBreakpoint(type.getType(), methodName);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        return true;
    }

    private void initComponents() {
        this.myMethodLbl = new JLabel();
        this.myStopOnLbl = new JLabel();
        this.myMethodName = new JTextField();
        this.myStopType = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_Settings")));
        this.myMethodLbl.setLabelFor(this.myMethodName);
        Mnemonics.setLocalizedText((JLabel)this.myMethodLbl, (String)NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_MethodName"));
        this.myStopOnLbl.setLabelFor(this.myStopType);
        Mnemonics.setLocalizedText((JLabel)this.myStopOnLbl, (String)NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"LBL_StopOn"));
        this.myMethodName.setText("");
        this.myStopType.setModel(METHOD_TYPES_MODEL);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.myStopOnLbl).add(31, 31, 31)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.myMethodLbl).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.myStopType, -2, -1, -2).add((Component)this.myMethodName, -1, 189, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.myMethodLbl).add((Component)this.myMethodName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.myStopOnLbl).add((Component)this.myStopType, -2, -1, -2))));
        this.myMethodLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"DbgpMethodBreakpointPanel.myMethodLbl.AccessibleContext.accessibleName"));
        this.myMethodLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"DbgpMethodBreakpointPanel.myMethodLbl.AccessibleContext.accessibleDescription"));
        this.myStopOnLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"DbgpMethodBreakpointPanel.myStopOnLbl.AccessibleContext.accessibleName"));
        this.myStopOnLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"DbgpMethodBreakpointPanel.myStopOnLbl.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DbgpMethodBreakpointPanel.class, (String)"A11_SettingsName"));
    }

    private static final class MethodType
    extends Enum<MethodType> {
        public static final /* enum */ MethodType CALL = new MethodType(FunctionBreakpoint.Type.CALL);
        public static final /* enum */ MethodType RETURN = new MethodType(FunctionBreakpoint.Type.RETURN);
        private final FunctionBreakpoint.Type myType;
        private static final /* synthetic */ MethodType[] $VALUES;

        public static MethodType[] values() {
            return (MethodType[])$VALUES.clone();
        }

        public static MethodType valueOf(String name) {
            return Enum.valueOf(MethodType.class, name);
        }

        private MethodType(FunctionBreakpoint.Type type) {
            this.myType = type;
        }

        FunctionBreakpoint.Type getType() {
            return this.myType;
        }

        public String toString() {
            if (this == CALL) {
                return METHOD_CALL;
            }
            if (this == RETURN) {
                return METHOD_RETURN;
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new MethodType[]{CALL, RETURN};
        }
    }
}

