/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.net.URL;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.source.parsing.SiblingProvider;
import org.netbeans.modules.java.source.parsing.SiblingSource;

public final class SiblingSupport
implements SiblingSource {
    private static final Logger LOG = Logger.getLogger(SiblingSupport.class.getName());
    private final Stack<URL> siblings = new Stack();
    private final SiblingProvider provider = new Provider();

    private SiblingSupport() {
    }

    @Override
    public void push(URL sibling) {
        assert (sibling != null);
        this.siblings.push(sibling);
        LOG.log(Level.FINE, "Pushed sibling: {0} size: {1}", new Object[]{sibling, this.siblings.size()});
    }

    @Override
    public URL pop() {
        URL removed = this.siblings.pop();
        if (LOG.isLoggable(Level.FINEST)) {
            StackTraceElement[] td = Thread.currentThread().getStackTrace();
            LOG.log(Level.FINEST, "Poped sibling: {0} size: {1} caller:\n{2}", new Object[]{removed, this.siblings.size(), SiblingSupport.formatCaller(td)});
        } else {
            LOG.log(Level.FINE, "Poped sibling: {0} size: {1}", new Object[]{removed, this.siblings.size()});
        }
        return removed;
    }

    @Override
    public SiblingProvider getProvider() {
        return this.provider;
    }

    public static SiblingSource create() {
        return new SiblingSupport();
    }

    private static String formatCaller(StackTraceElement[] elements) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : elements) {
            sb.append(String.format("%s.%s (%s:%d)\n", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()));
        }
        return sb.toString();
    }

    private final class Provider
    implements SiblingProvider {
        private Provider() {
        }

        @Override
        public URL getSibling() {
            URL result = (URL)SiblingSupport.this.siblings.peek();
            LOG.log(Level.FINER, "Returns sibling: {0}", new Object[]{result});
            return result;
        }

        @Override
        public boolean hasSibling() {
            boolean result = !SiblingSupport.this.siblings.isEmpty();
            LOG.log(Level.FINER, "Has sibling: {0}", new Object[]{result});
            return result;
        }
    }
}

