/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.LivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;

public class SnapshotLivenessResultsPanel
extends LivenessResultsPanel
implements ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM = messages.getString("SnapshotLivenessResultsPanel_GoSourcePopupItem");
    private static final String STACK_TRACES_POPUP_ITEM = messages.getString("SnapshotLivenessResultsPanel_StackTracesPopupItem");
    private JMenuItem popupShowSource;
    private JMenuItem popupShowStacks;
    private JPopupMenu popup;
    private LivenessMemoryResultsSnapshot snapshot;
    private int allocTrackEvery;

    public SnapshotLivenessResultsPanel(LivenessMemoryResultsSnapshot snapshot, MemoryResUserActionsHandler actionsHandler, int allocTrackEvery) {
        super(actionsHandler);
        this.snapshot = snapshot;
        this.allocTrackEvery = allocTrackEvery;
        this.fetchResultsFromSnapshot();
        this.initColumnsData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        } else if (source == this.popupShowSource) {
            this.showSourceForClass(this.selectedClassId);
        }
    }

    @Override
    protected String getClassName(int classId) {
        return this.snapshot.getClassName(classId);
    }

    @Override
    protected String[] getClassNames() {
        return this.snapshot.getClassNames();
    }

    protected int getPercentsTracked() {
        return 100 / this.allocTrackEvery;
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            Font boldfont = this.popup.getFont().deriveFont(1);
            this.popupShowSource = new JMenuItem();
            this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM);
            this.popupShowSource.setFont(boldfont);
            this.popup.add(this.popupShowSource);
            this.popupShowSource.addActionListener(this);
            if (this.snapshot.containsStacks()) {
                this.popup.addSeparator();
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(STACK_TRACES_POPUP_ITEM);
                this.popup.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
            }
        }
        return this.popup;
    }

    @Override
    protected void performDefaultAction(int classId) {
        this.showSourceForClass(classId);
    }

    private void fetchResultsFromSnapshot() {
        this.nTrackedAllocObjects = UIUtils.copyArray(this.snapshot.getNTrackedAllocObjects());
        this.nTrackedLiveObjects = UIUtils.copyArray(this.snapshot.getNTrackedLiveObjects());
        this.trackedLiveObjectsSize = UIUtils.copyArray(this.snapshot.getTrackedLiveObjectsSize());
        this.nTotalAllocObjects = UIUtils.copyArray(this.snapshot.getnTotalAllocObjects());
        this.avgObjectAge = UIUtils.copyArray(this.snapshot.getAvgObjectAge());
        this.maxSurvGen = UIUtils.copyArray(this.snapshot.getMaxSurvGen());
        this.nInstrClasses = this.snapshot.getNInstrClasses();
        this.nTrackedItems = this.snapshot.getNTrackedItems();
        this.maxValue = this.snapshot.getMaxValue();
        this.nTotalTrackedBytes = this.snapshot.getNTotalTrackedBytes();
        this.nTotalTracked = this.snapshot.getNTotalTracked();
        this.initDataUponResultsFetch();
    }
}

