/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.updater.ModuleDeactivator;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterFrame;

public final class UpdaterDispatcher
implements Runnable {
    private Boolean disable = null;
    private Boolean install = null;
    private Boolean uninstall = null;
    public static final String UPDATE_DIR = "update";
    public static final String DEACTIVATE_DIR = "deactivate";
    public static final String NEW_UPDATER_DIR = "new_updater";
    public static final String DEACTIVATE_LATER = "deactivate_later.txt";
    public static final String LAST_MODIFIED = ".lastModified";

    UpdaterDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        try {
            if (this.isUninstallScheduled()) {
                ModuleDeactivator.delete();
            }
            if (this.isDisableScheduled()) {
                ModuleDeactivator.disable();
            }
            if (this.isInstallScheduled()) {
                try {
                    ModuleUpdater mu = new ModuleUpdater(null);
                    mu.start();
                    mu.join();
                }
                catch (InterruptedException ex) {
                    System.out.println("Error: " + ex);
                }
            }
        }
        catch (Exception x) {
            System.out.println("Error: Handling delete throws " + x);
        }
        finally {
            UpdaterFrame.getUpdaterFrame().unpackingFinished();
        }
    }

    private boolean isDisableScheduled() {
        if (this.disable == null) {
            this.exploreUpdateDir();
        }
        return this.disable;
    }

    private boolean isUninstallScheduled() {
        if (this.uninstall == null) {
            this.exploreUpdateDir();
        }
        return this.uninstall;
    }

    private boolean isInstallScheduled() {
        if (this.install == null) {
            this.exploreUpdateDir();
        }
        return this.install;
    }

    private void exploreUpdateDir() {
        this.install = false;
        this.uninstall = false;
        this.disable = false;
        for (File cluster : UpdateTracking.clusters(true)) {
            File updateDir = new File(cluster, UPDATE_DIR);
            if (!updateDir.exists() || !updateDir.isDirectory()) continue;
            if (this.install == null || !this.install.booleanValue()) {
                this.install = !ModuleUpdater.getModulesToInstall(cluster).isEmpty();
            }
            if (this.uninstall == null || !this.uninstall.booleanValue()) {
                this.uninstall = ModuleDeactivator.hasModulesForDelete(updateDir);
            }
            if (this.disable != null && this.disable.booleanValue()) continue;
            this.disable = ModuleDeactivator.hasModulesForDisable(updateDir);
        }
    }

    @Override
    public void run() {
        this.dispatch();
        UpdaterFrame.disposeSplash();
    }

    public static void touchLastModified(File cluster) {
        if (!cluster.exists()) {
            return;
        }
        try {
            File stamp = new File(cluster, LAST_MODIFIED);
            if (!stamp.exists() && !stamp.createNewFile()) {
                throw new IOException("Can`t create stamp file " + stamp);
            }
            if (!stamp.setLastModified(System.currentTimeMillis())) {
                stamp.delete();
                stamp.createNewFile();
                stamp.setLastModified(System.currentTimeMillis());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

