/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;

public class ClassifierResolverImpl
extends CsmClassifierResolver {
    public CsmClassifier getTypeClassifier(CsmType csmType, CsmFile csmFile, int n, boolean bl) {
        CsmClassifier csmClassifier2;
        CsmProject csmProject = csmFile.getProject();
        if (csmProject != null && csmProject.isArtificial()) {
            for (CsmClassifier csmClassifier2 : CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, n)) {
                if (csmClassifier2.getStartFile() == null) continue;
                csmFile = csmClassifier2.getStartFile();
                break;
            }
        }
        Resolver resolver = ResolverFactory.createResolver(csmFile, n);
        csmClassifier2 = csmType instanceof Resolver.SafeClassifierProvider ? ((Resolver.SafeClassifierProvider)csmType).getClassifier(resolver) : csmType.getClassifier();
        if (bl) {
            csmClassifier2 = resolver.getOriginalClassifier(csmClassifier2);
        }
        return csmClassifier2;
    }

    public CsmClassifier getOriginalClassifier(CsmClassifier csmClassifier, CsmFile csmFile) {
        if (csmClassifier instanceof CsmOffsetable) {
            CsmProject csmProject = csmFile.getProject();
            if (csmProject != null && csmProject.isArtificial()) {
                for (CsmCompilationUnit csmCompilationUnit : CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, 0)) {
                    if (csmCompilationUnit.getStartFile() == null) continue;
                    csmFile = csmCompilationUnit.getStartFile();
                    break;
                }
            }
            return ResolverFactory.createResolver((CsmOffsetable)csmClassifier, csmFile).getOriginalClassifier(csmClassifier);
        }
        return csmClassifier;
    }

    public boolean isForwardClass(CsmObject csmObject) {
        return CsmKindUtilities.isDeclaration((CsmObject)csmObject) && ForwardClass.isForwardClass((CsmDeclaration)csmObject);
    }

    public CsmClassifier findClassifierUsedInFile(CharSequence charSequence, CsmFile csmFile, boolean bl) {
        CsmProject csmProject = csmFile.getProject();
        if (csmProject == null) {
            return null;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        CsmClassifier csmClassifier = this.findVisibleDeclaration(csmProject, charSequence, csmFile, atomicBoolean, bl);
        if (!ForwardClass.isForwardClass((CsmDeclaration)csmClassifier) && atomicBoolean.get()) {
            assert (csmClassifier != null) : "how can visible be true without a result?";
            return csmClassifier;
        }
        Collection<CsmProject> collection = this.getLibraries(csmFile, 0);
        Iterator<CsmProject> iterator = collection.iterator();
        while (iterator.hasNext()) {
            atomicBoolean.set(false);
            CsmProject csmProject2 = iterator.next();
            CsmClassifier csmClassifier2 = this.findVisibleDeclaration(csmProject2, charSequence, csmFile, atomicBoolean, bl);
            if (!ForwardClass.isForwardClass((CsmDeclaration)csmClassifier2) && atomicBoolean.get()) {
                return csmClassifier2;
            }
            if (csmClassifier != null) continue;
            csmClassifier = csmClassifier2;
        }
        return csmClassifier;
    }

    private CsmClassifier findVisibleDeclaration(CsmProject csmProject, CharSequence charSequence, CsmFile csmFile, AtomicBoolean atomicBoolean, boolean bl) {
        Collection collection = csmProject.findClassifiers(charSequence);
        CsmClassifier csmClassifier = null;
        for (CsmClassifier csmClassifier2 : collection) {
            if (bl && !CsmKindUtilities.isClass((CsmObject)csmClassifier2)) continue;
            if (csmClassifier == null || ForwardClass.isForwardClass(csmClassifier)) {
                csmClassifier = csmClassifier2;
            }
            if (!CsmIncludeResolver.getDefault().isObjectVisible(csmFile, (CsmObject)csmClassifier2)) continue;
            atomicBoolean.set(true);
            return csmClassifier2;
        }
        return csmClassifier;
    }

    private Collection<CsmProject> getLibraries(CsmFile csmFile, int n) {
        CsmProject csmProject = csmFile.getProject();
        if (csmProject == null) {
            return Collections.emptyList();
        }
        if (csmProject.isArtificial()) {
            HashSet<CsmProject> hashSet = new HashSet<CsmProject>(2);
            for (CsmCompilationUnit csmCompilationUnit : CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, n)) {
                hashSet.addAll(csmCompilationUnit.getStartProject().getLibraries());
            }
            return hashSet;
        }
        return csmProject.getLibraries();
    }
}

