/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class AbstractFileBuffer
implements FileBuffer {
    private final CharSequence absPath;
    private Charset encoding;
    private WeakReference<Object> lines = new WeakReference<Object>(null);

    protected AbstractFileBuffer(CharSequence charSequence) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertNormalized((File)new File(((Object)charSequence).toString()));
        }
        this.absPath = FilePathCache.getManager().getString(charSequence);
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    public File getFile() {
        return new File(((Object)this.absPath).toString());
    }

    public final Reader getReader() throws IOException {
        Object object;
        Object object2;
        if (this.encoding == null) {
            object2 = this.getFile();
            object = FileUtil.toFileObject((File)object2);
            this.encoding = object != null ? FileEncodingQuery.getEncoding((FileObject)object) : FileEncodingQuery.getDefaultEncoding();
        }
        object2 = this.getInputStream();
        object = new InputStreamReader((InputStream)object2, this.encoding);
        return object;
    }

    public abstract InputStream getInputStream() throws IOException;

    protected void write(DataOutput dataOutput) throws IOException {
        assert (this.absPath != null);
        PersistentUtils.writeUTF(this.absPath, dataOutput);
    }

    protected AbstractFileBuffer(DataInput dataInput) throws IOException {
        this.absPath = PersistentUtils.readUTF(dataInput, FilePathCache.getManager());
        assert (this.absPath != null);
    }

    @Override
    public int getLineByOffset(int n) throws IOException {
        int[] nArray = this.getLineOffsets();
        int n2 = 0;
        int n3 = nArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = nArray[n4];
            if (n5 < n) {
                if (n2 == n3) {
                    return n2 + 1;
                }
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                if (n2 == n3) {
                    return n2;
                }
                n3 = n4 - 1;
                continue;
            }
            return n4 + 1;
        }
        return n2;
    }

    @Override
    public int getStartLineOffset(int n) throws IOException {
        int[] nArray = this.getLineOffsets();
        if (--n < nArray.length) {
            return nArray[n];
        }
        return nArray[nArray.length - 1];
    }

    private int[] getLineOffsets() throws IOException {
        WeakReference<Object> weakReference = this.lines;
        int[] nArray = null;
        if (weakReference != null) {
            nArray = (int[])weakReference.get();
        }
        if (nArray == null) {
            int n;
            String string = this.getText();
            int n2 = string.length();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 / 10);
            arrayList.add(0);
            for (n = 0; n < n2; ++n) {
                char c = string.charAt(n);
                if (c != '\n') continue;
                arrayList.add(n + 1);
            }
            nArray = new int[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
            this.lines = new WeakReference<int[]>(nArray);
        }
        return nArray;
    }

    protected void clearLineCache() {
        WeakReference<Object> weakReference = this.lines;
        if (weakReference != null) {
            weakReference.clear();
        }
    }
}

