/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.EnumeratorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public class EnumImpl
extends ClassEnumBase<CsmEnum>
implements CsmEnum {
    private final List<CsmUID<CsmEnumerator>> enumerators;

    private EnumImpl(AST aST, CsmFile csmFile) {
        super(EnumImpl.findName(aST), csmFile, aST);
        this.enumerators = new ArrayList<CsmUID<CsmEnumerator>>();
    }

    private void init(CsmScope csmScope, AST aST, boolean bl) {
        this.initScope(csmScope, aST);
        this.initQualifiedName(csmScope, aST);
        if (bl) {
            RepositoryUtils.hang(this);
        } else {
            Utils.setSelfUID(this);
        }
        this.initEnumeratorList(aST, bl);
        if (bl) {
            this.register(csmScope, true);
        }
    }

    public static EnumImpl create(AST aST, CsmScope csmScope, CsmFile csmFile, boolean bl) {
        EnumImpl enumImpl = new EnumImpl(aST, csmFile);
        enumImpl.init(csmScope, aST, bl);
        return enumImpl;
    }

    private static String findName(AST aST) {
        AST aST2;
        String string = AstUtil.findId(aST, 17);
        if ((string == null || string.length() == 0) && (aST2 = aST.getNextSibling()) != null && aST2.getType() == 89) {
            string = aST2.getText();
        }
        return string;
    }

    private void initEnumeratorList(AST aST, boolean bl) {
        AST aST2;
        for (aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (aST2.getType() != 494) continue;
            this.addList(aST2, bl);
            return;
        }
        aST2 = aST.getNextSibling();
        if (aST2 != null) {
            AST aST3 = null;
            if (aST2.getType() == 89) {
                aST2 = aST2.getNextSibling();
            }
            if (aST2.getType() == 16) {
                aST3 = aST2.getNextSibling();
            }
            if (aST3 != null && aST3.getType() == 494) {
                this.addList(aST3, bl);
            }
        }
    }

    private void addList(AST aST, boolean bl) {
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (aST2.getType() != 89) continue;
            EnumeratorImpl enumeratorImpl = new EnumeratorImpl(aST2, this);
            if (bl) {
                RepositoryUtils.put(enumeratorImpl);
            } else {
                Utils.setSelfUID(enumeratorImpl);
            }
            CsmUID<EnumeratorImpl> csmUID = UIDCsmConverter.objectToUID(enumeratorImpl);
            this.enumerators.add(csmUID);
        }
    }

    public Collection<CsmEnumerator> getEnumerators() {
        Collection<CsmEnumerator> collection = UIDCsmConverter.UIDsToDeclarations(this.enumerators);
        return collection;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.getEnumerators();
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.ENUM;
    }

    @Override
    public void dispose() {
        super.dispose();
        this._clearEnumerators();
    }

    private void _clearEnumerators() {
        Collection<CsmEnumerator> collection = this.getEnumerators();
        Utils.disposeAll(collection);
        RepositoryUtils.remove(this.enumerators);
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.enumerators, dataOutput, false);
    }

    public EnumImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        int n = dataInput.readInt();
        this.enumerators = n < 0 ? new ArrayList<CsmUID<CsmEnumerator>>(0) : new ArrayList<CsmUID<CsmEnumerator>>(n);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.enumerators, dataInput, n);
    }
}

