/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gototest;

import java.awt.EventQueue;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public class GotoOppositeAction
extends CallableSystemAction {
    private TestLocator cachedLocator;
    private FileObject cachedLocatorFo;
    private FileObject cachedFileTypeFo;
    private TestLocator.FileType cachedFileType;

    public GotoOppositeAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
        String trimmedName = NbBundle.getMessage(GotoOppositeAction.class, (String)"LBL_Action_GoToTest_trimmed");
        this.putValue("trimmed-text", trimmedName);
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(this.getCurrentFileType() == TestLocator.FileType.TEST ? "LBL_Action_GoToSource" : "LBL_Action_GoToTest"));
    }

    public boolean isEnabled() {
        assert (EventQueue.isDispatchThread());
        EditorCookie ec = (EditorCookie)Utilities.actionsGlobalContext().lookup(EditorCookie.class);
        if (ec == null || ec.getDocument() == null) {
            return false;
        }
        return this.getCurrentFileType() != TestLocator.FileType.NEITHER;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_Action_GoToTest"));
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
        TestLocator locator;
        int[] caretOffsetHolder = new int[]{-1};
        FileObject fo = this.getApplicableFileObject(caretOffsetHolder);
        int caretOffset = caretOffsetHolder[0];
        if (fo != null && (locator = this.getLocatorFor(fo)) != null && locator.appliesTo(fo)) {
            if (locator.asynchronous()) {
                locator.findOpposite(fo, caretOffset, new TestLocator.LocationListener(){

                    @Override
                    public void foundLocation(FileObject fo, TestLocator.LocationResult location) {
                        if (location != null) {
                            GotoOppositeAction.this.handleResult(location);
                        }
                    }
                });
            } else {
                TestLocator.LocationResult opposite = locator.findOpposite(fo, caretOffset);
                if (opposite != null) {
                    this.handleResult(opposite);
                }
            }
        }
    }

    private void handleResult(TestLocator.LocationResult opposite) {
        if (opposite.getFileObject() != null) {
            GotoOppositeAction.openFile(opposite.getFileObject());
        } else if (opposite.getErrorMessage() != null) {
            String msg = opposite.getErrorMessage();
            NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
        }
    }

    private TestLocator getLocatorFor(FileObject fo) {
        if (fo == this.cachedLocatorFo) {
            return this.cachedLocator;
        }
        this.cachedLocatorFo = fo;
        this.cachedLocator = null;
        Collection locators = Lookup.getDefault().lookupAll(TestLocator.class);
        for (TestLocator locator : locators) {
            if (!locator.appliesTo(fo)) continue;
            this.cachedLocator = locator;
            break;
        }
        return this.cachedLocator;
    }

    private TestLocator.FileType getFileType(FileObject fo) {
        if (fo == this.cachedFileTypeFo) {
            return this.cachedFileType;
        }
        this.cachedFileTypeFo = fo;
        this.cachedFileType = TestLocator.FileType.NEITHER;
        TestLocator locator = this.getLocatorFor(fo);
        if (locator != null) {
            this.cachedFileType = locator.getFileType(fo);
        }
        return this.cachedFileType;
    }

    private TestLocator.FileType getCurrentFileType() {
        FileObject fo = this.getApplicableFileObject(new int[1]);
        return fo != null ? this.getFileType(fo) : TestLocator.FileType.NEITHER;
    }

    public static boolean openFile(FileObject fo) {
        DataObject dobj;
        try {
            dobj = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            Exceptions.printStackTrace((Throwable)e);
            return false;
        }
        assert (dobj != null);
        EditorCookie editorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dobj.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }

    private FileObject getApplicableFileObject(int[] caretPosHolder) {
        if (!EventQueue.isDispatchThread()) {
            Collection dobs = Utilities.actionsGlobalContext().lookupAll(DataObject.class);
            return dobs.size() == 1 ? ((DataObject)dobs.iterator().next()).getPrimaryFile() : null;
        }
        TopComponent comp = TopComponent.getRegistry().getActivated();
        if (comp == null) {
            return null;
        }
        Node[] nodes = comp.getActivatedNodes();
        if (nodes != null && nodes.length == 1) {
            if (comp instanceof CloneableEditorSupport.Pane) {
                JEditorPane editorPane;
                EditorCookie ec = (EditorCookie)nodes[0].getLookup().lookup(EditorCookie.class);
                if (ec != null && (editorPane = NbDocument.findRecentEditorPane((EditorCookie)ec)) != null) {
                    Document document;
                    Object sdp;
                    if (editorPane.getCaret() != null) {
                        caretPosHolder[0] = editorPane.getCaret().getDot();
                    }
                    if ((sdp = (document = editorPane.getDocument()).getProperty("stream")) instanceof FileObject) {
                        return (FileObject)sdp;
                    }
                    if (sdp instanceof DataObject) {
                        return ((DataObject)sdp).getPrimaryFile();
                    }
                }
            } else {
                DataObject dataObj = (DataObject)nodes[0].getLookup().lookup(DataObject.class);
                if (dataObj != null) {
                    return dataObj.getPrimaryFile();
                }
            }
        }
        return null;
    }
}

