/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.debugger.jpda.ui.options.CategoryPanelFormatters;
import org.netbeans.modules.debugger.jpda.ui.options.CategoryPanelGeneral;
import org.netbeans.modules.debugger.jpda.ui.options.CategoryPanelStepFilters;
import org.netbeans.modules.debugger.jpda.ui.options.JavaDebuggerOptionsPanelController;
import org.netbeans.modules.debugger.jpda.ui.options.StorablePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class JavaDebuggerPanel
extends StorablePanel {
    private static final String SHOW_FORMATTERS_PROP_NAME = "org.netbeans.modules.debugger.jpda.ui.options.SHOW_FORMATTERS";
    private static final int FORMATTERS_INDEX = 2;
    private final JavaDebuggerOptionsPanelController controller;
    private StorablePanel[] categoryPanels;
    private ButtonGroup categoriesButtonGroup;
    private JLabel categoriesLabel;
    private JList categoriesList;
    private JPanel categoriesPanel;
    private JPanel categoryPanel;

    JavaDebuggerPanel(JavaDebuggerOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.categoryPanels = new StorablePanel[]{new CategoryPanelGeneral(), new CategoryPanelStepFilters(), new CategoryPanelFormatters()};
        this.categoriesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{NbBundle.getMessage(JavaDebuggerPanel.class, (String)"JavaDebuggerPanel.categoryRadioButtonGeneral.text"), NbBundle.getMessage(JavaDebuggerPanel.class, (String)"JavaDebuggerPanel.categoryRadioButtonStepFilters.text"), NbBundle.getMessage(JavaDebuggerPanel.class, (String)"JavaDebuggerPanel.categoryRadioButtonFormatters.text")};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        String value = System.getProperty(SHOW_FORMATTERS_PROP_NAME);
        int index = value != null && "true".equals(value) ? 2 : 0;
        this.selectCategory(index);
        this.categoriesList.setSelectedIndex(index);
        if (index == 2) {
            System.setProperty(SHOW_FORMATTERS_PROP_NAME, "false");
        }
    }

    private void initComponents() {
        this.categoriesButtonGroup = new ButtonGroup();
        this.categoryPanel = new JPanel();
        this.categoriesPanel = new JPanel();
        this.categoriesList = new JList();
        this.categoriesLabel = new JLabel();
        this.categoryPanel.setLayout(new BoxLayout(this.categoryPanel, 2));
        this.categoriesPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoriesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"General", "Step Filters", "Variable Formatters"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.categoriesList.setSelectionMode(0);
        this.categoriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JavaDebuggerPanel.this.categoriesListValueChanged(evt);
            }
        });
        GroupLayout categoriesPanelLayout = new GroupLayout((Container)this.categoriesPanel);
        this.categoriesPanel.setLayout((LayoutManager)categoriesPanelLayout);
        categoriesPanelLayout.setHorizontalGroup((GroupLayout.Group)categoriesPanelLayout.createParallelGroup(1).add((Component)this.categoriesList, -1, -1, Short.MAX_VALUE));
        categoriesPanelLayout.setVerticalGroup((GroupLayout.Group)categoriesPanelLayout.createParallelGroup(1).add(2, (Component)this.categoriesList, -1, -1, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.categoriesLabel, (String)NbBundle.getMessage(JavaDebuggerPanel.class, (String)"JavaDebuggerPanel.categoriesLabel.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.categoriesLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.categoriesPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.categoryPanel, -1, 450, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.categoriesLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.categoryPanel, -1, 332, Short.MAX_VALUE).add((Component)this.categoriesPanel, -1, -1, Short.MAX_VALUE))));
    }

    private void categoriesListValueChanged(ListSelectionEvent evt) {
        int c = this.categoriesList.getSelectedIndex();
        if (c >= 0 && c <= 3) {
            this.selectCategory(c);
        }
    }

    private void selectCategory(int c) {
        if (this.categoryPanel.getComponentCount() > 0) {
            this.categoryPanel.removeAll();
        }
        this.categoryPanel.add(this.categoryPanels[c]);
        this.categoryPanel.revalidate();
        this.categoryPanel.repaint();
    }

    @Override
    void load() {
        for (StorablePanel p : this.categoryPanels) {
            p.load();
        }
        String value = System.getProperty(SHOW_FORMATTERS_PROP_NAME);
        if (value != null && "true".equals(value)) {
            this.selectCategory(2);
            this.categoriesList.setSelectedIndex(2);
            System.setProperty(SHOW_FORMATTERS_PROP_NAME, "false");
        }
    }

    @Override
    void store() {
        for (StorablePanel p : this.categoryPanels) {
            p.store();
        }
    }

    boolean valid() {
        return true;
    }
}

