/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.MonitorModel;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ThreadsTableModel
implements TableModel,
Constants {
    private Vector listeners = new Vector();
    private Map<JPDAThread, Integer> refreshingThreads;
    private Map<JPDAThread, ThreadStateChangeListener> threadStateChangeListeners = new WeakHashMap<JPDAThread, ThreadStateChangeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof MonitorModel.ThreadWithBordel) {
            object = ((MonitorModel.ThreadWithBordel)object).getOriginalThread();
        }
        if (object instanceof JPDAThreadGroup) {
            if ("ThreadState".equals(string)) {
                return "";
            }
            if ("ThreadSuspended".equals(string)) {
                JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)object;
                JPDAThread[] jPDAThreadArray = jPDAThreadGroup.getThreads();
                boolean bl = true;
                for (JPDAThread jPDAThread : jPDAThreadArray) {
                    if (jPDAThread.isSuspended()) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
        }
        if (object instanceof JPDAThread) {
            JPDAThread jPDAThread = (JPDAThread)object;
            if ("ThreadState".equals(string)) {
                int n = jPDAThread.getState();
                Object object2 = this;
                synchronized (object2) {
                    if (this.refreshingThreads == null) {
                        this.refreshingThreads = new WeakHashMap<JPDAThread, Integer>();
                        new ThreadStateChangeRefresher(this, this.refreshingThreads);
                    }
                    this.refreshingThreads.put(jPDAThread, n);
                }
                object2 = ThreadsTableModel.getThreadStateDescription(n);
                if (object2 != null) {
                    return object2;
                }
            } else if ("ThreadSuspended".equals(string)) {
                ThreadsTableModel threadsTableModel = this;
                synchronized (threadsTableModel) {
                    if (!this.threadStateChangeListeners.containsKey(jPDAThread)) {
                        this.threadStateChangeListeners.put(jPDAThread, new ThreadStateChangeListener(this, jPDAThread));
                    }
                }
                return jPDAThread.isSuspended();
            }
        }
        throw new UnknownTypeException(object);
    }

    private static String getThreadStateDescription(int n) {
        switch (n) {
            case 3: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_OnMonitor");
            }
            case 5: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_NotStarted");
            }
            case 1: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Running");
            }
            case 2: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Sleeping");
            }
            case -1: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Unknown");
            }
            case 4: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Waiting");
            }
            case 0: {
                return NbBundle.getMessage(ThreadsTableModel.class, (String)"CTL_Thread_Status_Zombie");
            }
        }
        ErrorManager.getDefault().log(16, "Unknown thread state: " + n);
        return null;
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof MonitorModel.ThreadWithBordel) {
            object = ((MonitorModel.ThreadWithBordel)object).getOriginalThread();
        }
        if (object instanceof JPDAThreadGroup) {
            if ("ThreadState".equals(string)) {
                return true;
            }
            if ("ThreadSuspended".equals(string)) {
                return false;
            }
        }
        if (object instanceof JPDAThread) {
            if ("ThreadState".equals(string)) {
                return true;
            }
            if ("ThreadSuspended".equals(string)) {
                return false;
            }
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof MonitorModel.ThreadWithBordel) {
            object = ((MonitorModel.ThreadWithBordel)object).getOriginalThread();
        }
        if (object instanceof JPDAThreadGroup && "ThreadSuspended".equals(string)) {
            if (((Boolean)object2).booleanValue()) {
                ((JPDAThreadGroup)object).suspend();
            } else {
                ((JPDAThreadGroup)object).resume();
            }
            this.fireTableValueChanged(object, "ThreadSuspended");
            return;
        }
        if (object instanceof JPDAThread && "ThreadSuspended".equals(string)) {
            if (object2.equals(Boolean.TRUE)) {
                ((JPDAThread)object).suspend();
            } else {
                ((JPDAThread)object).resume();
            }
            this.fireTableValueChanged(object, "ThreadSuspended");
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTableValueChanged(Object object, String string) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    private void fireNodeChanged(Object object) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, object));
        }
    }

    private static class ThreadStateChangeRefresher
    implements Runnable {
        private WeakReference<ThreadsTableModel> tmRef;
        private Map<JPDAThread, Integer> threads;
        private RequestProcessor.Task refreshTask;

        public ThreadStateChangeRefresher(ThreadsTableModel threadsTableModel, Map<JPDAThread, Integer> map) {
            this.tmRef = new WeakReference<ThreadsTableModel>(threadsTableModel);
            this.threads = map;
            this.refreshTask = new RequestProcessor("Threads Refresh", 1).create((Runnable)this);
            this.refreshTask.schedule(1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<JPDAThread, Integer> hashMap;
            ThreadsTableModel threadsTableModel = (ThreadsTableModel)this.tmRef.get();
            if (threadsTableModel == null) {
                return;
            }
            long l = System.currentTimeMillis();
            Map<JPDAThread, Integer> map = this.threads;
            synchronized (map) {
                hashMap = new HashMap<JPDAThread, Integer>(this.threads);
            }
            for (JPDAThread jPDAThread : hashMap.keySet()) {
                int n = jPDAThread.getState();
                if (n == (Integer)hashMap.get(jPDAThread)) continue;
                threadsTableModel.fireTableValueChanged(jPDAThread, "ThreadState");
            }
            l = System.currentTimeMillis() - l;
            this.refreshTask.schedule(100 * (int)l + 200);
        }
    }

    private static class ThreadStateChangeListener
    implements PropertyChangeListener {
        private WeakReference<ThreadsTableModel> tmRef;
        private JPDAThread t;

        public ThreadStateChangeListener(ThreadsTableModel threadsTableModel, JPDAThread jPDAThread) {
            this.tmRef = new WeakReference<ThreadsTableModel>(threadsTableModel);
            this.t = jPDAThread;
            ((Customizer)jPDAThread).addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ThreadsTableModel threadsTableModel = (ThreadsTableModel)this.tmRef.get();
            if (threadsTableModel == null) {
                ((Customizer)this.t).removePropertyChangeListener(this);
                return;
            }
            threadsTableModel.fireNodeChanged(this.t);
            for (JPDAThreadGroup jPDAThreadGroup = this.t.getParentThreadGroup(); jPDAThreadGroup != null; jPDAThreadGroup = jPDAThreadGroup.getParentThreadGroup()) {
                threadsTableModel.fireTableValueChanged(jPDAThreadGroup, "ThreadSuspended");
            }
        }
    }
}

