/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MonitorInfo;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.datatransfer.PasteType;

public class DebuggingMonitorModel
implements ExtendedNodeModelFilter,
NodeActionsProviderFilter,
TableModel,
Constants {
    public static final String SHOW_MONITORS = "show.monitors";
    public static final String CONTENDED_MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/waiting_on_monitor_16.png";
    public static final String OWNED_MONITORS = "org/netbeans/modules/debugger/resources/allInOneView/monitor_acquired_16.png";
    public static final String MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/monitor_acquired_16.png";
    private RequestProcessor evaluationRP;
    private final Collection modelListeners = new HashSet();
    private JPDADebugger debugger;
    private final Map shortDescriptionMap = new HashMap();

    public DebuggingMonitorModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.evaluationRP = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (object instanceof ContendedMonitor) {
            ObjectVariable objectVariable = ((ContendedMonitor)object).variable;
            Field field = ((ContendedMonitor)object).field;
            String string = field == null ? objectVariable.getType() : field.getName();
            String string2 = MessageFormat.format(NbBundle.getBundle(DebuggingMonitorModel.class).getString("CTL_MonitorModel_Column_ContendedMonitor"), string, objectVariable.getValue());
            Set set = DebuggingNodeModel.getNodesInDeadlock(this.debugger);
            if (set != null) {
                Set set2 = set;
                synchronized (set2) {
                    if (set.contains(objectVariable)) {
                        string2 = BoldVariablesTableModelFilterFirst.toHTML(string2, false, false, Color.RED);
                    }
                }
            }
            return string2;
        }
        if (object instanceof OwnedMonitors) {
            return NbBundle.getBundle(DebuggingMonitorModel.class).getString("CTL_MonitorModel_Column_OwnedMonitors");
        }
        if (object instanceof Monitor || object instanceof ObjectVariable) {
            String string;
            Object object2;
            ObjectVariable objectVariable;
            if (object instanceof Monitor) {
                objectVariable = ((Monitor)object).variable;
                object2 = ((Monitor)object).field;
                string = object2 == null ? objectVariable.getType() : object2.getName();
            } else {
                objectVariable = (ObjectVariable)object;
                string = objectVariable.getType();
            }
            object2 = MessageFormat.format(NbBundle.getBundle(DebuggingMonitorModel.class).getString("CTL_MonitorModel_Column_Monitor"), string, objectVariable.getValue());
            Set set = DebuggingNodeModel.getNodesInDeadlock(this.debugger);
            if (set != null) {
                Set set3 = set;
                synchronized (set3) {
                    if (set.contains(objectVariable)) {
                        object2 = BoldVariablesTableModelFilterFirst.toHTML((String)object2, false, false, Color.RED);
                    }
                }
            }
            return object2;
        }
        return nodeModel.getDisplayName(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final NodeModel nodeModel, final Object object) throws UnknownTypeException {
        Map map = this.shortDescriptionMap;
        synchronized (map) {
            Object v = this.shortDescriptionMap.remove(object);
            if (v instanceof String) {
                return (String)v;
            }
            if (v instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)v);
            }
        }
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object2;
                if (object instanceof ContendedMonitor) {
                    object2 = "";
                } else if (object instanceof OwnedMonitors) {
                    object2 = "";
                } else if (object instanceof Monitor || object instanceof ObjectVariable) {
                    object2 = "";
                } else {
                    try {
                        object2 = nodeModel.getShortDescription(object);
                    }
                    catch (UnknownTypeException unknownTypeException) {
                        object2 = unknownTypeException;
                    }
                }
                if (object2 != null && !"".equals(object2)) {
                    Map map = DebuggingMonitorModel.this.shortDescriptionMap;
                    synchronized (map) {
                        DebuggingMonitorModel.this.shortDescriptionMap.put(object, object2);
                    }
                    DebuggingMonitorModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)DebuggingMonitorModel.this, object, 4));
                }
            }
        });
        return "";
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getIconBase(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent modelEvent) {
        Object[] objectArray;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            objectArray = this.modelListeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged(modelEvent);
        }
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof ContendedMonitor) {
            return new Action[0];
        }
        if (object instanceof OwnedMonitors) {
            return new Action[0];
        }
        if (object instanceof Monitor) {
            return new Action[0];
        }
        if (object instanceof ObjectVariable) {
            return new Action[0];
        }
        return nodeActionsProvider.getActions(object);
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof ContendedMonitor) {
            return;
        }
        if (object instanceof OwnedMonitors) {
            return;
        }
        if (object instanceof Monitor) {
            return;
        }
        if (object instanceof ObjectVariable) {
            return;
        }
        nodeActionsProvider.performDefaultAction(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof OwnedMonitors || object instanceof ContendedMonitor || object instanceof Monitor || object instanceof ObjectVariable) {
            if (string == "ThreadState") {
                return "";
            }
            if (string == "ThreadSuspended") {
                return null;
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if ((object instanceof OwnedMonitors || object instanceof ContendedMonitor || object instanceof Monitor || object instanceof ObjectVariable) && (string == "ThreadState" || string == "ThreadSuspended")) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
    }

    public boolean canRename(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        return null;
    }

    public Transferable clipboardCut(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        return null;
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel extendedNodeModel, Object object, Transferable transferable) throws UnknownTypeException {
        return null;
    }

    public void setName(ExtendedNodeModel extendedNodeModel, Object object, String string) throws UnknownTypeException {
    }

    public String getIconBaseWithExtension(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        if (object instanceof ContendedMonitor) {
            return CONTENDED_MONITOR;
        }
        if (object instanceof OwnedMonitors) {
            return "org/netbeans/modules/debugger/resources/allInOneView/monitor_acquired_16.png";
        }
        if (object instanceof ObjectVariable || object instanceof Monitor) {
            return "org/netbeans/modules/debugger/resources/allInOneView/monitor_acquired_16.png";
        }
        return extendedNodeModel.getIconBaseWithExtension(object);
    }

    private static class ContendedMonitor
    extends Monitor {
        ContendedMonitor(ObjectVariable objectVariable, CallStackFrame callStackFrame, JPDADebugger jPDADebugger) {
            super(objectVariable, callStackFrame, jPDADebugger);
        }
    }

    static class OwnedMonitors {
        Monitor[] monitors;
        ObjectVariable[] variables;

        OwnedMonitors(ObjectVariable[] objectVariableArray) {
            this.variables = objectVariableArray;
            this.monitors = null;
        }

        OwnedMonitors(Monitor[] monitorArray) {
            this.monitors = monitorArray;
            this.variables = null;
        }
    }

    private static class Monitor {
        ObjectVariable variable;
        Field field;

        Monitor(ObjectVariable objectVariable, CallStackFrame callStackFrame, JPDADebugger jPDADebugger) {
            this.variable = objectVariable;
            if (callStackFrame != null) {
                this.setVarInfo(objectVariable, callStackFrame, jPDADebugger);
            }
        }

        private void setVarInfo(ObjectVariable objectVariable, CallStackFrame callStackFrame, JPDADebugger jPDADebugger) {
            Field[] fieldArray;
            JPDAClassType jPDAClassType;
            This this_ = callStackFrame.getThisVariable();
            long l = objectVariable.getUniqueID();
            try {
                jPDAClassType = (JPDAClassType)callStackFrame.getClass().getMethod("getClassType", new Class[0]).invoke((Object)callStackFrame, new Object[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                jPDAClassType = null;
            }
            if (jPDAClassType != null) {
                fieldArray = jPDAClassType.staticFields();
                for (Field field : fieldArray) {
                    if (!(field instanceof ObjectVariable) || l != ((ObjectVariable)field).getUniqueID()) continue;
                    this.field = field;
                    return;
                }
            }
            while (this_ != null) {
                for (Field field : fieldArray = this_.getFields(0, this_.getFieldsCount())) {
                    if (!(field instanceof ObjectVariable) || l != ((ObjectVariable)field).getUniqueID()) continue;
                    this.field = field;
                    return;
                }
                this_ = (ObjectVariable)this_.getField("this$0");
            }
        }
    }

    static class Children {
        private JPDADebugger debugger;
        private final Set<JPDAThread> threadsAskedForMonitors = new WeakSet();
        private final Set<CallStackFrame> framesAskedForMonitors = new WeakSet();
        private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
        private PreferenceChangeListener prefListener;
        private ModelListener modelListener;
        private Model modelEventSource;

        Children(JPDADebugger jPDADebugger, ModelListener modelListener, Model model) {
            this.debugger = jPDADebugger;
            this.modelListener = modelListener;
            this.modelEventSource = model;
            this.prefListener = new MonitorPreferenceChangeListener();
            this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)this.preferences));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getChildren(TreeModel treeModel, Object object, int n, int n2) throws UnknownTypeException {
            if (object instanceof JPDAThread) {
                JPDAThread jPDAThread = (JPDAThread)object;
                ObjectVariable objectVariable = this.threadsAskedForMonitors;
                synchronized (objectVariable) {
                    this.threadsAskedForMonitors.add(jPDAThread);
                }
                if (this.preferences.getBoolean(DebuggingMonitorModel.SHOW_MONITORS, false)) {
                    try {
                        Object[] objectArray;
                        ObjectVariable[] objectVariableArray;
                        Object object22;
                        ArrayList<Monitor> arrayList;
                        objectVariable = jPDAThread.getContendedMonitor();
                        List list = jPDAThread.getOwnedMonitorsAndFrames();
                        if (list.size() > 0) {
                            arrayList = new ArrayList<Monitor>();
                            for (Object object22 : list) {
                                if (object22.getFrame() != null) continue;
                                arrayList.add(new Monitor(object22.getMonitor(), object22.getFrame(), this.debugger));
                            }
                            objectVariableArray = null;
                        } else {
                            objectVariableArray = jPDAThread.getOwnedMonitors();
                            arrayList = null;
                        }
                        Object object3 = null;
                        object22 = null;
                        if (objectVariable != null && n == 0 && n2 > 0) {
                            CallStackFrame callStackFrame = null;
                            try {
                                objectArray = jPDAThread.getCallStack(0, 1);
                                if (objectArray != null && objectArray.length == 1) {
                                    callStackFrame = objectArray[0];
                                }
                            }
                            catch (AbsentInformationException absentInformationException) {
                                // empty catch block
                            }
                            if (callStackFrame != null) {
                                object3 = new ContendedMonitor(objectVariable, callStackFrame, this.debugger);
                            }
                        }
                        if (arrayList != null && arrayList.size() > 0 && (objectVariable != null && n < 2 && n2 > 1 || objectVariable == null && n == 0 && n2 > 0)) {
                            object22 = new OwnedMonitors(arrayList.toArray(new Monitor[0]));
                        }
                        if (objectVariableArray != null && objectVariableArray.length > 0 && (objectVariable != null && n < 2 && n2 > 1 || objectVariable == null && n == 0 && n2 > 0)) {
                            object22 = new OwnedMonitors(objectVariableArray);
                        }
                        int n3 = 0;
                        if (object3 != null) {
                            ++n3;
                        }
                        if (object22 != null) {
                            ++n3;
                        }
                        objectArray = new Object[n3];
                        n3 = 0;
                        if (object3 != null) {
                            objectArray[n3++] = object3;
                        }
                        if (object22 != null) {
                            objectArray[n3++] = object22;
                        }
                        Object[] objectArray2 = treeModel.getChildren(object, n, n2);
                        if (n3 > 0) {
                            Object[] objectArray3 = new Object[n3 + objectArray2.length];
                            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                            System.arraycopy(objectArray2, 0, objectArray3, n3, objectArray2.length);
                            objectArray2 = objectArray3;
                        }
                        return objectArray2;
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        // empty catch block
                    }
                }
                return treeModel.getChildren(object, n, n2);
            }
            if (object instanceof OwnedMonitors) {
                OwnedMonitors ownedMonitors = (OwnedMonitors)object;
                Object[] objectArray = new Object[n2 - n];
                if (ownedMonitors.monitors != null) {
                    System.arraycopy(ownedMonitors.monitors, n, objectArray, 0, n2 - n);
                } else {
                    System.arraycopy(ownedMonitors.variables, n, objectArray, 0, n2 - n);
                }
                return objectArray;
            }
            if (object instanceof Monitor) {
                return treeModel.getChildren((Object)((Monitor)object).variable, n, n2);
            }
            if (object instanceof CallStackFrame) {
                if (this.preferences.getBoolean(DebuggingMonitorModel.SHOW_MONITORS, false)) {
                    CallStackFrame callStackFrame = (CallStackFrame)object;
                    List list = callStackFrame.getOwnedMonitors();
                    int n4 = list.size();
                    if (n4 > 0) {
                        Object[] objectArray = this.framesAskedForMonitors;
                        synchronized (this.framesAskedForMonitors) {
                            this.framesAskedForMonitors.add(callStackFrame);
                            // ** MonitorExit[var8_18] (shouldn't be in output)
                            objectArray = new Monitor[n4];
                            for (int i = 0; i < n4; ++i) {
                                objectArray[i] = new Monitor(((MonitorInfo)list.get(i)).getMonitor(), callStackFrame, this.debugger);
                            }
                            return objectArray;
                        }
                    }
                } else {
                    Set<CallStackFrame> set = this.framesAskedForMonitors;
                    synchronized (set) {
                        this.framesAskedForMonitors.add((CallStackFrame)object);
                    }
                }
            }
            return treeModel.getChildren(object, n, n2);
        }

        public int getChildrenCount(TreeModel treeModel, Object object) throws UnknownTypeException {
            if (object instanceof OwnedMonitors) {
                OwnedMonitors ownedMonitors = (OwnedMonitors)object;
                if (ownedMonitors.monitors != null) {
                    return ownedMonitors.monitors.length;
                }
                return ownedMonitors.variables.length;
            }
            if (object instanceof Monitor) {
                return treeModel.getChildrenCount((Object)((Monitor)object).variable);
            }
            if (object instanceof CallStackFrame) {
                return Integer.MAX_VALUE;
            }
            return treeModel.getChildrenCount(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
            if (object instanceof OwnedMonitors) {
                return false;
            }
            if (object instanceof ContendedMonitor) {
                return true;
            }
            if (object instanceof Monitor) {
                return true;
            }
            if (object instanceof ObjectVariable) {
                return true;
            }
            if (object instanceof CallStackFrame) {
                if (this.preferences.getBoolean(DebuggingMonitorModel.SHOW_MONITORS, false)) {
                    return false;
                }
                Set<CallStackFrame> set = this.framesAskedForMonitors;
                synchronized (set) {
                    this.framesAskedForMonitors.add((CallStackFrame)object);
                }
            }
            return treeModel.isLeaf(object);
        }

        void setModelListener(ModelListener modelListener, Model model) {
            this.modelListener = modelListener;
            this.modelEventSource = model;
        }

        private void fireModelChange(ModelEvent modelEvent) {
            this.modelListener.modelChanged(modelEvent);
        }

        private class MonitorPreferenceChangeListener
        implements PreferenceChangeListener {
            private MonitorPreferenceChangeListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                String string = preferenceChangeEvent.getKey();
                if (DebuggingMonitorModel.SHOW_MONITORS.equals(string)) {
                    Object object2;
                    ArrayList arrayList;
                    ArrayList arrayList2 = Children.this.threadsAskedForMonitors;
                    synchronized (arrayList2) {
                        arrayList = new ArrayList(Children.this.threadsAskedForMonitors);
                    }
                    for (Object object2 : arrayList) {
                        Children.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)Children.this.modelEventSource, object2, 8));
                    }
                    object2 = Children.this.framesAskedForMonitors;
                    synchronized (object2) {
                        arrayList2 = new ArrayList(Children.this.framesAskedForMonitors);
                    }
                    for (CallStackFrame callStackFrame : arrayList2) {
                        Children.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)Children.this.modelEventSource, (Object)callStackFrame, 8));
                    }
                }
            }
        }
    }
}

