/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RenameAction
extends NodeAction {
    protected boolean surviveFocusChange() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(RenameAction.class, (String)"Rename");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RenameAction.class);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0].canRename();
    }

    protected void performAction(Node[] activatedNodes) {
        Node n = activatedNodes[0];
        NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(NbBundle.getMessage(RenameAction.class, (String)"CTL_RenameLabel"), NbBundle.getMessage(RenameAction.class, (String)"CTL_RenameTitle"));
        dlg.setInputText(n.getName());
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg))) {
            String newname = null;
            try {
                newname = dlg.getInputText();
                if (!newname.equals("")) {
                    n.setName(dlg.getInputText());
                }
            }
            catch (IllegalArgumentException e) {
                boolean needToAnnotate;
                boolean bl = needToAnnotate = Exceptions.findLocalizedMessage((Throwable)e) == null;
                if (needToAnnotate) {
                    Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(RenameAction.class, (String)"MSG_BadFormat", (Object)n.getName(), (Object)newname));
                }
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

