/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;
    private final ISourcePosition position;

    public ReflectedCompiledMethod(RubyModule implementationClass, Arity arity2, Visibility visibility, StaticScope staticScope, Object scriptObject, Method method2, CallConfiguration callConfig, ISourcePosition position) {
        this.init(implementationClass, arity2, visibility, staticScope, scriptObject, callConfig);
        this.method = method2;
        this.position = position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        this.callConfig.pre(context, self, this.getImplementationClass(), name2, block, this.staticScope);
        Ruby runtime2 = context.getRuntime();
        try {
            boolean isTrace = runtime2.hasEventHooks();
            try {
                if (isTrace) {
                    runtime2.callEventHooks(context, RubyEvent.CALL, this.position.getFile(), this.position.getStartLine(), name2, this.getImplementationClass());
                }
                IRubyObject iRubyObject = (IRubyObject)this.method.invoke(null, this.$scriptObject, context, self, args2, block);
                if (isTrace) {
                    Frame frame = context.getPreviousFrame();
                    runtime2.callEventHooks(context, RubyEvent.RETURN, frame.getFile(), frame.getLine(), name2, this.getImplementationClass());
                }
                return iRubyObject;
            }
            catch (Throwable throwable) {
                try {
                    if (isTrace) {
                        Frame frame = context.getPreviousFrame();
                        runtime2.callEventHooks(context, RubyEvent.RETURN, frame.getFile(), frame.getLine(), name2, this.getImplementationClass());
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    throw RaiseException.createNativeRaiseException(runtime2, e, this.method);
                }
                catch (IllegalAccessException e) {
                    throw RaiseException.createNativeRaiseException(runtime2, e, this.method);
                }
                catch (InvocationTargetException e) {
                    Throwable cause2 = e.getCause();
                    if (cause2 instanceof JumpException.ReturnJump) {
                        IRubyObject iRubyObject = this.handleReturn(context, (JumpException.ReturnJump)cause2);
                        return iRubyObject;
                    }
                    if (cause2 instanceof JumpException.RedoJump) {
                        IRubyObject iRubyObject = this.handleRedo(runtime2);
                        return iRubyObject;
                    }
                    if (cause2 instanceof RuntimeException) {
                        throw (RuntimeException)cause2;
                    }
                    if (cause2 instanceof Error) {
                        throw (Error)cause2;
                    }
                    throw RaiseException.createNativeRaiseException(runtime2, cause2, this.method);
                }
            }
        }
        finally {
            this.callConfig.post(context);
        }
    }
}

