/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.representations;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jruby.compiler.ir.IR_Closure;
import org.jruby.compiler.ir.IR_ExecutionScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.instructions.BRANCH_Instr;
import org.jruby.compiler.ir.instructions.BREAK_Instr;
import org.jruby.compiler.ir.instructions.BUILD_CLOSURE_Instr;
import org.jruby.compiler.ir.instructions.CASE_Instr;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.JUMP_INDIRECT_Instr;
import org.jruby.compiler.ir.instructions.JUMP_Instr;
import org.jruby.compiler.ir.instructions.LABEL_Instr;
import org.jruby.compiler.ir.instructions.RESCUED_BODY_END_MARKER_Instr;
import org.jruby.compiler.ir.instructions.RESCUED_BODY_START_MARKER_Instr;
import org.jruby.compiler.ir.instructions.RETURN_Instr;
import org.jruby.compiler.ir.instructions.SET_RETADDR_Instr;
import org.jruby.compiler.ir.instructions.THROW_EXCEPTION_Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFG {
    IR_ExecutionScope _scope;
    BasicBlock _entryBB;
    BasicBlock _exitBB;
    int _nextBBId = 0;
    DirectedGraph<BasicBlock, CFG_Edge> _cfg;
    LinkedList<BasicBlock> _postOrderList;
    Map<String, DataFlowProblem> _dfProbs;
    Map<Label, BasicBlock> _bbMap;
    BasicBlock[] _bbArray;

    public CFG(IR_ExecutionScope s) {
        this._scope = s;
        this._postOrderList = null;
        this._dfProbs = new HashMap<String, DataFlowProblem>();
        this._bbMap = new HashMap<Label, BasicBlock>();
    }

    public DirectedGraph getGraph() {
        return this._cfg;
    }

    public IR_ExecutionScope getScope() {
        return this._scope;
    }

    public BasicBlock getEntryBB() {
        return this._entryBB;
    }

    public BasicBlock getExitBB() {
        return this._exitBB;
    }

    public int getNextBBID() {
        ++this._nextBBId;
        return this._nextBBId;
    }

    public int getMaxNodeID() {
        return this._nextBBId;
    }

    public Set<CFG_Edge> incomingEdgesOf(BasicBlock bb) {
        return this._cfg.incomingEdgesOf((Object)bb);
    }

    public Set<CFG_Edge> outgoingEdgesOf(BasicBlock bb) {
        return this._cfg.outgoingEdgesOf((Object)bb);
    }

    public Set<BasicBlock> getNodes() {
        return this._cfg.vertexSet();
    }

    public BasicBlock getFallThroughBB(BasicBlock bb) {
        return this._bbArray[bb.getID()];
    }

    public BasicBlock getTargetBB(Label l) {
        return this._bbMap.get(l);
    }

    private Label getNewLabel() {
        return this._scope.getNewLabel();
    }

    private BasicBlock createNewBB(Label l, DirectedGraph<BasicBlock, CFG_Edge> g, Map<Label, BasicBlock> bbMap) {
        BasicBlock b = new BasicBlock(this, l);
        bbMap.put(b._label, b);
        g.addVertex((Object)b);
        return b;
    }

    private BasicBlock createNewBB(DirectedGraph<BasicBlock, CFG_Edge> g, Map<Label, BasicBlock> bbMap) {
        return this.createNewBB(this.getNewLabel(), g, bbMap);
    }

    private void addEdge(DirectedGraph<BasicBlock, CFG_Edge> g, BasicBlock src, Label tgt, Map<Label, BasicBlock> bbMap, Map<Label, List<BasicBlock>> forwardRefs) {
        BasicBlock tgtBB = bbMap.get(tgt);
        if (tgtBB != null) {
            g.addEdge((Object)src, (Object)tgtBB);
        } else {
            List<BasicBlock> frefs = forwardRefs.get(tgt);
            if (frefs == null) {
                frefs = new ArrayList<BasicBlock>();
                forwardRefs.put(tgt, frefs);
            }
            frefs.add(src);
        }
    }

    public void build(List<IR_Instr> instrs) {
        HashMap<Label, List<BasicBlock>> forwardRefs = new HashMap<Label, List<BasicBlock>>();
        HashMap<Variable, HashSet<Label>> retAddrMap = new HashMap<Variable, HashSet<Label>>();
        ArrayList<BasicBlock> retBBs = new ArrayList<BasicBlock>();
        HashMap<RESCUED_BODY_END_MARKER_Instr, BasicBlock> rbeMarkers = new HashMap<RESCUED_BODY_END_MARKER_Instr, BasicBlock>();
        DefaultDirectedGraph g = new DefaultDirectedGraph((EdgeFactory)new EdgeFactory<BasicBlock, CFG_Edge>(){

            public CFG_Edge createEdge(BasicBlock s, BasicBlock d) {
                return new CFG_Edge(s, d);
            }
        });
        this._entryBB = this.createNewBB((DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap);
        BasicBlock firstBB = this.createNewBB((DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap);
        BasicBlock prevBB = null;
        BasicBlock currBB = firstBB;
        BasicBlock newBB = null;
        boolean bbEnded = false;
        boolean bbEndedWithControlXfer = false;
        for (IR_Instr i : instrs) {
            Operation iop = i._op;
            if (iop == Operation.LABEL) {
                Label l = ((LABEL_Instr)i)._lbl;
                prevBB = currBB;
                newBB = this.createNewBB(l, (DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap);
                if (!bbEndedWithControlXfer) {
                    g.addEdge((Object)currBB, (Object)newBB);
                }
                currBB = newBB;
                List frefs = (List)forwardRefs.get(l);
                if (frefs != null) {
                    for (BasicBlock b : frefs) {
                        g.addEdge((Object)b, (Object)newBB);
                    }
                }
                bbEnded = false;
                bbEndedWithControlXfer = false;
            } else if (bbEnded && iop != Operation.RESCUE_BODY_END) {
                prevBB = currBB;
                newBB = this.createNewBB((DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap);
                if (!bbEndedWithControlXfer) {
                    g.addEdge((Object)currBB, (Object)newBB);
                }
                currBB = newBB;
                bbEnded = false;
                bbEndedWithControlXfer = false;
            }
            if (i instanceof RESCUED_BODY_START_MARKER_Instr) {
                ((RESCUED_BODY_START_MARKER_Instr)i).setRescuedBodyStartBB(currBB);
            } else if (i instanceof RESCUED_BODY_END_MARKER_Instr) {
                currBB.addInstr(i);
                rbeMarkers.put((RESCUED_BODY_END_MARKER_Instr)i, currBB);
            } else if (iop.endsBasicBlock()) {
                Label tgt;
                bbEnded = true;
                currBB.addInstr(i);
                if (i instanceof BRANCH_Instr) {
                    tgt = ((BRANCH_Instr)i).getJumpTarget();
                } else if (i instanceof JUMP_Instr) {
                    tgt = ((JUMP_Instr)i).getJumpTarget();
                    bbEndedWithControlXfer = true;
                } else if (i instanceof CASE_Instr) {
                    tgt = null;
                } else if (i instanceof BREAK_Instr) {
                    tgt = null;
                    bbEndedWithControlXfer = true;
                } else if (i instanceof RETURN_Instr) {
                    tgt = null;
                    retBBs.add(currBB);
                    bbEndedWithControlXfer = true;
                } else if (i instanceof THROW_EXCEPTION_Instr) {
                    tgt = null;
                    retBBs.add(currBB);
                    bbEndedWithControlXfer = true;
                } else if (i instanceof JUMP_INDIRECT_Instr) {
                    tgt = null;
                    bbEndedWithControlXfer = true;
                    Set retAddrs = (Set)retAddrMap.get(((JUMP_INDIRECT_Instr)i)._target);
                    for (Label l : retAddrs) {
                        this.addEdge((DirectedGraph<BasicBlock, CFG_Edge>)g, currBB, l, this._bbMap, forwardRefs);
                    }
                } else {
                    tgt = null;
                }
                if (tgt != null) {
                    this.addEdge((DirectedGraph<BasicBlock, CFG_Edge>)g, currBB, tgt, this._bbMap, forwardRefs);
                }
            } else if (iop != Operation.LABEL) {
                currBB.addInstr(i);
            }
            if (i instanceof SET_RETADDR_Instr) {
                Variable v = i.getResult();
                HashSet<Label> addrs = (HashSet<Label>)retAddrMap.get(v);
                if (addrs == null) {
                    addrs = new HashSet<Label>();
                    retAddrMap.put(v, addrs);
                }
                addrs.add(((SET_RETADDR_Instr)i).getReturnAddr());
                continue;
            }
            if (!(i instanceof BUILD_CLOSURE_Instr)) continue;
            ((BUILD_CLOSURE_Instr)i).getClosure().buildCFG();
        }
        for (RESCUED_BODY_END_MARKER_Instr rbEnd : rbeMarkers.keySet()) {
            BasicBlock rbEndBB = (BasicBlock)rbeMarkers.get(rbEnd);
            RESCUED_BODY_START_MARKER_Instr rbStart = rbEnd._rbStartInstr;
            rbStart.setRescuedBodyEndBB(rbEndBB);
            for (Label l : rbStart._rescueBlockLabels) {
                BasicBlock rescueBlockStartBB = this.getTargetBB(l);
                rescueBlockStartBB.setRescuedBodyEndBB(rbEndBB);
                ((CFG_Edge)g.addEdge((Object)rbEndBB, (Object)rescueBlockStartBB))._type = CFG_Edge_Type.EXCEPTION_EDGE;
            }
        }
        this._exitBB = this.createNewBB((DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap);
        ((CFG_Edge)g.addEdge((Object)this._entryBB, (Object)this._exitBB))._type = CFG_Edge_Type.DUMMY_EDGE;
        ((CFG_Edge)g.addEdge((Object)this._entryBB, (Object)firstBB))._type = CFG_Edge_Type.DUMMY_EDGE;
        for (BasicBlock rb : retBBs) {
            ((CFG_Edge)g.addEdge((Object)rb, (Object)this._exitBB))._type = CFG_Edge_Type.DUMMY_EDGE;
        }
        if (!bbEndedWithControlXfer) {
            ((CFG_Edge)g.addEdge((Object)currBB, (Object)this._exitBB))._type = CFG_Edge_Type.DUMMY_EDGE;
        }
        int n = this.getMaxNodeID();
        this._bbArray = new BasicBlock[n];
        Iterator<BasicBlock> i$ = this._bbMap.values().iterator();
        while (i$.hasNext()) {
            BasicBlock x;
            this._bbArray[x.getID() - 1] = x = i$.next();
        }
        this._cfg = g;
    }

    private void buildPostOrderTraversal() {
        this._postOrderList = new LinkedList();
        BasicBlock root = this.getEntryBB();
        Stack<BasicBlock> stack = new Stack<BasicBlock>();
        stack.push(root);
        BitSet bbSet = new BitSet(1 + this.getMaxNodeID());
        bbSet.set(root.getID());
        while (!stack.empty()) {
            BasicBlock b = (BasicBlock)stack.peek();
            boolean allChildrenDone = true;
            for (CFG_Edge e : this._cfg.outgoingEdgesOf((Object)b)) {
                BasicBlock dst = e._dst;
                int dstID = dst.getID();
                if (bbSet.get(dstID)) continue;
                allChildrenDone = false;
                stack.push(dst);
                bbSet.set(dstID);
            }
            if (!allChildrenDone) continue;
            stack.pop();
            this._postOrderList.add(b);
        }
    }

    public ListIterator<BasicBlock> getPostOrderTraverser() {
        if (this._postOrderList == null) {
            this.buildPostOrderTraversal();
        }
        return this._postOrderList.listIterator();
    }

    public ListIterator<BasicBlock> getReversePostOrderTraverser() {
        if (this._postOrderList == null) {
            this.buildPostOrderTraversal();
        }
        return this._postOrderList.listIterator(this.getMaxNodeID());
    }

    private Integer intersectDomSets(Integer[] idomMap, Integer nb1, Integer nb2) {
        while (nb1 != nb2) {
            while (nb1 < nb2) {
                nb1 = idomMap[nb1];
            }
            while (nb2 < nb1) {
                nb2 = idomMap[nb2];
            }
        }
        return nb1;
    }

    public void buildDominatorTree() {
        Integer rootPoNumber;
        int maxNodeId = this.getMaxNodeID();
        Integer[] bbToPoNumbers = new Integer[maxNodeId + 1];
        BasicBlock[] poNumbersToBB = new BasicBlock[maxNodeId + 1];
        ListIterator<BasicBlock> it = this.getPostOrderTraverser();
        int n = 0;
        while (it.hasNext()) {
            BasicBlock b = it.next();
            bbToPoNumbers[b.getID()] = n;
            poNumbersToBB[n] = b;
            ++n;
        }
        Integer[] idoms = new Integer[maxNodeId + 1];
        BasicBlock root = this.getEntryBB();
        idoms[rootPoNumber.intValue()] = rootPoNumber = bbToPoNumbers[root.getID()];
        boolean changed = true;
        while (changed) {
            changed = false;
            it = this.getReversePostOrderTraverser();
            while (it.hasPrevious()) {
                BasicBlock b = it.previous();
                if (b == root) continue;
                Integer bPoNumber = bbToPoNumbers[b.getID()];
                Integer oldBIdom = idoms[bPoNumber];
                Integer newBIdom = null;
                for (CFG_Edge e : this._cfg.incomingEdgesOf((Object)b)) {
                    BasicBlock src = e._src;
                    Integer srcPoNumber = bbToPoNumbers[src.getID()];
                    if (idoms[srcPoNumber] == null) continue;
                    newBIdom = srcPoNumber;
                    break;
                }
                assert (newBIdom != null);
                Integer processedPred = newBIdom;
                for (CFG_Edge e : this._cfg.incomingEdgesOf((Object)b)) {
                    BasicBlock src = e._src;
                    Integer srcPoNumber = bbToPoNumbers[src.getID()];
                    Integer srcIdom = idoms[srcPoNumber];
                    if (srcIdom == null || srcPoNumber == processedPred) continue;
                    newBIdom = this.intersectDomSets(idoms, srcPoNumber, newBIdom);
                }
                if (oldBIdom == newBIdom) continue;
                changed = true;
                idoms[bPoNumber.intValue()] = newBIdom;
            }
        }
        HashMap<BasicBlock, BasicBlock> idomMap = new HashMap<BasicBlock, BasicBlock>();
        Integer i = 0;
        while (i < maxNodeId) {
            idomMap.put(poNumbersToBB[i], poNumbersToBB[idoms[i]]);
            Integer n2 = i;
            Integer n3 = i = Integer.valueOf(i + 1);
        }
    }

    public String toStringInstrs() {
        StringBuffer buf = new StringBuffer();
        for (BasicBlock b : this.getNodes()) {
            buf.append(b.toStringInstrs());
        }
        List<IR_Closure> closures = this._scope.getClosures();
        if (!closures.isEmpty()) {
            buf.append("\n\n------ Closures encountered in this scope ------\n");
            for (IR_Closure c : closures) {
                buf.append(c.toStringBody());
            }
            buf.append("------------------------------------------------\n");
        }
        return buf.toString();
    }

    public void setDataFlowSolution(String name2, DataFlowProblem p2) {
        this._dfProbs.put(name2, p2);
    }

    public DataFlowProblem getDataFlowSolution(String name2) {
        return this._dfProbs.get(name2);
    }

    public static class CFG_Edge {
        public final BasicBlock _src;
        public final BasicBlock _dst;
        public CFG_Edge_Type _type;

        public CFG_Edge(BasicBlock s, BasicBlock d) {
            this._src = s;
            this._dst = d;
            this._type = CFG_Edge_Type.UNKNOWN;
        }

        public String toString() {
            return "<" + this._src.getID() + " --> " + this._dst.getID() + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CFG_Edge_Type {
        UNKNOWN,
        DUMMY_EDGE,
        FALLTHRU_EDGE,
        FORWARD_EDGE,
        BACK_EDGE,
        EXIT_EDGE,
        EXCEPTION_EDGE;

    }
}

