/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ir.IR_ExecutionScope;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.CFG;

public class IR_Closure
extends IR_ExecutionScope {
    public final Label _startLabel = this.getNewLabel("_CLOSURE_START");
    public final Label _endLabel = this.getNewLabel("_CLOSURE_END");
    public final int _closureId = this.getNextClosureId();
    public final String _name = "_CLOSURE_" + this._closureId;

    public IR_Closure(IR_Scope lexicalParent) {
        super(lexicalParent, new MetaObject(lexicalParent));
    }

    public int getNextClosureId() {
        return this._lexicalParent.getNextClosureId();
    }

    public Variable getNewTemporaryVariable() {
        return this.getNewTemporaryClosureVariable(this._closureId);
    }

    public void setConstantValue(String constRef, Operand val) {
        throw new NotCompilableException("Unexpected: Encountered set constant value in a closure!");
    }

    public String toString() {
        return this._name;
    }

    public String toStringBody() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._name).append(" = { \n");
        CFG c = this.getCFG();
        if (c != null) {
            buf.append("\nCFG:\n").append(c.getGraph().toString());
            buf.append("\nInstructions:\n").append(c.toStringInstrs());
        } else {
            buf.append(this.toStringInstrs());
        }
        buf.append("\n}\n\n");
        return buf.toString();
    }
}

