/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.debug.DebugBreakpoint;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

public class Breakpoint
extends RubyObject {
    private static final long serialVersionUID = 1L;

    protected Breakpoint(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    DebugBreakpoint debuggerBreakpoint() {
        return (DebugBreakpoint)this.dataGetStruct();
    }

    @JRubyMethod(name={"enabled="}, required=1)
    public IRubyObject setEnabled(IRubyObject enabled, Block block) {
        this.debuggerBreakpoint().setEnabled(enabled.isTrue());
        return enabled;
    }

    @JRubyMethod(name={"enabled?"})
    public IRubyObject isEnabled(Block block) {
        return this.getRuntime().newBoolean(this.debuggerBreakpoint().isEnabled());
    }

    @JRubyMethod(name={"id"})
    public RubyFixnum id(Block block) {
        return this.getRuntime().newFixnum(this.debuggerBreakpoint().getId());
    }

    @JRubyMethod(name={"source"})
    public IRubyObject source(Block block) {
        return this.debuggerBreakpoint().getSource();
    }

    @JRubyMethod(name={"source="}, required=1)
    public IRubyObject source_set(IRubyObject source, Block block) {
        this.debuggerBreakpoint().setSource((IRubyObject)source.convertToString());
        return source;
    }

    @JRubyMethod(name={"pos"})
    public IRubyObject pos(Block block) {
        DebugBreakpoint debugBreakpoint = this.debuggerBreakpoint();
        if (debugBreakpoint.getType() == DebugBreakpoint.Type.METHOD) {
            return this.getRuntime().newString(this.debuggerBreakpoint().getPos().getMethodName());
        }
        return this.getRuntime().newFixnum(this.debuggerBreakpoint().getPos().getLine());
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject pos_set(IRubyObject pos, Block block) {
        DebugBreakpoint debugBreakpoint = this.debuggerBreakpoint();
        if (debugBreakpoint.getType() == DebugBreakpoint.Type.METHOD) {
            debugBreakpoint.getPos().setMethodName(pos.convertToString().toString());
        } else {
            debugBreakpoint.getPos().setLine(RubyNumeric.fix2int((IRubyObject)pos));
        }
        return pos;
    }

    @JRubyMethod(name={"expr"})
    public IRubyObject expr(Block block) {
        return this.debuggerBreakpoint().getExpr();
    }

    @JRubyMethod(name={"expr="}, required=1)
    public IRubyObject expr_set(IRubyObject expr, Block block) {
        this.debuggerBreakpoint().setExpr((IRubyObject)(expr.isNil() ? expr : expr.convertToString()));
        return expr;
    }

    @JRubyMethod(name={"hit_count"})
    public IRubyObject hit_count(Block block) {
        return this.getRuntime().newFixnum(this.debuggerBreakpoint().getHitCount());
    }

    @JRubyMethod(name={"hit_value"})
    public IRubyObject hit_value(Block block) {
        return this.getRuntime().newFixnum(this.debuggerBreakpoint().getHitValue());
    }

    @JRubyMethod(name={"hit_value="}, required=1)
    public IRubyObject hit_value_set(IRubyObject hit_value, Block block) {
        this.debuggerBreakpoint().setHitValue(RubyNumeric.fix2int((IRubyObject)hit_value));
        return hit_value;
    }

    @JRubyMethod(name={"hit_condition"})
    public IRubyObject hit_condition(Block block) {
        DebugBreakpoint.HitCondition cond = this.debuggerBreakpoint().getHitCondition();
        if (cond == null) {
            return this.getRuntime().getNil();
        }
        switch (cond) {
            case GE: {
                return this.getRuntime().newSymbol("greater_or_equal");
            }
            case EQ: {
                return this.getRuntime().newSymbol("equal");
            }
            case MOD: {
                return this.getRuntime().newSymbol("modulo");
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"hit_condition="}, required=1)
    public IRubyObject hit_condition_set(IRubyObject hit_condition, Block block) {
        DebugBreakpoint debugBreakpoint = this.debuggerBreakpoint();
        if (!this.getRuntime().getSymbol().isInstance(hit_condition)) {
            throw this.getRuntime().newArgumentError("Invalid condition parameter");
        }
        String symbol = ((RubySymbol)hit_condition).asJavaString();
        if (symbol.equals("greater_or_equal") || symbol.equals("ge")) {
            debugBreakpoint.setHitCondition(DebugBreakpoint.HitCondition.GE);
        } else if (symbol.equals("equal") || symbol.equals("eq")) {
            debugBreakpoint.setHitCondition(DebugBreakpoint.HitCondition.EQ);
        } else if (symbol.equals("modulo") || symbol.equals("mod")) {
            debugBreakpoint.setHitCondition(DebugBreakpoint.HitCondition.MOD);
        } else {
            throw this.getRuntime().newArgumentError("Invalid condition parameter");
        }
        return hit_condition;
    }
}

