/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.ConvertIfToUnless;
import org.netbeans.modules.ruby.hints.RubyHints;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConvertConditionals
extends RubyAstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.IFNODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        ConvertToModifier fix;
        Node node = context.node;
        ParserResult info = context.parserResult;
        IfNode ifNode = (IfNode)node;
        if (ifNode.getCondition() == null) {
            return;
        }
        Node body = ifNode.getThenBody();
        Node elseNode = ifNode.getElseBody();
        if (body != null && elseNode != null) {
            return;
        }
        if (body == null && elseNode == null) {
            return;
        }
        if (ifNode.getElseBody() != null && ifNode.getElseBody().getNodeType() == NodeType.IFNODE) {
            return;
        }
        int start = ifNode.getPosition().getStartOffset();
        if (!(RubyHints.isNullOrInvisible(body) || body.getNodeType() != NodeType.BLOCKNODE && body.getPosition().getStartOffset() > start)) {
            return;
        }
        if (!(RubyHints.isNullOrInvisible(elseNode) || elseNode.getNodeType() != NodeType.BLOCKNODE && elseNode.getPosition().getStartOffset() > start)) {
            return;
        }
        BaseDocument doc = context.doc;
        try {
            int keywordOffset = ConvertIfToUnless.findKeywordOffset(context, ifNode);
            if (keywordOffset == -1 || keywordOffset > doc.getLength() - 1) {
                return;
            }
            char k = doc.getText(keywordOffset, 1).charAt(0);
            if (k != 'i' && k != 'u') {
                return;
            }
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        OffsetRange range = AstUtilities.getRange((Node)node);
        if (RubyUtils.isRhtmlDocument((Document)doc) || RubyUtils.isYamlDocument((Document)doc)) {
            if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) == OffsetRange.NONE) {
                return;
            }
            try {
                doc.readLock();
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = th.tokenSequence();
                ts.move(range.getStart());
                if (!ts.moveNext() && !ts.movePrevious()) {
                    return;
                }
                if (ts.offset() + ts.token().length() < range.getEnd()) {
                    return;
                }
            }
            finally {
                doc.readUnlock();
            }
        }
        if ((fix = new ConvertToModifier(context, ifNode)).getEditList() == null) {
            return;
        }
        List<ConvertToModifier> fixes = Collections.singletonList(fix);
        String displayName = NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionals");
        Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixes, 500);
        result.add(desc);
    }

    public String getId() {
        return "ConvertConditionals";
    }

    public String getDescription() {
        return NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionalsDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionals");
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    private class ConvertToModifier
    implements PreviewableFix {
        private final RubyRuleContext context;
        private IfNode ifNode;

        public ConvertToModifier(RubyRuleContext context, IfNode ifNode) {
            this.context = context;
            this.ifNode = ifNode;
        }

        public String getDescription() {
            return NbBundle.getMessage(ConvertConditionals.class, (String)"ConvertConditionalsFix");
        }

        public void implement() throws Exception {
            EditList edits = this.getEditList();
            if (edits != null) {
                edits.apply();
            }
        }

        public EditList getEditList() {
            try {
                boolean isIf;
                BaseDocument doc = this.context.doc;
                Node bodyNode = this.ifNode.getThenBody();
                boolean bl = isIf = bodyNode != null;
                if (bodyNode == null) {
                    bodyNode = this.ifNode.getElseBody();
                }
                ParserResult info = this.context.parserResult;
                OffsetRange bodyRange = AstUtilities.getRange((Node)bodyNode);
                if ((bodyRange = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)bodyRange)) == OffsetRange.NONE) {
                    return null;
                }
                String body = doc.getText(bodyRange.getStart(), bodyRange.getLength()).trim();
                if (body.endsWith(";")) {
                    body = body.substring(0, body.length() - 1);
                }
                StringBuilder sb = new StringBuilder();
                sb.append(body);
                sb.append(" ");
                sb.append(isIf ? "if" : "unless");
                sb.append(" ");
                OffsetRange range = AstUtilities.getRange((Node)this.ifNode.getCondition());
                range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range);
                if (range == OffsetRange.NONE) {
                    return null;
                }
                sb.append(doc.getText(range.getStart(), range.getLength()));
                OffsetRange ifRange = AstUtilities.getRange((Node)this.ifNode);
                ifRange = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)ifRange);
                if (ifRange == OffsetRange.NONE) {
                    return null;
                }
                return new EditList(doc).replace(ifRange.getStart(), ifRange.getLength(), sb.toString(), false, 0);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

