/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCTask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCToolTask
extends JCTask {
    public JCToolTask(String className) {
        super.setClassname(className);
    }

    public void execute() throws BuildException {
        super.setClasspath(new Path(this.getProject(), this.getProp("javacard.toolClassPath")));
        this.setFork(!Boolean.getBoolean("javacard.ant.unit.test"));
        this.createJvmarg().setValue("-Djc.home=" + this.getProp("javacard.home"));
        this.log("Execute\n" + this.getCommandLine(), 3);
        this.executeJava();
    }

    public final String getProjectProperty(String name) {
        return this.getProject().getProperty(name);
    }

    protected boolean getBool(String key) {
        String val = this.getProp(key, false);
        return val == null ? false : Boolean.valueOf(val);
    }

    protected String getProp(String key) throws BuildException {
        return this.getProp(key, true);
    }

    protected String getProp(String key, boolean failOnNull) throws BuildException {
        String result = this.getProject().getProperty(key);
        if (failOnNull && result == null) {
            throw new BuildException(key + " not set");
        }
        return result;
    }

    protected File getFileProp(String key) throws BuildException {
        return this.getFileProp(key, true);
    }

    protected File getFileProp(String key, boolean mustBeSet) throws BuildException {
        String prop = this.getProp(key, mustBeSet);
        if (prop != null) {
            prop = prop.replace('/', File.separatorChar);
            File f = new File(prop);
            File[] roots = File.listRoots();
            boolean absolute = false;
            if (f != null) {
                for (File r : roots) {
                    String s;
                    if (prop.startsWith(r.getAbsolutePath())) {
                        absolute = true;
                        break;
                    }
                    File upper = new File(r.getAbsolutePath().toUpperCase());
                    if (!upper.exists() || !(s = prop.toUpperCase()).startsWith(upper.getAbsolutePath())) continue;
                    absolute = true;
                    break;
                }
            }
            if (absolute) {
                this.log("Resolved " + key + " as absolute file " + f);
                return f;
            }
            f = new File(this.getProject().getBaseDir(), prop);
            this.log("Resolved " + key + " as relative file " + f);
            return f;
        }
        this.log("File prop " + key + " not set: " + prop);
        return null;
    }

    protected String getExportPath() throws BuildException {
        String str = this.getProp("export.path", false);
        str = str == null || str.trim().length() == 0 ? "" : str.trim();
        ArrayList<String> expFileKeys = new ArrayList<String>();
        Hashtable ht = this.getProject().getProperties();
        for (Object obj : ht.keySet()) {
            String key = (String)obj;
            if (!(key = key.trim()).endsWith(".expfile")) continue;
            expFileKeys.add(key);
        }
        String exportPath = this.getExportPathForExpFiles(expFileKeys);
        if (exportPath != null && exportPath.length() > 0) {
            if (str.length() > 0) {
                exportPath = exportPath + File.pathSeparator + str;
            }
        } else {
            exportPath = str.length() > 0 ? str : "";
        }
        return exportPath;
    }

    private String getExportPathForExpFiles(ArrayList<String> expFileKeys) throws BuildException {
        String exportPath = "";
        Hashtable ht = this.getProject().getProperties();
        for (String expFileKey : expFileKeys) {
            String capFile;
            String capFileKey = expFileKey.substring(0, expFileKey.indexOf(".expfile")) + ".origin";
            if (expFileKey.startsWith("dependency..")) {
                String expFileKey2 = expFileKey.replace("dependency..", "dependency.");
                capFileKey = expFileKey2.substring(0, expFileKey2.indexOf(".expfile")) + ".origin";
            }
            if ((capFile = (String)ht.get(capFileKey)) == null) {
                throw new BuildException("Couldn't find CAP file corresponding to export file listed in dependencies");
            }
            String packagePath = this.getPackagePath(capFile);
            if (packagePath == null) continue;
            String expFile = (String)ht.get(expFileKey);
            int javacardDirIndex = expFile.indexOf(packagePath + "/javacard/");
            String expFileSegment = javacardDirIndex >= 0 ? expFile.substring(0, javacardDirIndex) : expFile;
            if (exportPath.length() > 0) {
                exportPath = exportPath + File.pathSeparator;
            }
            this.log("Resolve export path for " + expFileKey + " to " + expFileSegment, 3);
            exportPath = exportPath + expFileSegment;
        }
        this.log("Computed export path as " + exportPath, 3);
        return exportPath;
    }

    private String getPackagePath(String capFile) throws BuildException {
        String packagePath = null;
        ZipFile jar = null;
        try {
            jar = new JarFile(new File(this.getProject().getBaseDir(), capFile));
            if (jar == null) {
                throw new BuildException("Couldn't open file: " + capFile + " listed in dependencies");
            }
            Enumeration<JarEntry> jarEntries = ((JarFile)jar).entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                packagePath = entryName.contains("/") ? "/" + entryName.substring(0, entryName.lastIndexOf(47)) : "/";
                break;
            }
        }
        catch (IOException e) {
            throw new BuildException("Error while openinig file: " + capFile + " listed in dependencies");
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {}
            }
        }
        return packagePath;
    }
}

