/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteCookie;
import org.netbeans.modules.db.spi.sql.editor.SQLEditorProvider;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SQLEditorProviderImpl
implements SQLEditorProvider {
    private static final String CMD_FOLDER = "Databases/SQLCommands";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSQLEditor(DatabaseConnection dbconn, String sql, boolean execute) {
        DataObject sqlDo;
        FileObject tmpFo = FileUtil.getConfigFile((String)CMD_FOLDER);
        if (tmpFo == null) {
            try {
                tmpFo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)CMD_FOLDER);
            }
            catch (IOException e) {
                Logger.getLogger(SQLEditorProviderImpl.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
            }
        }
        FileObject sqlFo = null;
        int i = 1;
        while (true) {
            String nameFmt = NbBundle.getMessage(SQLEditorProviderImpl.class, (String)"LBL_SQLCommandFileName");
            String name = MessageFormat.format(nameFmt, new Integer(i));
            try {
                sqlFo = tmpFo.createData(name);
            }
            catch (IOException e) {
                ++i;
                continue;
            }
            break;
        }
        try {
            FileLock lock = sqlFo.lock();
            try {
                OutputStream stream = sqlFo.getOutputStream(lock);
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
                    try {
                        writer.write(sql);
                    }
                    finally {
                        writer.close();
                    }
                }
                finally {
                    stream.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        try {
            sqlDo = DataObject.find((FileObject)sqlFo);
        }
        catch (DataObjectNotFoundException e) {
            Logger.getLogger(SQLEditorProviderImpl.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
            return;
        }
        OpenCookie openCookie = (OpenCookie)sqlDo.getCookie(OpenCookie.class);
        openCookie.open();
        SQLExecuteCookie sqlCookie = (SQLExecuteCookie)sqlDo.getCookie(SQLExecuteCookie.class);
        if (sqlCookie != null) {
            sqlCookie.setDatabaseConnection(dbconn);
            if (execute) {
                sqlCookie.execute();
            }
        } else {
            Logger.getLogger(SQLEditorProviderImpl.class.getName()).log(Level.INFO, "No SQLExecuteCookie found for " + sqlDo);
        }
    }
}

