/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.analyzer.TablesClause;

public class SelectStatement
extends SQLStatement {
    private final List<List<String>> selectValues;

    SelectStatement(int startOffset, int endOffset, List<List<String>> selectValues, TablesClause fromClause, List<SelectStatement> subqueries, SortedMap<Integer, SQLStatement.Context> offset2Context) {
        super(startOffset, endOffset, offset2Context, fromClause, subqueries);
        this.kind = SQLStatementKind.SELECT;
        this.selectValues = selectValues;
    }

    public TablesClause getTablesInEffect(int offset) {
        ArrayList<SelectStatement> statementPath = new ArrayList<SelectStatement>();
        this.fillStatementPath(offset, statementPath);
        if (statementPath.size() == 0) {
            return null;
        }
        if (statementPath.size() == 1) {
            return ((SelectStatement)statementPath.get(0)).getTablesClause();
        }
        Collections.reverse(statementPath);
        HashSet<QualIdent> unaliasedTableNames = new HashSet<QualIdent>();
        HashMap<String, QualIdent> aliasedTableNames = new HashMap<String, QualIdent>();
        for (SelectStatement statement : statementPath) {
            TablesClause statementFromClause = statement.getTablesClause();
            if (statementFromClause == null) continue;
            unaliasedTableNames.addAll(statementFromClause.getUnaliasedTableNames());
            for (Map.Entry<String, QualIdent> entry : statementFromClause.getAliasedTableNames().entrySet()) {
                String alias = entry.getKey();
                QualIdent tableName = entry.getValue();
                if (aliasedTableNames.containsKey(alias)) continue;
                aliasedTableNames.put(alias, tableName);
            }
        }
        return new TablesClause(Collections.unmodifiableSet(unaliasedTableNames), Collections.unmodifiableMap(aliasedTableNames));
    }

    public List<List<String>> getSelectValues() {
        return this.selectValues;
    }

    private void fillStatementPath(int offset, List<SelectStatement> path) {
        if (offset >= this.startOffset && offset <= this.endOffset) {
            path.add(this);
            for (SelectStatement subquery : this.getSubqueries()) {
                subquery.fillStatementPath(offset, path);
            }
        }
    }
}

