/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.OutputOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.CopyAction;
import org.netbeans.jellytools.actions.FindAction;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.openide.util.Lookup;

public class OutputTabOperator
extends JComponentOperator {
    ComponentOperator outputPaneOperator;
    private static final Action findNextAction = new Action(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_FIND_NEXT"), null, KeyStroke.getKeyStroke(114, 0));
    private static final Action selectAllAction = new Action(null, null, null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(65, 4) : KeyStroke.getKeyStroke(65, 2));
    private static final Action wrapTextAction = new Action(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_WRAP"), null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(87, 4) : KeyStroke.getKeyStroke(87, 2));
    private static final ActionNoBlock saveAsAction = new ActionNoBlock(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_SAVEAS"), null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(83, 4) : KeyStroke.getKeyStroke(83, 2));
    private static final Action nextErrorAction = new Action(null, null, null, KeyStroke.getKeyStroke(123, 0));
    private static final Action previousErrorAction = new Action(null, null, null, KeyStroke.getKeyStroke(123, 1));
    private static final Action closeAction = new Action(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_CLOSE"), null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(115, 4) : KeyStroke.getKeyStroke(115, 2));
    private static final Action clearAction = new Action(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_CLEAR"), null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(76, 4) : KeyStroke.getKeyStroke(76, 2));
    private static final CopyAction copyAction = new CopyAction();
    private static final FindAction findAction = new FindAction();
    private JButtonOperator btnReRun;
    private JButtonOperator btnStop;
    private JButtonOperator btnAntSettings;

    public OutputTabOperator(JComponent source) {
        super(source);
    }

    public OutputTabOperator(String name) {
        this(name, 0);
    }

    public OutputTabOperator(String name, int index) {
        super((JComponent)new OutputOperator().waitSubComponent(new OutputTabSubchooser(name), index));
        this.makeComponentVisible();
    }

    public JButtonOperator btnReRun() {
        if (this.btnReRun == null) {
            ContainerOperator co = new ContainerOperator(this.getParent());
            this.btnReRun = new JButtonOperator(co);
        }
        return this.btnReRun;
    }

    public JButtonOperator btnStop() {
        if (this.btnStop == null) {
            ContainerOperator co = new ContainerOperator(this.getParent());
            this.btnStop = new JButtonOperator(co, 1);
        }
        return this.btnStop;
    }

    public JButtonOperator btnAntSettings() {
        if (this.btnAntSettings == null) {
            ContainerOperator co = new ContainerOperator(this.getParent());
            this.btnAntSettings = new JButtonOperator(co, 2);
        }
        return this.btnAntSettings;
    }

    public void makeComponentVisible() {
        if (this.getParent() instanceof JTabbedPane) {
            super.makeComponentVisible();
            new JTabbedPaneOperator((JTabbedPane)this.getParent()).setSelectedComponent(this.getSource());
        } else {
            new OutputOperator().makeComponentVisible();
        }
    }

    public int getLength() {
        return this.runMapping(new Operator.MapIntegerAction("getLength"){

            public int map() {
                Document document = OutputTabOperator.documentForTab(OutputTabOperator.this.getSource());
                try {
                    Method getLengthMethod = OutputTabOperator.this.getOutputDocumentClass().getDeclaredMethod("getLength", null);
                    getLengthMethod.setAccessible(true);
                    return (Integer)getLengthMethod.invoke((Object)document, (Object[])null);
                }
                catch (Exception e) {
                    throw new JemmyException("getLength() by reflection failed.", (Throwable)e);
                }
            }
        });
    }

    public int findLine(String lineText) {
        int lineCount = this.getLineCount();
        if (lineCount < 1) {
            return -1;
        }
        for (int i = 0; i < lineCount; ++i) {
            if (!this.getComparator().equals(this.getLine(i), lineText)) continue;
            return i;
        }
        return -1;
    }

    public String getText() {
        final int length = this.getLength();
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() {
                Document document = OutputTabOperator.documentForTab(OutputTabOperator.this.getSource());
                try {
                    Method getTextMethod = OutputTabOperator.this.getOutputDocumentClass().getDeclaredMethod("getText", Integer.TYPE, Integer.TYPE);
                    getTextMethod.setAccessible(true);
                    return getTextMethod.invoke((Object)document, 0, length).toString();
                }
                catch (Exception e) {
                    throw new JemmyException("Getting text by reflection failed.", (Throwable)e);
                }
            }
        });
    }

    public String getText(int startLine, int endLine) {
        StringBuffer result = new StringBuffer();
        for (int i = startLine; i <= endLine; ++i) {
            result.append(this.getLine(i));
            result.append('\n');
        }
        return result.toString();
    }

    public void waitText(final String text) {
        this.getOutput().printLine("Wait \"" + text + "\" text in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + text + "\" text");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return OutputTabOperator.this.findLine(text) > -1;
            }

            public String getDescription() {
                return "\"" + text + "\" text";
            }
        });
    }

    public int getLineCount() {
        return (Integer)this.runMapping(new Operator.MapAction("getLineCount"){

            public Object map() {
                Document document = OutputTabOperator.documentForTab(OutputTabOperator.this.getSource());
                try {
                    Method getElementCountMethod = OutputTabOperator.this.getOutputDocumentClass().getDeclaredMethod("getElementCount", null);
                    getElementCountMethod.setAccessible(true);
                    return (Integer)getElementCountMethod.invoke((Object)document, (Object[])null);
                }
                catch (Exception e) {
                    throw new JemmyException("getElementCount() by reflection failed.", (Throwable)e);
                }
            }
        });
    }

    private Class getOutputDocumentClass() throws ClassNotFoundException {
        ClassLoader scl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        return Class.forName("org.netbeans.core.output2.OutputDocument", true, scl);
    }

    public ComponentOperator outputPaneOperator() {
        this.makeComponentVisible();
        if (this.outputPaneOperator == null) {
            this.outputPaneOperator = ComponentOperator.createOperator((Component)OutputTabOperator.outputPaneForTab(this.getSource()));
            this.outputPaneOperator.copyEnvironment((Operator)this);
        }
        return this.outputPaneOperator;
    }

    public String getLine(final int line) {
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() {
                Document document = OutputTabOperator.documentForTab(OutputTabOperator.this.getSource());
                try {
                    Class clazz = OutputTabOperator.this.getOutputDocumentClass();
                    Method getLineStartMethod = clazz.getDeclaredMethod("getLineStart", Integer.TYPE);
                    getLineStartMethod.setAccessible(true);
                    Integer lineStart = (Integer)getLineStartMethod.invoke((Object)document, line);
                    Method getLineEndMethod = clazz.getDeclaredMethod("getLineEnd", Integer.TYPE);
                    getLineEndMethod.setAccessible(true);
                    Integer lineEnd = (Integer)getLineEndMethod.invoke((Object)document, line);
                    if (lineStart.intValue() == lineEnd.intValue()) {
                        return "";
                    }
                    Method getTextMethod = clazz.getDeclaredMethod("getText", Integer.TYPE, Integer.TYPE);
                    getTextMethod.setAccessible(true);
                    return getTextMethod.invoke((Object)document, lineStart, lineEnd - lineStart).toString();
                }
                catch (Exception e) {
                    throw new JemmyException("Getting text by reflection failed.", (Throwable)e);
                }
            }
        });
    }

    private static Component outputPaneForTab(Component tab) {
        try {
            return (Component)tab.getClass().getMethod("getOutputPane", new Class[0]).invoke((Object)tab, new Object[0]);
        }
        catch (Exception x) {
            throw new JemmyException("Reflection failed: " + x, (Throwable)x);
        }
    }

    private static Document documentForTab(Component tab) {
        Component pane = OutputTabOperator.outputPaneForTab(tab);
        try {
            return (Document)pane.getClass().getMethod("getDocument", new Class[0]).invoke((Object)pane, new Object[0]);
        }
        catch (Exception x) {
            throw new JemmyException("Reflection failed: " + x, (Throwable)x);
        }
    }

    public void verify() {
        this.outputPaneOperator();
    }

    public void copy() {
        copyAction.perform(this.outputPaneOperator());
    }

    public void find() {
        findAction.perform(this.outputPaneOperator());
    }

    public void findNext() {
        findNextAction.perform(this.outputPaneOperator());
    }

    public void nextError() {
        nextErrorAction.perform(this.outputPaneOperator());
    }

    public void previousError() {
        previousErrorAction.perform(this.outputPaneOperator());
    }

    public void wrapText() {
        wrapTextAction.perform(this.outputPaneOperator());
    }

    public void saveAs() {
        saveAsAction.perform(this.outputPaneOperator());
    }

    public void close() {
        closeAction.perform(this.outputPaneOperator());
    }

    public void clear() {
        clearAction.perform(this.outputPaneOperator());
    }

    public void selectAll() {
        selectAllAction.perform(this.outputPaneOperator());
    }

    protected static final class OutputTabSubchooser
    implements ComponentChooser {
        private String tabName = null;

        public OutputTabSubchooser() {
        }

        public OutputTabSubchooser(String tabName) {
            this.tabName = tabName;
        }

        public boolean checkComponent(Component comp) {
            if (comp.getClass().getName().endsWith("OutputTab")) {
                return Operator.getDefaultStringComparator().equals(comp.getName(), this.tabName);
            }
            return false;
        }

        public String getDescription() {
            return "org.netbeans.core.output2.OutputTab" + (this.tabName != null ? " with \"" + this.tabName + "\" name" : "");
        }
    }
}

