/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import junit.framework.Test;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.DialogWaiter;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.util.Dumper;
import org.netbeans.jemmy.util.PNGEncoder;
import org.netbeans.junit.AssertionFailedErrorException;
import org.netbeans.junit.NbModuleSuite;
import org.netbeans.junit.NbTestCase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class JellyTestCase
extends NbTestCase {
    public boolean captureScreen = Boolean.valueOf(System.getProperty("jemmy.screen.capture", "true"));
    public boolean dumpScreen = Boolean.getBoolean("jemmy.screen.xmldump");
    public boolean closeAllModal = Boolean.valueOf(System.getProperty("jelly.close.modal", "true"));
    public boolean waitNoEvent = Boolean.valueOf(System.getProperty("jelly.wait.no.event", "true"));
    private boolean isScreenCaptured = false;
    private boolean testStatus = true;
    private Vector openedProjects = null;
    private static final DistributingHierarchyListener distributingHierarchyListener = new DistributingHierarchyListener();

    public JellyTestCase(String testName) {
        super(testName);
    }

    protected void initEnvironment() {
        PrintStream jemmyLog = this.getLog("jemmy.log");
        JemmyProperties.setCurrentOutput((TestOut)new TestOut(System.in, jemmyLog, jemmyLog));
        String timeoutsResource = System.getProperty("jelly.timeouts_resource");
        String timeoutsFile = System.getProperty("jelly.timeouts_file");
        try {
            JemmyProperties.getCurrentTimeouts().load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/netbeans/jellytools/timeouts"));
            if (timeoutsResource != null && !"".equals(timeoutsResource)) {
                JemmyProperties.getCurrentTimeouts().load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(timeoutsResource));
            } else if (timeoutsFile != null && !"".equals(timeoutsFile)) {
                JemmyProperties.getCurrentTimeouts().load(timeoutsFile);
            }
        }
        catch (Exception e) {
            throw new JemmyException("Initialization of timeouts failed.", (Throwable)e);
        }
    }

    public void runBare() throws Throwable {
        this.initEnvironment();
        Toolkit.getDefaultToolkit().addAWTEventListener(distributingHierarchyListener, 32768L);
        if (this.waitNoEvent) {
            new EventTool().waitNoEvent(1000L);
        }
        try {
            super.runBare();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            try {
                this.failNotify(th);
            }
            catch (Exception e3) {
                // empty catch block
            }
            this.captureScreen();
            if (this.closeAllModal) {
                try {
                    JellyTestCase.closeAllModal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (th instanceof JemmyException) {
                throw new AssertionFailedErrorException(th.getMessage(), th);
            }
            throw th;
        }
        finally {
            Toolkit.getDefaultToolkit().removeAWTEventListener(distributingHierarchyListener);
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            this.captureScreen();
            throw th;
        }
    }

    private void captureScreen() {
        if (!this.isScreenCaptured) {
            if (this.captureScreen) {
                try {
                    String captureFile = this.getWorkDir().getAbsolutePath() + File.separator + "screen.png";
                    PNGEncoder.captureScreen((String)captureFile, (byte)2);
                    this.noteCaptureFile(captureFile);
                }
                catch (Exception ex) {
                    ex.printStackTrace(this.getLog());
                }
            }
            PrintStream w = this.getLog();
            w.println("thread dump just after screen capture:");
            w.println(JellyTestCase.threadDump());
            if (this.dumpScreen) {
                try {
                    String captureFile = this.getWorkDir().getAbsolutePath() + File.separator + "screen.xml";
                    Dumper.dumpAll((String)captureFile);
                    this.noteCaptureFile(captureFile);
                }
                catch (Exception ex) {
                    ex.printStackTrace(this.getLog());
                }
            }
            this.isScreenCaptured = true;
        }
    }

    private void noteCaptureFile(String captureFile) {
        String hudsonURL = System.getenv("HUDSON_URL");
        if (hudsonURL == null) {
            return;
        }
        String workspace = System.getenv("WORKSPACE");
        if (!workspace.endsWith(File.separator)) {
            workspace = workspace + File.separator;
        }
        if (!captureFile.startsWith(workspace)) {
            return;
        }
        String relCaptureFile = captureFile.substring(workspace.length()).replace(File.separatorChar, '/');
        System.err.println("Capturing to:");
        System.err.println(hudsonURL + "job/" + System.getenv("JOB_NAME") + "/" + System.getenv("BUILD_NUMBER") + "/artifact/" + relCaptureFile);
    }

    protected void failNotify(Throwable reason) {
    }

    public static void closeAllModal() {
        JDialog dialog;
        ComponentChooser chooser = new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp instanceof JDialog && comp.isShowing() && ((JDialog)comp).isModal();
            }

            public String getDescription() {
                return "Modal dialog";
            }
        };
        while ((dialog = (JDialog)DialogWaiter.getDialog((ComponentChooser)chooser)) != null) {
            JellyTestCase.closeDialogs(JellyTestCase.findBottomDialog(dialog, chooser), chooser);
        }
    }

    private static JDialog findBottomDialog(JDialog dialog, ComponentChooser chooser) {
        Window owner = dialog.getOwner();
        if (chooser.checkComponent((Component)owner)) {
            return JellyTestCase.findBottomDialog((JDialog)owner, chooser);
        }
        return dialog;
    }

    private static void closeDialogs(JDialog dialog, ComponentChooser chooser) {
        Window[] ownees = dialog.getOwnedWindows();
        for (int i = 0; i < ownees.length; ++i) {
            if (!chooser.checkComponent((Component)ownees[i])) continue;
            JellyTestCase.closeDialogs((JDialog)ownees[i], chooser);
        }
        new JDialogOperator(dialog).close();
    }

    public void fail(Throwable t) {
        t.printStackTrace(this.getLog());
        throw new AssertionFailedErrorException(t);
    }

    protected void startTest() {
        if (!this.testStatus) {
            JellyTestCase.fail((String)"Depending on previous test, but it failed");
        }
        this.testStatus = false;
    }

    protected void endTest() {
        this.testStatus = true;
    }

    protected void clearTestStatus() {
        this.testStatus = true;
    }

    public void waitScanFinished() {
        try {
            ClassLoader l = Thread.currentThread().getContextClassLoader();
            if (l == null) {
                l = ((Object)((Object)this)).getClass().getClassLoader();
            }
            Class<?> repositoryUpdaterClass = Class.forName("org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater", true, l);
            final Object repositoryUpdater = repositoryUpdaterClass.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
            final Method isScanInProgressMethod = repositoryUpdaterClass.getMethod("isScanInProgress", new Class[0]);
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object anObject) {
                    Boolean result;
                    try {
                        result = (Boolean)isScanInProgressMethod.invoke(repositoryUpdater, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new JemmyException("Error during waiting for the end of scanning: ", (Throwable)e);
                    }
                    return result != false ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Waiting for scanning to finish.";
                }
            });
            Timeouts timeouts = waiter.getTimeouts();
            timeouts.setTimeout("Waiter.WaitingTime", 600000L);
            waiter.waitAction(null);
        }
        catch (Exception e) {
            throw new JemmyException("Waiting for end of scanning failed.", (Throwable)e);
        }
    }

    public void openProjects(String ... projects) throws IOException {
        try {
            Class<?> openProjectsClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.ui.OpenProjects");
            Class<?> projectManagerClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.ProjectManager");
            Method getDefaultOpenProjectsMethod = openProjectsClass.getMethod("getDefault", new Class[0]);
            Object openProjectsInstance = getDefaultOpenProjectsMethod.invoke(null, new Object[0]);
            Method getOpenProjectsMethod = openProjectsClass.getMethod("getOpenProjects", new Class[0]);
            if (this.openedProjects == null) {
                this.openedProjects = new Vector();
            }
            Vector<Object> newProjects = new Vector<Object>();
            for (String p : projects) {
                Method getDefaultMethod = projectManagerClass.getMethod("getDefault", new Class[0]);
                Object projectManagerInstance = getDefaultMethod.invoke(null, new Object[0]);
                Method findProjectMethod = projectManagerClass.getMethod("findProject", FileObject.class);
                Object pr = findProjectMethod.invoke(projectManagerInstance, FileUtil.toFileObject((File)new File(p)));
                Object openProjectsArray = getOpenProjectsMethod.invoke(openProjectsInstance, new Object[0]);
                boolean alreadyOpened = false;
                for (int i = 0; i < Array.getLength(openProjectsArray); ++i) {
                    if (!pr.equals(Array.get(openProjectsArray, i))) continue;
                    alreadyOpened = true;
                }
                if (alreadyOpened) continue;
                newProjects.add(pr);
            }
            Class<?> projectClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.Project");
            Object projectsArray = Array.newInstance(projectClass, newProjects.size());
            for (int i = 0; i < newProjects.size(); ++i) {
                Array.set(projectsArray, i, newProjects.get(i));
            }
            Method openMethod = openProjectsClass.getMethod("open", projectsArray.getClass(), Boolean.TYPE);
            openMethod.invoke(openProjectsInstance, projectsArray, false);
            this.openedProjects.addAll(newProjects);
            this.waitScanFinished();
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void openDataProjects(String ... projects) throws IOException {
        String[] fullPaths = new String[projects.length];
        for (int i = 0; i < projects.length; ++i) {
            fullPaths[i] = this.getDataDir().getAbsolutePath() + File.separator + projects[i];
        }
        this.openProjects(fullPaths);
    }

    public void closeOpenedProjects() {
        this.closeOpenedProjects(this.openedProjects.toArray());
        this.openedProjects.clear();
    }

    public void closeOpenedProjects(Object ... projects) {
        try {
            Class<?> openProjectsClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.ui.OpenProjects");
            Method getDefaultOpenProjectsMethod = openProjectsClass.getMethod("getDefault", new Class[0]);
            Object openProjectsInstance = getDefaultOpenProjectsMethod.invoke(null, new Object[0]);
            Class<?> projectClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.Project");
            Object projectsArray = Array.newInstance(projectClass, projects.length);
            for (int i = 0; i < projects.length; ++i) {
                Array.set(projectsArray, i, projects[i]);
            }
            Method closeMethod = openProjectsClass.getMethod("close", projectsArray.getClass());
            closeMethod.invoke(openProjectsInstance, projectsArray);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected static Test createModuleTest(String modules, String clusters, Class testClass, String ... testNames) {
        return NbModuleSuite.create((Class)testClass, (String)clusters, (String)modules, (String[])testNames);
    }

    protected static Test createModuleTest(Class testClass, String ... testNames) {
        return JellyTestCase.createModuleTest(".*", ".*", testClass, testNames);
    }

    private static void appendThread(StringBuffer sb, String indent, Thread t, Map<Thread, StackTraceElement[]> data) {
        sb.append(indent).append("Thread ").append(t.getName()).append('\n');
        for (StackTraceElement e : data.get(t)) {
            sb.append("\tat ").append(e.getClassName()).append('.').append(e.getMethodName()).append('(').append(e.getFileName()).append(':').append(e.getLineNumber()).append(")\n");
        }
    }

    private static void appendGroup(StringBuffer sb, String indent, ThreadGroup tg, Map<Thread, StackTraceElement[]> data) {
        sb.append(indent).append("Group ").append(tg.getName()).append('\n');
        indent = indent.concat("  ");
        int groups = tg.activeGroupCount();
        ThreadGroup[] chg = new ThreadGroup[groups];
        tg.enumerate(chg, false);
        for (ThreadGroup inner : chg) {
            if (inner == null) continue;
            JellyTestCase.appendGroup(sb, indent, inner, data);
        }
        int threads = tg.activeCount();
        Thread[] cht = new Thread[threads];
        tg.enumerate(cht, false);
        for (Thread t : cht) {
            if (t == null) continue;
            JellyTestCase.appendThread(sb, indent, t, data);
        }
    }

    private static String threadDump() {
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        StringBuffer sb = new StringBuffer();
        JellyTestCase.appendGroup(sb, "", root, all);
        return sb.toString();
    }

    private static class DistributingHierarchyListener
    implements AWTEventListener {
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            HierarchyEvent hevt = null;
            if (aWTEvent instanceof HierarchyEvent) {
                hevt = (HierarchyEvent)aWTEvent;
            }
            if (hevt != null && (4L & hevt.getChangeFlags()) != 0L) {
                DistributingHierarchyListener.distributeShowingEvent(hevt.getComponent(), hevt);
            }
        }

        private static void distributeShowingEvent(Component c, HierarchyEvent hevt) {
            HierarchyListener[] hierarchyListeners = (HierarchyListener[])c.getListeners(HierarchyListener.class);
            if (hierarchyListeners != null) {
                for (int i = 0; i < hierarchyListeners.length; ++i) {
                    hierarchyListeners[i].hierarchyChanged(hevt);
                }
            }
            if (c instanceof Container) {
                Container cont = (Container)c;
                int n = cont.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    DistributingHierarchyListener.distributeShowingEvent(cont.getComponent(i), hevt);
                }
            }
        }
    }
}

