/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

import com.sun.javacard.converter.util.MethodDescriptor;

public class Names {
    public static String getPackageName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return new String("");
        }
        return string.substring(0, n);
    }

    public static String getClassName(String string, int n) {
        int n2 = string.lastIndexOf(n);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    public static String getClassNameFromDescriptor(String string) {
        if (string.startsWith("L")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("[L")) {
            return string.substring(2, string.length() - 1);
        }
        return null;
    }

    public static String getPartialPackageName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(++n, string.length());
    }

    public static String getMethodNameInJavaStyle(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "(");
        String[] stringArray = MethodDescriptor.getParamDescriptors(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(Names.getTypeStringInJavaStyle(stringArray[i]));
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getMethodPrototypeInJavaStyle(String string, String[] stringArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                stringArray[i] = Names.getClassName(stringArray[i], 46);
                stringBuffer.append(stringArray[i] + " ");
            }
            stringBuffer.append("param" + (i + 1));
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getTypeStringInJavaStyle(String string) {
        if (string.equals("V")) {
            return "void";
        }
        if (string.equals("B")) {
            return "byte";
        }
        if (string.equals("S")) {
            return "short";
        }
        if (string.equals("I")) {
            return "int";
        }
        if (string.equals("Z")) {
            return "boolean";
        }
        if (string.equals("[B")) {
            return "byte[]";
        }
        if (string.equals("[S")) {
            return "short[]";
        }
        if (string.equals("[I")) {
            return "int[]";
        }
        if (string.equals("[Z")) {
            return "boolean[]";
        }
        if (string.equals("J")) {
            return "long";
        }
        if (string.equals("F")) {
            return "float";
        }
        if (string.equals("D")) {
            return "double";
        }
        if (string.equals("C")) {
            return "char";
        }
        if (string.startsWith("L")) {
            return Names.getClassNameFromDescriptor(string).replace('/', '.');
        }
        if (string.startsWith("[L")) {
            return Names.getClassNameFromDescriptor(string).replace('/', '.') + "[]";
        }
        if (string.equals("[J")) {
            return "long[]";
        }
        if (string.equals("[F")) {
            return "float[]";
        }
        if (string.equals("[D")) {
            return "double[]";
        }
        if (string.equals("[C")) {
            return "char[]";
        }
        return null;
    }

    public static String getExportFileName(String string) {
        return new String(Names.getPartialPackageName(string) + ".exp");
    }

    public static String getJcaFileName(String string) {
        return new String(Names.getPartialPackageName(string) + ".jca");
    }

    public static String getCAPFileName(String string) {
        return new String(Names.getPartialPackageName(string) + ".cap");
    }
}

