/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems.annotations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class LayerGeneratingProcessor
extends AbstractProcessor {
    private static final String GENERATED_LAYER = "META-INF/generated-layer.xml";
    private static final String PUBLIC_DTD_ID = "-//NetBeans//DTD Filesystem 1.2//EN";
    private static final String NETWORK_DTD_URL = "http://www.netbeans.org/dtds/filesystem-1_2.dtd";
    private static final String LOCAL_DTD_RESOURCE = "/org/openide/filesystems/filesystem1_2.dtd";
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };
    private static final EntityResolver ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (LayerGeneratingProcessor.PUBLIC_DTD_ID.equals(publicId)) {
                return new InputSource(LayerGeneratingProcessor.class.getResource(LayerGeneratingProcessor.LOCAL_DTD_RESOURCE).toString());
            }
            return null;
        }
    };
    private static final Map<ProcessingEnvironment, Document> generatedLayerByProcessor = new WeakHashMap<ProcessingEnvironment, Document>();
    private static final Map<ProcessingEnvironment, List<Element>> originatingElementsByProcessor = new WeakHashMap<ProcessingEnvironment, List<Element>>();
    private final List<LayerBuilder> createdBuilders = new LinkedList<LayerBuilder>();

    protected LayerGeneratingProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean ret;
        Messager messager = this.processingEnv.getMessager();
        try {
            ret = this.handleProcess(annotations, roundEnv);
        }
        catch (LayerGenerationException x) {
            if (x.erroneousAnnotationValue != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, x.getLocalizedMessage(), x.erroneousElement, x.erroneousAnnotation, x.erroneousAnnotationValue);
            } else if (x.erroneousAnnotation != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, x.getLocalizedMessage(), x.erroneousElement, x.erroneousAnnotation);
            } else if (x.erroneousElement != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, x.getLocalizedMessage(), x.erroneousElement);
            } else {
                messager.printMessage(Diagnostic.Kind.ERROR, x.getLocalizedMessage());
            }
            return false;
        }
        if (roundEnv.processingOver() && !roundEnv.errorRaised()) {
            Document doc = generatedLayerByProcessor.remove(this.processingEnv);
            if (doc != null) {
                Element[] originatingElementsA = new Element[]{};
                List<Element> originatingElementsL = originatingElementsByProcessor.remove(this.processingEnv);
                if (originatingElementsL != null) {
                    originatingElementsA = originatingElementsL.toArray(originatingElementsA);
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DOMImplementationLS ls = (DOMImplementationLS)doc.getImplementation().getFeature("LS", "3.0");
                    assert (ls != null) : "No DOM 3 LS supported in " + doc.getClass().getName();
                    LSOutput output = ls.createLSOutput();
                    output.setEncoding("UTF-8");
                    output.setByteStream(baos);
                    LSSerializer ser = ls.createLSSerializer();
                    String fpp = "format-pretty-print";
                    if (ser.getDomConfig().canSetParameter(fpp, true)) {
                        ser.getDomConfig().setParameter(fpp, true);
                    }
                    ser.write(doc, output);
                    byte[] data = baos.toByteArray();
                    XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(data)), (boolean)true, (boolean)true, (ErrorHandler)ERROR_HANDLER, (EntityResolver)ENTITY_RESOLVER);
                    FileObject layer = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", GENERATED_LAYER, originatingElementsA);
                    OutputStream os = layer.openOutputStream();
                    try {
                        os.write(data);
                    }
                    finally {
                        os.close();
                    }
                    TreeSet<String> files = new TreeSet<String>();
                    NodeList nl = doc.getElementsByTagName("file");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        org.w3c.dom.Element e = (org.w3c.dom.Element)nl.item(i);
                        String name = e.getAttribute("name");
                        while ((e = (org.w3c.dom.Element)e.getParentNode()).getTagName().equals("folder")) {
                            name = e.getAttribute("name") + "/" + name;
                        }
                        files.add(name);
                    }
                    for (String file : files) {
                        messager.printMessage(Diagnostic.Kind.NOTE, "generated layer entry: " + file);
                    }
                }
                catch (IOException x) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write generated-layer.xml: " + x.toString());
                }
                catch (SAXException x) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Refused to write invalid generated-layer.xml: " + x.toString());
                }
            }
            for (LayerBuilder b : this.createdBuilders) {
                b.close();
            }
            this.createdBuilders.clear();
        }
        return ret;
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws LayerGenerationException;

    protected final LayerBuilder layer(Element ... originatingElements) {
        LayerBuilder b = new LayerBuilder(this.layerDocument(originatingElements), originatingElements.length == 1 ? originatingElements[0] : null, this.processingEnv);
        this.createdBuilders.add(b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document layerDocument(Element ... originatingElements) {
        List<Element> originatingElementsL = originatingElementsByProcessor.get(this.processingEnv);
        if (originatingElementsL == null) {
            originatingElementsL = new ArrayList<Element>();
            originatingElementsByProcessor.put(this.processingEnv, originatingElementsL);
        }
        originatingElementsL.addAll(Arrays.asList(originatingElements));
        Document doc = generatedLayerByProcessor.get(this.processingEnv);
        if (doc == null) {
            try {
                FileObject layer = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", GENERATED_LAYER);
                InputStream is = layer.openInputStream();
                try {
                    doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)true, (boolean)true, (ErrorHandler)ERROR_HANDLER, (EntityResolver)ENTITY_RESOLVER);
                }
                finally {
                    is.close();
                }
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read generated-layer.xml: " + x.toString());
            }
            catch (SAXException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to parse generated-layer.xml: " + x.toString());
            }
            if (doc == null) {
                doc = XMLUtil.createDocument((String)"filesystem", null, (String)PUBLIC_DTD_ID, (String)NETWORK_DTD_URL);
            }
            generatedLayerByProcessor.put(this.processingEnv, doc);
        }
        return doc;
    }
}

