/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.core.output2.Lines;
import org.openide.windows.IOColors;
import org.openide.windows.OutputListener;

public class LineInfo {
    List<Segment> segments = new CopyOnWriteArrayList<Segment>();
    final Lines parent;

    LineInfo(Lines parent) {
        this.parent = parent;
    }

    LineInfo(Lines parent, int end) {
        this(parent, end, false, null, null, false);
    }

    LineInfo(Lines parent, int end, boolean err, OutputListener l, Color c, boolean important) {
        this.parent = parent;
        this.addSegment(end, err, l, c, important);
    }

    int getEnd() {
        return this.segments.isEmpty() ? 0 : this.segments.get(this.segments.size() - 1).getEnd();
    }

    void addSegment(int end, boolean err, OutputListener l, Color c, boolean important) {
        Segment s = null;
        if (!this.segments.isEmpty() && (s = this.segments.get(this.segments.size() - 1)).isErr() == err && s.getListener() == l && (s.getCustomColor() == c || c != null && c.equals(s.getCustomColor()))) {
            s.end = end;
            return;
        }
        s = l != null ? (c != null ? new ColorListenerSegment(end, l, important, c) : new ListenerSegment(end, l, important)) : (err ? (c != null ? new ColorErrSegment(end, c) : new ErrSegment(end)) : (c != null ? new ColorSegment(end, c) : new Segment(end)));
        this.segments.add(s);
    }

    OutputListener getListenerAfter(int pos, int[] range) {
        int start = 0;
        for (Segment s : this.segments) {
            if (s.getEnd() < pos) continue;
            if (s.getListener() != null) {
                if (range != null) {
                    range[0] = start;
                    range[1] = s.getEnd();
                }
                return s.getListener();
            }
            start = s.getEnd();
        }
        return null;
    }

    OutputListener getListenerBefore(int pos, int[] range) {
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            int startPos;
            int n = startPos = i == 0 ? 0 : this.segments.get(i - 1).getEnd();
            if (startPos > pos || this.segments.get(i).getListener() == null) continue;
            if (range != null) {
                range[0] = startPos;
                range[1] = this.segments.get(i).getEnd();
            }
            return this.segments.get(i).getListener();
        }
        return null;
    }

    OutputListener getFirstListener(int[] range) {
        int pos = 0;
        for (Segment s : this.segments) {
            if (s.getListener() != null) {
                if (range != null) {
                    range[0] = pos;
                    range[1] = s.getEnd();
                }
                return s.getListener();
            }
            pos = s.getEnd();
        }
        return null;
    }

    OutputListener getLastListener(int[] range) {
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            Segment s = this.segments.get(i);
            if (s.getListener() == null) continue;
            if (range != null) {
                range[0] = i == 0 ? 0 : this.segments.get(i - 1).getEnd();
                range[1] = s.getEnd();
            }
            return s.getListener();
        }
        return null;
    }

    Collection<Segment> getLineSegments() {
        return this.segments;
    }

    Collection<OutputListener> getListeners() {
        ArrayList<OutputListener> ol = new ArrayList<OutputListener>();
        for (Segment s : this.segments) {
            OutputListener l = s.getListener();
            if (l == null) continue;
            ol.add(l);
        }
        return ol;
    }

    private class ColorListenerSegment
    extends ListenerSegment {
        final Color color;

        public ColorListenerSegment(int end, OutputListener l, boolean important, Color color) {
            super(end, l, important);
            this.color = color;
        }

        @Override
        Color getColor() {
            return this.color;
        }

        @Override
        Color getCustomColor() {
            return this.color;
        }
    }

    private class ListenerSegment
    extends Segment {
        final OutputListener listener;
        final boolean important;

        public ListenerSegment(int end, OutputListener l, boolean important) {
            super(end);
            this.listener = l;
            this.important = important;
        }

        @Override
        OutputListener getListener() {
            return this.listener;
        }

        @Override
        Color getColor() {
            return LineInfo.this.parent.getDefColor(this.important ? IOColors.OutputType.HYPERLINK_IMPORTANT : IOColors.OutputType.HYPERLINK);
        }
    }

    private class ColorErrSegment
    extends ErrSegment {
        final Color color;

        public ColorErrSegment(int end, Color color) {
            super(end);
            this.color = color;
        }

        @Override
        Color getColor() {
            return this.color;
        }

        @Override
        Color getCustomColor() {
            return this.color;
        }
    }

    private class ErrSegment
    extends Segment {
        public ErrSegment(int end) {
            super(end);
        }

        @Override
        boolean isErr() {
            return true;
        }

        @Override
        Color getColor() {
            return LineInfo.this.parent.getDefColor(IOColors.OutputType.ERROR);
        }
    }

    private class ColorSegment
    extends Segment {
        final Color color;

        public ColorSegment(int end, Color color) {
            super(end);
            this.color = color;
        }

        @Override
        Color getColor() {
            return this.color;
        }

        @Override
        Color getCustomColor() {
            return this.color;
        }
    }

    public class Segment {
        int end;

        public Segment(int end) {
            this.end = end;
        }

        int getEnd() {
            return this.end;
        }

        OutputListener getListener() {
            return null;
        }

        boolean isErr() {
            return false;
        }

        Color getColor() {
            return LineInfo.this.parent.getDefColor(IOColors.OutputType.OUTPUT);
        }

        Color getCustomColor() {
            return null;
        }
    }
}

