/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditorOptions;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ReflowParagraphAction;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;

public class RubyKeystrokeHandler
implements KeystrokeHandler {
    private static final boolean REFLOW_COMMENTS = Boolean.getBoolean("ruby.autowrap.comments");
    static final boolean CONTINUE_COMMENTS = Boolean.getBoolean("ruby.cont.comment");
    private static final TokenId[] STRING_TOKENS = new TokenId[]{RubyTokenId.STRING_LITERAL, RubyTokenId.QUOTED_STRING_LITERAL, RubyTokenId.STRING_END, RubyTokenId.QUOTED_STRING_END};
    private static final TokenId[] REGEXP_TOKENS = new TokenId[]{RubyTokenId.REGEXP_LITERAL, RubyTokenId.REGEXP_END};
    private static final String EQ_BEGIN = "=begin";
    private int previousAdjustmentOffset = -1;
    private boolean isAfter;
    private int previousAdjustmentIndent;

    public boolean isInsertMatchingEnabled(BaseDocument doc) {
        EditorOptions options = EditorOptions.get((String)"text/x-ruby");
        if (options != null) {
            return options.getMatchBrackets();
        }
        return true;
    }

    public int beforeBreak(Document document, int offset, JTextComponent target) throws BadLocationException {
        int begin;
        boolean insert;
        TokenSequence<? extends RubyTokenId> ts;
        TokenSequence<? extends RubyTokenId> lineTs;
        this.isAfter = false;
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        boolean insertMatching = this.isInsertMatchingEnabled(doc);
        int lineBegin = Utilities.getRowStart((BaseDocument)doc, (int)offset);
        int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
        if (lineBegin == offset && lineEnd == offset) {
            return -1;
        }
        if (lineBegin != -1 && lineEnd != -1 && (lineTs = LexUtilities.getRubyTokenSequence(doc, offset)) != null) {
            lineTs.move(lineBegin);
            StringBuilder sb = new StringBuilder();
            while (lineTs.moveNext() && lineTs.offset() <= lineEnd) {
                char c;
                String text;
                Token token = lineTs.token();
                TokenId id = token.id();
                if (id != RubyTokenId.STRING_BEGIN || !(text = ((Object)token.text()).toString()).startsWith("<<") || !insertMatching) continue;
                StringBuilder markerBuilder = new StringBuilder();
                int n = text.length();
                for (int i = 2; i < n && (c = text.charAt(i)) != '\n' && c != '\r'; ++i) {
                    markerBuilder.append(c);
                }
                String marker = markerBuilder.toString();
                if (marker.startsWith("-")) {
                    marker = marker.substring(1);
                }
                if (marker.startsWith("'") && marker.endsWith("'") || marker.startsWith("\"") && marker.endsWith("\"")) {
                    marker = marker.substring(1, marker.length() - 2);
                }
                TokenSequence<? extends RubyTokenId> ts2 = LexUtilities.getRubyTokenSequence(doc, offset);
                ts2.move(offset);
                OffsetRange range = LexUtilities.findHeredocEnd(ts2, (Token<? extends RubyTokenId>)token);
                if (range != OffsetRange.NONE) continue;
                sb.append("\n");
                sb.append(marker);
            }
            if (sb.length() > 0) {
                if (lineEnd == doc.getLength()) {
                    sb.append("\n");
                }
                doc.insertString(lineEnd, sb.toString(), null);
                caret.setDot(lineEnd);
                return -1;
            }
        }
        if ((ts = LexUtilities.getRubyTokenSequence(doc, offset)) == null) {
            return -1;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return -1;
        }
        Token token = ts.token();
        TokenId id = token.id();
        if (insertMatching && (id == RubyTokenId.ERROR && ts.offset() == offset - 6 && ((Object)token.text()).toString().startsWith(EQ_BEGIN) || id == RubyTokenId.BEGIN && ts.offset() == Utilities.getRowStart((BaseDocument)doc, (int)offset) + 1 && EQ_BEGIN.equals(doc.getText(ts.offset() - 1, EQ_BEGIN.length())) || id == RubyTokenId.NONUNARY_OP && ts.offset() + EQ_BEGIN.length() <= doc.getLength() && EQ_BEGIN.equals(doc.getText(ts.offset(), EQ_BEGIN.length())))) {
            doc.insertString(offset, "\n=end", null);
            caret.setDot(offset);
            return -1;
        }
        boolean[] insertEndResult = new boolean[1];
        boolean[] insertRBraceResult = new boolean[1];
        int[] indentResult = new int[1];
        boolean bl = insert = insertMatching && RubyKeystrokeHandler.isEndMissing(doc, offset, false, insertEndResult, insertRBraceResult, null, indentResult);
        if (insert) {
            boolean insertEnd = insertEndResult[0];
            boolean insertRBrace = insertRBraceResult[0];
            int indent = indentResult[0];
            int afterLastNonWhite = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset);
            StringBuilder sb = new StringBuilder();
            if (offset > afterLastNonWhite) {
                sb.append("\n");
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
            } else {
                String restOfLine = doc.getText(offset, Utilities.getRowEnd((BaseDocument)doc, (int)afterLastNonWhite) - offset);
                sb.append(restOfLine);
                sb.append("\n");
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                doc.remove(offset, restOfLine.length());
            }
            if (insertEnd) {
                sb.append("end");
            } else {
                assert (insertRBrace);
                sb.append("}");
            }
            int insertOffset = offset;
            doc.insertString(insertOffset, sb.toString(), null);
            caret.setDot(insertOffset);
            return -1;
        }
        if ((id == RubyTokenId.RBRACE || id == RubyTokenId.RBRACKET) && Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset) == offset) {
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
            int insertOffset = offset;
            doc.insertString(insertOffset, sb.toString(), null);
            caret.setDot(insertOffset);
        }
        if (id == RubyTokenId.WHITESPACE && (begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset)) != -1 && offset < begin) {
            ts.move(begin);
            if (ts.moveNext() && (id = ts.token().id()) == RubyTokenId.LINE_COMMENT) {
                offset = begin;
            }
        }
        if (id == RubyTokenId.LINE_COMMENT) {
            Token<? extends RubyTokenId> firstToken;
            int prevBegin;
            boolean continueComment = false;
            int begin2 = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
            boolean previousLineWasComment = false;
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            if (rowStart > 0 && (prevBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)(rowStart - 1))) != -1 && (firstToken = LexUtilities.getToken(doc, prevBegin)) != null && firstToken.id() == RubyTokenId.LINE_COMMENT) {
                previousLineWasComment = true;
            }
            if (previousLineWasComment || offset > begin2) {
                Token<? extends RubyTokenId> firstToken2;
                int nextLineFirst;
                int nextLine;
                Token<? extends RubyTokenId> firstToken3;
                if (ts.offset() + token.length() > offset + 1) {
                    String trailing = doc.getText(offset, Utilities.getRowEnd((BaseDocument)doc, (int)offset) - offset);
                    if (trailing.trim().length() != 0) {
                        continueComment = true;
                    }
                } else if (CONTINUE_COMMENTS && (firstToken3 = LexUtilities.getToken(doc, begin2)) != null && firstToken3.id() == RubyTokenId.LINE_COMMENT) {
                    continueComment = true;
                }
                if (!continueComment && (nextLine = Utilities.getRowEnd((BaseDocument)doc, (int)offset) + 1) < doc.getLength() && (nextLineFirst = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)nextLine)) != -1 && (firstToken2 = LexUtilities.getToken(doc, nextLineFirst)) != null && firstToken2.id() == RubyTokenId.LINE_COMMENT) {
                    continueComment = true;
                }
            }
            if (continueComment) {
                char c;
                int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                StringBuilder sb = new StringBuilder();
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append("#");
                int afterHash = begin2 + 1;
                String line = doc.getText(afterHash, Utilities.getRowEnd((BaseDocument)doc, (int)afterHash) - afterHash);
                for (int i = 0; i < line.length() && ((c = line.charAt(i)) == ' ' || c == '\t'); ++i) {
                    sb.append(c);
                }
                int insertOffset = offset;
                if (offset == begin2 && insertOffset > 0) {
                    insertOffset = Utilities.getRowStart((BaseDocument)doc, (int)offset);
                    int sp = Utilities.getRowStart((BaseDocument)doc, (int)offset) + sb.length();
                    doc.insertString(insertOffset, sb.toString(), null);
                    caret.setDot(sp);
                    return sp;
                }
                doc.insertString(insertOffset, sb.toString(), null);
                caret.setDot(insertOffset);
                return insertOffset + sb.length() + 1;
            }
        }
        return -1;
    }

    static boolean isEndMissing(BaseDocument doc, int offset, boolean skipJunk, boolean[] insertEndResult, boolean[] insertRBraceResult, int[] startOffsetResult, int[] indentResult) throws BadLocationException {
        int length = doc.getLength();
        if (startOffsetResult != null) {
            startOffsetResult[0] = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        }
        int beginEndBalance = LexUtilities.getBeginEndLineBalance(doc, offset, true);
        int braceBalance = LexUtilities.getLineBalance(doc, offset, RubyTokenId.LBRACE, RubyTokenId.RBRACE);
        if (beginEndBalance == 1 || braceBalance == 1) {
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
            boolean insertEnd = beginEndBalance > 0;
            boolean insertRBrace = braceBalance > 0;
            int next = Utilities.getRowEnd((BaseDocument)doc, (int)offset) + 1;
            while (next < length) {
                if (!(Utilities.isRowEmpty((BaseDocument)doc, (int)next) || Utilities.isRowWhite((BaseDocument)doc, (int)next) || LexUtilities.isCommentOnlyLine(doc, next))) {
                    int nextIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)next);
                    if (nextIndent > indent) {
                        insertEnd = false;
                        insertRBrace = false;
                        break;
                    }
                    if (nextIndent != indent) break;
                    if (insertEnd) {
                        if (LexUtilities.getBeginEndLineBalance(doc, next, false) < 0) {
                            insertEnd = false;
                            break;
                        }
                        int lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)next);
                        Token<? extends RubyTokenId> token = LexUtilities.getToken(doc, lineBegin);
                        if (token == null || !LexUtilities.isIndentToken(token.id()) || LexUtilities.isBeginToken(token.id(), doc, lineBegin)) break;
                        insertEnd = false;
                        break;
                    }
                    if (!insertRBrace || LexUtilities.getLineBalance(doc, next, RubyTokenId.LBRACE, RubyTokenId.RBRACE) >= 0) break;
                    insertRBrace = false;
                    break;
                }
                next = Utilities.getRowEnd((BaseDocument)doc, (int)next) + 1;
            }
            if (insertEndResult != null) {
                insertEndResult[0] = insertEnd;
            }
            if (insertRBraceResult != null) {
                insertRBraceResult[0] = insertRBrace;
            }
            if (indentResult != null) {
                indentResult[0] = indent;
            }
            return insertEnd || insertRBrace;
        }
        return false;
    }

    public boolean beforeCharInserted(Document document, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        String selection;
        TokenSequence<? extends RubyTokenId> ts;
        this.isAfter = false;
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        if (!this.isInsertMatchingEnabled(doc)) {
            return false;
        }
        if (caretOffset == 0) {
            return false;
        }
        if (target.getSelectionStart() != -1) {
            String selection2;
            if (GsfUtilities.isCodeTemplateEditing((Document)doc)) {
                int end;
                int start = target.getSelectionStart();
                if (start < (end = target.getSelectionEnd())) {
                    target.setSelectionStart(start);
                    target.setSelectionEnd(start);
                    caretOffset = start;
                    caret.setDot(caretOffset);
                    doc.remove(start, end - start);
                }
            } else if (ch == '\"' || ch == '\'' || ch == '(' || ch == '{' || ch == '[' || ch == '/') {
                char firstChar;
                String selection3 = target.getSelectedText();
                if (selection3 != null && selection3.length() > 0 && (firstChar = selection3.charAt(0)) != ch) {
                    int start = target.getSelectionStart();
                    int end = target.getSelectionEnd();
                    TokenSequence<? extends RubyTokenId> ts2 = LexUtilities.getPositionedSequence(doc, start);
                    if (ts2 != null && ts2.token().id() != RubyTokenId.STRING_LITERAL && ts2.token().id() != RubyTokenId.QUOTED_STRING_LITERAL && ts2.token().id() != RubyTokenId.REGEXP_LITERAL) {
                        char lastChar = selection3.charAt(selection3.length() - 1);
                        if (selection3.length() > 1 && (firstChar == '\"' || firstChar == '\'' || firstChar == '(' || firstChar == '{' || firstChar == '[' || firstChar == '/') && lastChar == this.matching(firstChar)) {
                            doc.remove(end - 1, 1);
                            doc.insertString(end - 1, Character.toString(this.matching(ch)), null);
                            doc.remove(start, 1);
                            doc.insertString(start, Character.toString(ch), null);
                            target.getCaret().setDot(end);
                        } else {
                            doc.remove(start, end - start);
                            doc.insertString(start, ch + selection3 + this.matching(ch), null);
                            target.getCaret().setDot(start + selection3.length() + 2);
                        }
                        return true;
                    }
                }
            } else if (ch == '#' && (LexUtilities.isInsideQuotedString(doc, target.getSelectionStart()) && LexUtilities.isInsideQuotedString(doc, target.getSelectionEnd()) || LexUtilities.isInsideRegexp(doc, target.getSelectionStart()) && LexUtilities.isInsideRegexp(doc, target.getSelectionEnd())) && (selection2 = target.getSelectedText()) != null && selection2.length() > 0 && selection2.charAt(0) != ch) {
                int start = target.getSelectionStart();
                doc.remove(start, target.getSelectionEnd() - start);
                doc.insertString(start, "#{" + selection2 + "}", null);
                target.getCaret().setDot(start + selection2.length() + 3);
                return true;
            }
        }
        if ((ts = LexUtilities.getRubyTokenSequence(doc, caretOffset)) == null) {
            return false;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        Token token = ts.token();
        TokenId id = token.id();
        TokenId[] stringTokens = null;
        RubyTokenId beginTokenId = null;
        if (id == RubyTokenId.LINE_COMMENT && target.getSelectionStart() != -1 && (ch == '*' || ch == '+' || ch == '_') && (selection = target.getSelectedText()) != null && selection.length() > 0 && selection.charAt(0) != ch && selection.indexOf(32) == -1) {
            int start = target.getSelectionStart();
            doc.remove(start, target.getSelectionEnd() - start);
            doc.insertString(start, ch + selection + this.matching(ch), null);
            target.getCaret().setDot(start + selection.length() + 2);
            return true;
        }
        if (ch == '\"') {
            stringTokens = STRING_TOKENS;
            beginTokenId = RubyTokenId.QUOTED_STRING_BEGIN;
        } else if (ch == '\'') {
            stringTokens = STRING_TOKENS;
            beginTokenId = RubyTokenId.STRING_BEGIN;
        } else if (id == RubyTokenId.ERROR) {
            String text = ((Object)token.text()).toString();
            if (text.equals("%")) {
                if (!Character.isLetter(ch)) {
                    stringTokens = STRING_TOKENS;
                    beginTokenId = RubyTokenId.QUOTED_STRING_BEGIN;
                }
            } else if (text.length() == 2 && text.charAt(0) == '%' && Character.isLetter(text.charAt(1))) {
                char c = text.charAt(1);
                switch (c) {
                    case 'q': {
                        stringTokens = STRING_TOKENS;
                        beginTokenId = RubyTokenId.STRING_BEGIN;
                        break;
                    }
                    case 'Q': {
                        stringTokens = STRING_TOKENS;
                        beginTokenId = RubyTokenId.QUOTED_STRING_BEGIN;
                        break;
                    }
                    case 'r': {
                        stringTokens = REGEXP_TOKENS;
                        beginTokenId = RubyTokenId.REGEXP_BEGIN;
                        break;
                    }
                    default: {
                        stringTokens = STRING_TOKENS;
                        beginTokenId = RubyTokenId.QUOTED_STRING_BEGIN;
                        break;
                    }
                }
            } else {
                ts.movePrevious();
                TokenId prevId = ts.token().id();
                if (prevId == RubyTokenId.STRING_BEGIN || prevId == RubyTokenId.QUOTED_STRING_BEGIN) {
                    stringTokens = STRING_TOKENS;
                    beginTokenId = prevId;
                } else if (prevId == RubyTokenId.REGEXP_BEGIN) {
                    stringTokens = REGEXP_TOKENS;
                    beginTokenId = RubyTokenId.REGEXP_BEGIN;
                }
            }
        } else if ((id == RubyTokenId.STRING_BEGIN || id == RubyTokenId.QUOTED_STRING_BEGIN) && caretOffset == ts.offset() + 1) {
            if (!Character.isLetter(ch)) {
                stringTokens = STRING_TOKENS;
                beginTokenId = id;
            }
        } else if (id == RubyTokenId.STRING_BEGIN && caretOffset == ts.offset() + 2 || id == RubyTokenId.STRING_END) {
            stringTokens = STRING_TOKENS;
            beginTokenId = RubyTokenId.STRING_BEGIN;
        } else if (id == RubyTokenId.QUOTED_STRING_BEGIN && caretOffset == ts.offset() + 2 || id == RubyTokenId.QUOTED_STRING_END) {
            stringTokens = STRING_TOKENS;
            beginTokenId = RubyTokenId.QUOTED_STRING_BEGIN;
        } else if (id == RubyTokenId.REGEXP_BEGIN && caretOffset == ts.offset() + 2 || id == RubyTokenId.REGEXP_END) {
            stringTokens = REGEXP_TOKENS;
            beginTokenId = RubyTokenId.REGEXP_BEGIN;
        }
        if (stringTokens != null) {
            boolean inserted = this.completeQuote(doc, caretOffset, caret, ch, stringTokens, beginTokenId);
            if (inserted) {
                caret.setDot(caretOffset + 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean afterCharInserted(Document document, int dotPos, JTextComponent target, char ch) throws BadLocationException {
        TokenId id;
        Token<? extends RubyTokenId> token;
        this.isAfter = true;
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        if (REFLOW_COMMENTS && (token = LexUtilities.getToken(doc, dotPos)) != null && ((id = token.id()) == RubyTokenId.LINE_COMMENT || id == RubyTokenId.DOCUMENTATION)) {
            ReflowParagraphAction.reflowEditedComment(target);
        }
        if (this.previousAdjustmentOffset != -1) {
            TokenSequence<? extends RubyTokenId> ts;
            if (dotPos == this.previousAdjustmentOffset && (ts = LexUtilities.getRubyTokenSequence(doc, dotPos)) != null) {
                ts.move(dotPos);
                if (ts.moveNext() && ts.offset() < dotPos) {
                    GsfUtilities.setLineIndentation((BaseDocument)doc, (int)dotPos, (int)this.previousAdjustmentIndent);
                }
            }
            this.previousAdjustmentOffset = -1;
        }
        switch (ch) {
            case '#': {
                token = LexUtilities.getToken(doc, dotPos);
                if (token == null) {
                    return true;
                }
                id = token.id();
                if (id != RubyTokenId.QUOTED_STRING_LITERAL && id != RubyTokenId.REGEXP_LITERAL) break;
                document.insertString(dotPos + 1, "{}", null);
                caret.setDot(dotPos + 2);
                break;
            }
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                char c;
                char c2;
                String s;
                TokenId prevId;
                Token<? extends RubyTokenId> prevToken;
                if (!this.isInsertMatchingEnabled(doc)) {
                    return false;
                }
                token = LexUtilities.getToken(doc, dotPos);
                if (token == null) {
                    return true;
                }
                id = token.id();
                if (ch == '{' && id == RubyTokenId.ERROR && dotPos > 0 && (prevToken = LexUtilities.getToken(doc, dotPos - 1)) != null && ((prevId = prevToken.id()) == RubyTokenId.STRING_LITERAL || prevId == RubyTokenId.REGEXP_LITERAL) && dotPos > 1 && "#{".equals(s = doc.getText(dotPos - 2, 2))) {
                    doc.remove(dotPos, 1);
                    caret.setDot(dotPos);
                    return true;
                }
                if (ch == '}' && (id == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.REGEXP_LITERAL) && (prevToken = LexUtilities.getToken(doc, dotPos - 1)) != null && (prevId = prevToken.id()) == RubyTokenId.EMBEDDED_RUBY && dotPos < doc.getLength() - 1 && (c2 = doc.getText(dotPos + 1, 1).charAt(0)) == '}') {
                    doc.remove(dotPos, 1);
                    caret.setDot(dotPos + 1);
                    return true;
                }
                if (ch == '}' && id == RubyTokenId.EMBEDDED_RUBY && dotPos < doc.getLength() - 1 && (c = doc.getText(dotPos + 1, 1).charAt(0)) == '}') {
                    doc.remove(dotPos, 1);
                    caret.setDot(dotPos + 1);
                    return true;
                }
                if (id == RubyTokenId.ANY_OPERATOR) {
                    int length = token.length();
                    String s2 = ((Object)token.text()).toString();
                    if (length == 2 && "[]".equals(s2) || "[]=".equals(s2)) {
                        this.skipClosingBracket(doc, caret, ch, RubyTokenId.RBRACKET);
                        return true;
                    }
                }
                if (id == RubyTokenId.IDENTIFIER && token.length() == 1 || id == RubyTokenId.LBRACKET || id == RubyTokenId.RBRACKET || id == RubyTokenId.LBRACE || id == RubyTokenId.RBRACE || id == RubyTokenId.LPAREN || id == RubyTokenId.RPAREN) {
                    if (ch == ']') {
                        this.skipClosingBracket(doc, caret, ch, RubyTokenId.RBRACKET);
                    } else if (ch == ')') {
                        this.skipClosingBracket(doc, caret, ch, RubyTokenId.RPAREN);
                    } else if (ch == '}') {
                        this.skipClosingBracket(doc, caret, ch, RubyTokenId.RBRACE);
                    } else if (ch == '[' || ch == '(' || ch == '{') {
                        this.completeOpeningBracket(doc, dotPos, caret, ch);
                    }
                }
                if (ch == '}') {
                    this.reindent(doc, dotPos, RubyTokenId.RBRACE, caret);
                    break;
                }
                if (ch != ']') break;
                this.reindent(doc, dotPos, RubyTokenId.RBRACKET, caret);
                break;
            }
            case 'd': {
                this.reindent(doc, dotPos, RubyTokenId.END, caret);
                break;
            }
            case 'e': {
                this.reindent(doc, dotPos, RubyTokenId.ELSE, caret);
                this.reindent(doc, dotPos, RubyTokenId.ENSURE, caret);
                this.reindent(doc, dotPos, RubyTokenId.RESCUE, caret);
                break;
            }
            case 'f': {
                this.reindent(doc, dotPos, RubyTokenId.ELSIF, caret);
                break;
            }
            case 'n': {
                this.reindent(doc, dotPos, RubyTokenId.WHEN, caret);
                break;
            }
            case '/': {
                if (!this.isInsertMatchingEnabled(doc)) {
                    return false;
                }
                token = LexUtilities.getToken(doc, dotPos);
                if (token == null || (id = token.id()) != RubyTokenId.REGEXP_BEGIN && id != RubyTokenId.REGEXP_END) break;
                TokenId[] stringTokens = REGEXP_TOKENS;
                RubyTokenId beginTokenId = RubyTokenId.REGEXP_BEGIN;
                boolean inserted = this.completeQuote(doc, dotPos, caret, ch, stringTokens, beginTokenId);
                if (inserted) {
                    caret.setDot(dotPos + 1);
                }
                return inserted;
            }
            case '|': {
                if (!this.isInsertMatchingEnabled(doc)) {
                    return false;
                }
                token = LexUtilities.getToken(doc, dotPos);
                if (token == null) {
                    return true;
                }
                id = token.id();
                if (id == RubyTokenId.NONUNARY_OP && token.length() == 2 && "||".equals(((Object)token.text()).toString())) {
                    if (!this.isBlockDefinition(doc, dotPos)) break;
                    doc.remove(dotPos, 1);
                    caret.setDot(dotPos + 1);
                    return true;
                }
                if (id != RubyTokenId.IDENTIFIER || token.length() != 1 || !"|".equals(((Object)token.text()).toString())) break;
                if (this.isBlockDefinition(doc, dotPos)) {
                    boolean found = false;
                    int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
                    if (lineEnd > dotPos + 1) {
                        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, dotPos + 1);
                        ts.move(dotPos + 1);
                        while (ts.moveNext() && ts.offset() < lineEnd) {
                            Token t = ts.token();
                            if (t.id() != RubyTokenId.IDENTIFIER || t.length() != 1 || !"|".equals(((Object)t.text()).toString())) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        doc.insertString(dotPos + 1, "|", null);
                        caret.setDot(dotPos + 1);
                    }
                }
                return true;
            }
        }
        return true;
    }

    private boolean isBlockDefinition(BaseDocument doc, int dotPos) throws BadLocationException {
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, dotPos);
        int lineStart = Utilities.getRowStart((BaseDocument)doc, (int)dotPos);
        ts.move(dotPos + 1);
        while (ts.movePrevious() && ts.offset() >= lineStart) {
            TokenId tid = ts.token().id();
            if (tid == RubyTokenId.DO || tid == RubyTokenId.LBRACE) {
                return true;
            }
            if (tid != RubyTokenId.END && tid != RubyTokenId.RBRACE) continue;
            break;
        }
        return false;
    }

    private void reindent(BaseDocument doc, int offset, TokenId id, Caret caret) throws BadLocationException {
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, offset);
        if (ts != null) {
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return;
            }
            Token token = ts.token();
            if (token.id() == id) {
                OffsetRange begin;
                int rowFirstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
                if (ts.offset() > rowFirstNonWhite) {
                    if (RubyUtils.isRhtmlDocument((Document)doc)) {
                        String s = doc.getText(rowFirstNonWhite, ts.offset() - rowFirstNonWhite);
                        if (!s.matches("<%\\s*")) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if ((begin = id == RubyTokenId.RBRACE ? LexUtilities.findBwd(doc, ts, RubyTokenId.LBRACE, RubyTokenId.RBRACE) : (id == RubyTokenId.RBRACKET ? LexUtilities.findBwd(doc, ts, RubyTokenId.LBRACKET, RubyTokenId.RBRACKET) : LexUtilities.findBegin(doc, ts))) != OffsetRange.NONE) {
                    int beginOffset = begin.getStart();
                    int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)beginOffset);
                    this.previousAdjustmentIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                    GsfUtilities.setLineIndentation((BaseDocument)doc, (int)offset, (int)indent);
                    this.previousAdjustmentOffset = caret.getDot();
                }
            }
        }
    }

    public OffsetRange findMatching(Document document, int offset) {
        return OffsetRange.NONE;
    }

    public boolean charBackspaced(Document document, int dotPos, JTextComponent target, char ch) throws BadLocationException {
        BaseDocument doc = (BaseDocument)document;
        switch (ch) {
            case ' ': {
                TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, dotPos);
                ts.move(dotPos);
                if (!ts.moveNext() && !ts.movePrevious() || ts.offset() != dotPos - 1 || ts.token().id() != RubyTokenId.LINE_COMMENT) break;
                doc.remove(dotPos - 1, 1);
                target.getCaret().setDot(dotPos - 1);
                return true;
            }
            case '{': {
                String s;
                Token<? extends RubyTokenId> token = LexUtilities.getToken(doc, dotPos - 1);
                if (token != null && (token.id() == RubyTokenId.QUOTED_STRING_LITERAL || token.id() == RubyTokenId.REGEXP_LITERAL) && "#}".equals(s = document.getText(dotPos - 1, 2))) {
                    doc.remove(dotPos, 1);
                    target.getCaret().setDot(dotPos);
                }
            }
            case '(': 
            case '[': {
                char tokenAtDot = LexUtilities.getTokenChar(doc, dotPos);
                if (!(tokenAtDot == ']' && LexUtilities.getTokenBalance(doc, RubyTokenId.LBRACKET, RubyTokenId.RBRACKET, dotPos) != 0 || tokenAtDot == ')' && LexUtilities.getTokenBalance(doc, RubyTokenId.LPAREN, RubyTokenId.RPAREN, dotPos) != 0) && (tokenAtDot != '}' || LexUtilities.getTokenBalance(doc, RubyTokenId.LBRACE, RubyTokenId.RBRACE, dotPos) == 0)) break;
                doc.remove(dotPos, 1);
                break;
            }
            case '\"': 
            case '\'': 
            case '/': 
            case '|': {
                char[] match = doc.getChars(dotPos, 1);
                if (match == null || match[0] != ch) break;
                doc.remove(dotPos, 1);
            }
        }
        return true;
    }

    private void skipClosingBracket(BaseDocument doc, Caret caret, char bracket, TokenId bracketId) throws BadLocationException {
        int caretOffset = caret.getDot();
        if (this.isSkipClosingBracket(doc, caretOffset, bracketId)) {
            doc.remove(caretOffset - 1, 1);
            caret.setDot(caretOffset);
        }
    }

    private boolean isSkipClosingBracket(BaseDocument doc, int caretOffset, TokenId bracketId) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return false;
        }
        boolean skipClosingBracket = false;
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, caretOffset);
        if (ts == null) {
            return false;
        }
        ts.move(caretOffset);
        if (!ts.moveNext()) {
            return false;
        }
        Token token = ts.token();
        if (token != null && token.id() == bracketId) {
            int bracketIntId = bracketId.ordinal();
            int leftBracketIntId = bracketIntId == RubyTokenId.RPAREN.ordinal() ? RubyTokenId.LPAREN.ordinal() : RubyTokenId.LBRACKET.ordinal();
            ts.moveNext();
            Token nextToken = ts.token();
            while (nextToken != null && nextToken.id() == bracketId) {
                token = nextToken;
                if (!ts.moveNext()) break;
                nextToken = ts.token();
            }
            int braceBalance = 0;
            int bracketBalance = -1;
            Token lastRBracket = token;
            ts.movePrevious();
            token = ts.token();
            boolean finished = false;
            while (!finished && token != null) {
                int tokenIntId = ((RubyTokenId)token.id()).ordinal();
                if (token.id() == RubyTokenId.LPAREN || token.id() == RubyTokenId.LBRACKET) {
                    if (tokenIntId == bracketIntId && ++bracketBalance == 0) {
                        if (braceBalance != 0) {
                            bracketBalance = 1;
                        }
                        finished = true;
                    }
                } else if (token.id() == RubyTokenId.RPAREN || token.id() == RubyTokenId.RBRACKET) {
                    if (tokenIntId == bracketIntId) {
                        --bracketBalance;
                    }
                } else if (token.id() == RubyTokenId.LBRACE) {
                    if (++braceBalance > 0) {
                        finished = true;
                    }
                } else if (token.id() == RubyTokenId.RBRACE) {
                    --braceBalance;
                }
                if (!ts.movePrevious()) break;
                token = ts.token();
            }
            if (bracketBalance != 0) {
                skipClosingBracket = true;
            } else {
                braceBalance = 0;
                bracketBalance = 1;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                int ofs = lastRBracket.offset(th);
                ts.move(ofs);
                ts.moveNext();
                token = ts.token();
                finished = false;
                while (!finished && token != null) {
                    if (token.id() == RubyTokenId.LPAREN || token.id() == RubyTokenId.LBRACKET) {
                        if (((RubyTokenId)token.id()).ordinal() == leftBracketIntId) {
                            ++bracketBalance;
                        }
                    } else if (token.id() == RubyTokenId.RPAREN || token.id() == RubyTokenId.RBRACKET) {
                        if (((RubyTokenId)token.id()).ordinal() == bracketIntId && --bracketBalance == 0) {
                            if (braceBalance != 0) {
                                bracketBalance = -1;
                            }
                            finished = true;
                        }
                    } else if (token.id() == RubyTokenId.LBRACE) {
                        ++braceBalance;
                    } else if (token.id() == RubyTokenId.RBRACE && --braceBalance < 0) {
                        finished = true;
                    }
                    if (!ts.movePrevious()) break;
                    token = ts.token();
                }
                skipClosingBracket = bracketBalance == 0;
            }
        }
        return skipClosingBracket;
    }

    private void completeOpeningBracket(BaseDocument doc, int dotPos, Caret caret, char bracket) throws BadLocationException {
        if (this.isCompletablePosition(doc, dotPos + 1)) {
            String matchingBracket = "" + this.matching(bracket);
            doc.insertString(dotPos + 1, matchingBracket, null);
            caret.setDot(dotPos + 1);
        }
    }

    private boolean isEscapeSequence(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos <= 0) {
            return false;
        }
        char previousChar = doc.getChars(dotPos - 1, 1)[0];
        return previousChar == '\\';
    }

    private boolean completeQuote(BaseDocument doc, int dotPos, Caret caret, char bracket, TokenId[] stringTokens, TokenId beginToken) throws BadLocationException {
        int lastNonWhite;
        boolean eol;
        if (this.isEscapeSequence(doc, dotPos)) {
            return false;
        }
        if (doc.getLength() < dotPos) {
            return false;
        }
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, dotPos);
        if (ts == null) {
            return false;
        }
        ts.move(dotPos);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        Token<? extends RubyTokenId> token = ts.token();
        Token previousToken = null;
        if (ts.movePrevious()) {
            previousToken = ts.token();
        }
        boolean bl = eol = (lastNonWhite = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)dotPos)) < dotPos;
        if (token.id() == RubyTokenId.BLOCK_COMMENT || token.id() == RubyTokenId.LINE_COMMENT || token.id() == RubyTokenId.DOCUMENTATION) {
            return false;
        }
        if (token.id() == RubyTokenId.WHITESPACE && eol && dotPos - 1 > 0 && (token = LexUtilities.getToken(doc, dotPos - 1)) != null && token.id() == RubyTokenId.LINE_COMMENT) {
            return false;
        }
        boolean completablePosition = this.isQuoteCompletablePosition(doc, dotPos);
        boolean insideString = false;
        TokenId id = token.id();
        for (TokenId currId : stringTokens) {
            if (id != currId) continue;
            insideString = true;
            break;
        }
        if (id == RubyTokenId.ERROR && previousToken != null && previousToken.id() == beginToken) {
            insideString = true;
        }
        if (!insideString && token.id() == RubyTokenId.WHITESPACE && eol && dotPos - 1 > 0) {
            token = LexUtilities.getToken(doc, dotPos - 1);
            boolean bl2 = insideString = token != null && token.id() == RubyTokenId.STRING_LITERAL;
        }
        if (insideString) {
            if (eol) {
                return false;
            }
            char chr = doc.getChars(dotPos, 1)[0];
            if (chr == bracket) {
                if (!this.isAfter) {
                    doc.insertString(dotPos, "" + bracket, null);
                } else if (dotPos >= doc.getLength() - 1 || doc.getText(dotPos + 1, 1).charAt(0) != bracket) {
                    return true;
                }
                doc.remove(dotPos, 1);
                return true;
            }
        }
        if (completablePosition && !insideString || eol) {
            doc.insertString(dotPos, "" + bracket + (this.isAfter ? "" : Character.valueOf(this.matching(bracket))), null);
            return true;
        }
        return false;
    }

    private boolean isCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        char chr = doc.getChars(dotPos, 1)[0];
        return chr == ')' || chr == ',' || chr == '\"' || chr == '\'' || chr == ' ' || chr == ']' || chr == '}' || chr == '\n' || chr == '\t' || chr == ';';
    }

    private boolean isQuoteCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        int eol = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
        if (dotPos == eol || eol == -1) {
            return false;
        }
        int firstNonWhiteFwd = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)eol);
        if (firstNonWhiteFwd == -1) {
            return false;
        }
        char chr = doc.getChars(firstNonWhiteFwd, 1)[0];
        if (chr == '%' && (RubyUtils.isRhtmlDocument((Document)doc) || RubyUtils.isYamlDocument((Document)doc))) {
            return true;
        }
        return chr == ')' || chr == ',' || chr == '+' || chr == '}' || chr == ';' || chr == ']' || chr == '/';
    }

    private char matching(char bracket) {
        switch (bracket) {
            case '(': {
                return ')';
            }
            case '/': {
                return '/';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
        }
        return bracket;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, int caretOffset) {
        int length;
        Node root = AstUtilities.getRoot((Parser.Result)info);
        if (root == null) {
            return Collections.emptyList();
        }
        int astOffset = AstUtilities.getAstOffset((Parser.Result)info, caretOffset);
        if (astOffset == -1) {
            return Collections.emptyList();
        }
        AstPath path = new AstPath(root, astOffset);
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        int min = 0;
        int max = Integer.MAX_VALUE;
        try {
            Token<? extends RubyTokenId> token;
            BaseDocument doc = RubyUtils.getDocument((Parser.Result)info);
            if (doc == null) {
                return ranges;
            }
            length = doc.getLength();
            if (RubyUtils.isRhtmlDocument((Document)doc) || RubyUtils.isYamlDocument((Document)doc)) {
                Token t;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = th.tokenSequence();
                ts.move(caretOffset);
                if ((ts.moveNext() || ts.movePrevious()) && (t = ts.token()).id().primaryCategory().startsWith("ruby")) {
                    min = ts.offset();
                    max = min + t.length();
                    if (ts.movePrevious() && "ruby-delimiter".equals((t = ts.token()).id().primaryCategory())) {
                        min = ts.offset();
                        if (ts.moveNext() && ts.moveNext() && "ruby-delimiter".equals((t = ts.token()).id().primaryCategory())) {
                            max = ts.offset() + t.length();
                        }
                    }
                }
            }
            if ((token = LexUtilities.getToken(doc, caretOffset)) != null && token.id() == RubyTokenId.LINE_COMMENT) {
                int begin = Utilities.getRowStart((BaseDocument)doc, (int)caretOffset);
                int end = Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset);
                if (LexUtilities.isCommentOnlyLine(doc, caretOffset)) {
                    ranges.add(new OffsetRange(Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)begin), Utilities.getRowLastNonWhite((BaseDocument)doc, (int)end) + 1));
                    int lineBegin = begin;
                    int lineEnd = end;
                    while (begin > 0) {
                        int newBegin = Utilities.getRowStart((BaseDocument)doc, (int)(begin - 1));
                        if (newBegin < 0 || !LexUtilities.isCommentOnlyLine(doc, newBegin)) {
                            begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)begin);
                            break;
                        }
                        begin = newBegin;
                    }
                    while (true) {
                        int newEnd;
                        if ((newEnd = Utilities.getRowEnd((BaseDocument)doc, (int)(end + 1))) >= length || !LexUtilities.isCommentOnlyLine(doc, newEnd)) break;
                        end = newEnd;
                    }
                    end = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)end) + 1;
                    if (lineBegin > begin || lineEnd < end) {
                        ranges.add(new OffsetRange(begin, end));
                    }
                } else {
                    TokenHierarchy th = TokenHierarchy.get((Document)doc);
                    int offset = token.offset(th);
                    ranges.add(new OffsetRange(offset, offset + token.length()));
                }
            } else if (token != null && token.id() == RubyTokenId.DOCUMENTATION) {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                int begin = token.offset(th);
                int end = begin + token.length();
                ranges.add(new OffsetRange(begin, end));
            }
        }
        catch (BadLocationException ble) {
            return ranges;
        }
        ListIterator<Node> it = path.leafToRoot();
        OffsetRange previous = OffsetRange.NONE;
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.getNodeType() == NodeType.NEWLINENODE) continue;
            OffsetRange range = AstUtilities.getRange(node);
            if (node.getNodeType() == NodeType.CALLNODE && ranges.size() == 0 && node == path.leaf()) {
                Node receiver = ((CallNode)node).getReceiverNode();
                OffsetRange receiverRange = AstUtilities.getRange(receiver);
                if (receiver != null && astOffset > receiverRange.getEnd() && receiverRange.getEnd() + 1 < range.getEnd()) {
                    ranges.add(new OffsetRange(receiverRange.getEnd() + 1, range.getEnd()));
                }
            }
            if (!range.containsInclusive(astOffset) || range.equals((Object)previous) || (range = LexUtilities.getLexerOffsets((Parser.Result)info, range)) == OffsetRange.NONE) continue;
            if (range.getStart() < min) {
                ranges.add(new OffsetRange(min, max));
                ranges.add(new OffsetRange(0, length));
                break;
            }
            ranges.add(range);
            previous = range;
        }
        return ranges;
    }

    public int getNextWordOffset(Document document, int offset, boolean reverse) {
        BaseDocument doc = (BaseDocument)document;
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, offset);
        if (ts == null) {
            return -1;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return -1;
        }
        if (reverse && ts.offset() == offset && !ts.movePrevious()) {
            return -1;
        }
        Token token = ts.token();
        TokenId id = token.id();
        if (id == RubyTokenId.WHITESPACE) {
            int start;
            if (reverse && ts.offset() < offset || !reverse && ts.offset() > offset) {
                return ts.offset();
            }
            while (id == RubyTokenId.WHITESPACE) {
                if (reverse && !ts.movePrevious()) {
                    return -1;
                }
                if (!reverse && !ts.moveNext()) {
                    return -1;
                }
                token = ts.token();
                id = token.id();
            }
            if (reverse ? (start = ts.offset() + token.length()) < offset : (start = ts.offset()) > offset) {
                return start;
            }
        }
        if (id == RubyTokenId.IDENTIFIER || id == RubyTokenId.TYPE_SYMBOL || id == RubyTokenId.CONSTANT || id == RubyTokenId.GLOBAL_VAR || id == RubyTokenId.INSTANCE_VAR) {
            char charAtI;
            int i;
            String s = ((Object)token.text()).toString();
            int length = s.length();
            int wordOffset = offset - ts.offset();
            if (reverse) {
                int offsetInImage = offset - 1 - ts.offset();
                if (offsetInImage < 0) {
                    return -1;
                }
                if (offsetInImage < length && Character.isUpperCase(s.charAt(offsetInImage))) {
                    for (int i2 = offsetInImage - 1; i2 >= 0; --i2) {
                        char charAtI2 = s.charAt(i2);
                        if (charAtI2 == '_') {
                            return ts.offset() + i2 + 1;
                        }
                        if (Character.isUpperCase(charAtI2)) continue;
                        return ts.offset() + i2 + 1;
                    }
                    return ts.offset();
                }
                for (int i3 = offsetInImage - 1; i3 >= 0; --i3) {
                    char charAtI3 = s.charAt(i3);
                    if (charAtI3 == '_') {
                        return ts.offset() + i3 + 1;
                    }
                    if (!Character.isUpperCase(charAtI3)) continue;
                    for (int j = i3; j >= 0; --j) {
                        char charAtJ = s.charAt(j);
                        if (charAtJ == '_') {
                            return ts.offset() + j + 1;
                        }
                        if (Character.isUpperCase(charAtJ)) continue;
                        return ts.offset() + j + 1;
                    }
                    return ts.offset();
                }
                return ts.offset();
            }
            int start = wordOffset + 1;
            if (wordOffset < 0 || wordOffset >= s.length()) {
                return -1;
            }
            if (Character.isUpperCase(s.charAt(wordOffset))) {
                for (i = start; i < length && Character.isUpperCase(charAtI = s.charAt(i)); ++i) {
                    if (s.charAt(i) == '_') {
                        return ts.offset() + i;
                    }
                    ++start;
                }
            }
            for (i = start; i < length; ++i) {
                charAtI = s.charAt(i);
                if (charAtI != '_' && !Character.isUpperCase(charAtI)) continue;
                return ts.offset() + i;
            }
        }
        return -1;
    }
}

