/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.SelfNode;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.MigrationIndexer;
import org.netbeans.modules.ruby.RailsIndexer;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyIndexerHelper;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyStructureAnalyzer;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstAttributeElement;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.ModuleElement;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class RubyIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(RubyIndexer.class.getName());
    private static final boolean INDEX_UNDOCUMENTED = true;
    static boolean userSourcesTest = false;
    static final String FIELD_EXTENDS_NAME = "extends";
    static final String FIELD_FQN_NAME = "fqn";
    static final String FIELD_IN = "in";
    static final String FIELD_CLASS_NAME = "class";
    static final String FIELD_CASE_INSENSITIVE_CLASS_NAME = "class-ig";
    static final String FIELD_REQUIRE = "require";
    static final String FIELD_REQUIRES = "requires";
    static final String FIELD_INCLUDES = "includes";
    static final String FIELD_EXTEND_WITH = "extendWith";
    static final String[] FIXED_COLUMN_TYPES = new String[]{"binary", "boolean", "date", "datetime", "decimal", "float", "integer", "string", "text", "time", "timestamp"};
    static final String FIELD_METHOD_NAME = "method";
    static final String FIELD_FIELD_NAME = "field";
    static final String FIELD_GLOBAL_NAME = "global";
    static final String FIELD_ATTRIBUTE_NAME = "attribute";
    static final String FIELD_CONSTANT_NAME = "constant";
    static final String FIELD_CLASS_ATTRS = "attrs";
    static final String FIELD_DB_TABLE = "dbtable";
    static final String FIELD_EXPLICIT_DB_TABLE = "explicit-dbtable";
    static final String FIELD_DB_VERSION = "dbversion";
    static final String FIELD_DB_COLUMN = "dbcolumn";
    static final String SCHEMA_INDEX_VERSION = "schema";
    private static final String SET_TABLE_NAME = "set_table_name";
    static final String[] CLASS_FIELDS = new String[]{"extends", "fqn", "in", "class", "attrs", "class-ig", "require", "includes", "extendWith"};

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        IndexingSupport support;
        Node root = AstUtilities.getRoot(parserResult);
        RubyParseResult r = AstUtilities.getParseResult(parserResult);
        if (root == null) {
            return;
        }
        try {
            support = IndexingSupport.getInstance((Context)context);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
            return;
        }
        TreeAnalyzer analyzer = new TreeAnalyzer(r, support, indexable, new ContextKnowledge(null, root, r));
        analyzer.analyze();
        for (IndexDocument doc : analyzer.getDocuments()) {
            support.addDocument(doc);
        }
    }

    static int getModifiersFlag(Set<Modifier> modifiers) {
        int flags;
        int n = flags = modifiers.contains(Modifier.STATIC) ? 16 : 0;
        if (modifiers.contains(Modifier.PRIVATE)) {
            flags |= 4;
        } else if (modifiers.contains(Modifier.PROTECTED)) {
            flags |= 2;
        }
        return flags;
    }

    static final class TreeAnalyzer {
        private final FileObject file;
        private final IndexingSupport support;
        private final Indexable indexable;
        private String requires;
        private final RubyParseResult result;
        private int docMode;
        private final List<IndexDocument> documents;
        private String url;
        private final boolean platform;
        private final ContextKnowledge knowledge;
        private final MigrationIndexer migrationIndexer;
        private final RailsIndexer railsIndexer;

        private TreeAnalyzer(RubyParseResult result, IndexingSupport support, Indexable indexable, ContextKnowledge knowledge) {
            this.result = result;
            this.file = RubyUtils.getFileObject((Parser.Result)result);
            this.support = support;
            this.indexable = indexable;
            this.documents = new ArrayList<IndexDocument>();
            this.platform = RubyUtils.isPlatformFile(this.file);
            this.knowledge = knowledge;
            this.migrationIndexer = new MigrationIndexer(knowledge, this);
            this.railsIndexer = new RailsIndexer(knowledge, this);
        }

        FileObject getFile() {
            return this.file;
        }

        IndexingSupport getSupport() {
            return this.support;
        }

        Indexable getIndexable() {
            return this.indexable;
        }

        String getUrl() {
            return this.url;
        }

        RubyParseResult getResult() {
            return this.result;
        }

        MigrationIndexer getMigrationIndexer() {
            return this.migrationIndexer;
        }

        String getRequireString(Set<String> requireSet) {
            return this.asCommaSeparatedString(requireSet);
        }

        String getIncludedString(Set<String> includes) {
            return this.asCommaSeparatedString(includes);
        }

        private String asCommaSeparatedString(Set<String> strings) {
            if (strings != null && strings.size() > 0) {
                StringBuilder sb = new StringBuilder(20 * strings.size());
                for (String each : strings) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(each);
                }
                return sb.toString();
            }
            return null;
        }

        List<IndexDocument> getDocuments() {
            return this.documents;
        }

        public void analyze() {
            try {
                this.url = this.file.getURL().toExternalForm();
                this.url = RubyIndex.getPreindexUrl(this.url);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            String fileName = this.file.getNameExt();
            if (Character.isDigit(fileName.charAt(0)) && (fileName.matches("^\\d\\d\\d_.*") || fileName.matches("^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d_.*"))) {
                if (this.file != null && this.file.getParent() != null && this.file.getParent().getName().equals("migrate")) {
                    this.migrationIndexer.handleMigration();
                }
            } else if ("schema.rb".equals(fileName) && this.file != null && this.file.getParent() != null && this.file.getParent().getName().equals("db")) {
                this.migrationIndexer.handleMigration();
            }
            RubyStructureAnalyzer.AnalysisResult ar = this.result.getStructure();
            this.requires = this.getRequireString(ar.getRequires());
            List<? extends AstElement> structure = ar.getElements();
            if (!this.railsIndexer.index()) {
                return;
            }
            if (structure == null || structure.size() == 0) {
                if (this.requires != null) {
                    IndexDocument document = this.support.createDocument(this.indexable);
                    this.documents.add(document);
                    if (this.requires != null) {
                        document.addPair(RubyIndexer.FIELD_REQUIRES, this.requires, false, true);
                    }
                    this.addRequire(document);
                }
                return;
            }
            this.analyze(structure);
        }

        void addClassIncludes(String className, String fqn, String in, int flags, String includes) {
            IndexDocument document = this.support.createDocument(this.indexable);
            this.documents.add(document);
            if (includes != null) {
                document.addPair(RubyIndexer.FIELD_INCLUDES, includes, false, true);
            }
            document.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(flags), false, true);
            document.addPair(RubyIndexer.FIELD_FQN_NAME, fqn, true, true);
            document.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, className.toLowerCase(), true, true);
            document.addPair(RubyIndexer.FIELD_CLASS_NAME, className, true, true);
            if (in != null) {
                document.addPair(RubyIndexer.FIELD_IN, in, false, true);
            }
        }

        private void analyze(List<? extends AstElement> structure) {
            ArrayList<AstElement> topLevelMethods = null;
            IndexDocument globalDoc = null;
            Iterator<? extends AstElement> i$ = structure.iterator();
            while (i$.hasNext()) {
                AstElement o;
                AstElement element = o = i$.next();
                switch (element.getKind()) {
                    case MODULE: 
                    case CLASS: {
                        IndexDocument _doc = this.analyzeClassOrModule(element);
                        if (globalDoc != null) break;
                        globalDoc = _doc;
                        break;
                    }
                    case METHOD: {
                        if (!this.shouldIndexTopLevel()) break;
                        if (topLevelMethods == null) {
                            topLevelMethods = new ArrayList<AstElement>();
                        }
                        topLevelMethods.add(element);
                        break;
                    }
                    case GLOBAL: {
                        if (globalDoc == null) {
                            globalDoc = this.support.createDocument(this.indexable);
                            this.documents.add(globalDoc);
                        }
                        this.indexGlobal(element, globalDoc);
                        break;
                    }
                }
            }
            if (topLevelMethods != null) {
                this.analyzeTopLevelMethods(topLevelMethods);
            }
        }

        private boolean shouldIndexTopLevel() {
            String name;
            return !(this.platform && !userSourcesTest || (name = this.file.getNameExt()).endsWith("_spec.rb") || name.endsWith("_test.rb") || this.url != null && this.url.indexOf("/vendor/") != -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private IndexDocument analyzeClassOrModule(AstElement element) {
            previousDocMode = this.docMode;
            document = null;
            try {
                block48: {
                    block47: {
                        flags = 0;
                        nodoc = false;
                        if (this.platform) {
                            newDocMode = RubyIndexerHelper.isNodocClass(element, this.result.getSnapshot());
                            if (newDocMode == 2) {
                                this.docMode = 0;
                            } else if (newDocMode == 3) {
                                flags |= 32;
                                nodoc = true;
                                this.docMode = 3;
                            } else if (newDocMode == 1 || this.docMode == 3) {
                                flags |= 32;
                                nodoc = true;
                            }
                        }
                        document = this.support.createDocument(this.indexable);
                        node = element.getNode();
                        if (element.getKind() != ElementKind.CLASS) break block47;
                        classElement = (ClassElement)element;
                        if (classElement.isVirtual()) {
                            flags |= 512;
                        }
                        fqn = classElement.getFqn();
                        if (!(node instanceof SClassNode)) ** GOTO lbl36
                        receiver = ((SClassNode)node).getReceiverNode();
                        if (receiver instanceof Colon2Node) {
                            fqn = AstUtilities.getFqn((Colon2Node)receiver);
                        } else if (receiver instanceof INameNode) {
                            fqn = ((INameNode)receiver).getName();
                        } else {
                            var10_11 = document;
                            return var10_11;
lbl36:
                            // 1 sources

                            if (node instanceof ClassNode) {
                                clz = (ClassNode)node;
                                superNode = clz.getSuperNode();
                                superClass = null;
                                if (superNode != null) {
                                    superClass = AstUtilities.getSuperclass(clz);
                                }
                                if (superClass != null) {
                                    document.addPair("extends", superClass, true, true);
                                    tableName = this.getExplicitTableName((Node)clz);
                                    if (tableName != null) {
                                        document.addPair("explicit-dbtable", tableName, true, true);
                                    }
                                }
                            }
                        }
                        break block48;
                    }
                    if (!TreeAnalyzer.$assertionsDisabled && element.getKind() != ElementKind.MODULE) {
                        throw new AssertionError();
                    }
                    moduleElement = (ModuleElement)element;
                    fqn = moduleElement.getFqn();
                    extendWith = moduleElement.getExtendWith();
                    if (extendWith != null) {
                        document.addPair("extendWith", extendWith, false, true);
                    }
                    flags |= 64;
                }
                includes = this.getIncludedString(((ClassElement)element).getIncludes());
                if (includes != null) {
                    document.addPair("includes", includes, false, true);
                }
                name = element.getName();
                classIndex = fqn.lastIndexOf("::");
                in = classIndex != -1 ? fqn.substring(0, classIndex) : null;
                isDocumented = this.isDocumented(node);
                documentSize = this.getDocumentSize(node);
                if (documentSize > 0) {
                    flags |= 1;
                }
                attributes = new StringBuilder();
                attributes.append(IndexedElement.flagToFirstChar(flags));
                attributes.append(IndexedElement.flagToSecondChar(flags));
                if (documentSize > 0) {
                    attributes.append(";");
                    attributes.append(Integer.toString(documentSize));
                }
                document.addPair("attrs", attributes.toString(), false, true);
                if (element.getKind() == ElementKind.CLASS) {
                    // empty if block
                }
                document.addPair("fqn", fqn, true, true);
                document.addPair("class-ig", name.toLowerCase(), true, true);
                document.addPair("class", name, true, true);
                if (in != null) {
                    document.addPair("in", in, false, true);
                }
                this.addRequire(document);
                if (this.requires != null) {
                    document.addPair("requires", this.requires, false, true);
                }
                block20: for (AstElement child : element.getChildren()) {
                    switch (1.$SwitchMap$org$netbeans$modules$csl$api$ElementKind[child.getKind().ordinal()]) {
                        case 1: 
                        case 2: {
                            if (child.getNode() instanceof SClassNode && ((SClassNode)child.getNode()).getReceiverNode() instanceof SelfNode) {
                                for (AstElement grandChild : child.getChildren()) {
                                    switch (1.$SwitchMap$org$netbeans$modules$csl$api$ElementKind[grandChild.getKind().ordinal()]) {
                                        case 3: 
                                        case 5: {
                                            this.indexMethod(grandChild, document, false, nodoc);
                                            break;
                                        }
                                        case 1: 
                                        case 2: {
                                            this.analyzeClassOrModule(grandChild);
                                            break;
                                        }
                                        case 6: {
                                            this.indexField(grandChild, document, nodoc);
                                            break;
                                        }
                                        case 4: {
                                            this.indexGlobal(grandChild, document);
                                            break;
                                        }
                                        case 7: {
                                            this.indexAttribute(grandChild, document, nodoc);
                                            break;
                                        }
                                        case 8: {
                                            this.indexConstant(grandChild, document, nodoc);
                                        }
                                    }
                                }
                                continue block20;
                            }
                            this.analyzeClassOrModule(child);
                            break;
                        }
                        case 3: 
                        case 5: {
                            this.indexMethod(child, document, false, nodoc);
                            break;
                        }
                        case 6: {
                            this.indexField(child, document, nodoc);
                            break;
                        }
                        case 4: {
                            this.indexGlobal(child, document);
                            break;
                        }
                        case 7: {
                            this.indexAttribute(child, document, nodoc);
                            break;
                        }
                        case 8: {
                            this.indexConstant(child, document, nodoc);
                        }
                    }
                }
                this.documents.add(document);
            }
            finally {
                this.docMode = previousDocMode;
            }
            return document;
        }

        private void analyzeTopLevelMethods(List<? extends AstElement> children) {
            IndexDocument document = this.support.createDocument(this.indexable);
            this.documents.add(document);
            String name = "Object";
            Object in = null;
            String fqn = "Object";
            int flags = 0;
            document.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(flags), false, true);
            document.addPair(RubyIndexer.FIELD_FQN_NAME, fqn, true, true);
            document.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, name.toLowerCase(), true, true);
            document.addPair(RubyIndexer.FIELD_CLASS_NAME, name, true, true);
            this.addRequire(document);
            if (this.requires != null) {
                document.addPair(RubyIndexer.FIELD_REQUIRES, this.requires, false, true);
            }
            for (AstElement astElement : children) {
                assert (astElement.getKind() == ElementKind.CONSTRUCTOR || astElement.getKind() == ElementKind.METHOD);
                this.indexMethod(astElement, document, true, false);
            }
        }

        private void indexMethod(AstElement child, IndexDocument document, boolean topLevel, boolean nodoc) {
            boolean methodIsDocumented;
            String signature = null;
            Node childNode = child.getNode();
            signature = childNode instanceof MethodDefNode ? AstUtilities.getDefSignature((MethodDefNode)childNode) : child.getName();
            Set<Modifier> modifiers = child.getModifiers();
            int flags = RubyIndexer.getModifiersFlag(modifiers);
            if (nodoc) {
                flags |= 0x20;
            }
            if (topLevel) {
                flags |= 8;
            }
            if (methodIsDocumented = this.isDocumented(childNode)) {
                flags |= 1;
            }
            if (flags != 0) {
                StringBuilder sb = new StringBuilder(signature);
                sb.append(';');
                sb.append(IndexedElement.flagToFirstChar(flags));
                sb.append(IndexedElement.flagToSecondChar(flags));
                signature = sb.toString();
            }
            if (this.platform && !userSourcesTest) {
                if ((signature = RubyIndexerHelper.getMethodSignature(child, flags, signature, this.file, this.knowledge)) == null) {
                    return;
                }
            } else {
                if (!userSourcesTest) {
                    signature = RubyIndexerHelper.replaceAttributes(signature, flags);
                }
                signature = RubyIndexerHelper.getMethodSignatureForUserSources(child, signature, flags, this.knowledge);
            }
            document.addPair(RubyIndexer.FIELD_METHOD_NAME, signature, true, true);
            if (child.getName().equals("initialize")) {
                signature = signature.replaceFirst("initialize", "new");
                if ((flags & 0x10) == 0) {
                    char first = IndexedElement.flagToFirstChar(flags |= 0x10);
                    char second = IndexedElement.flagToSecondChar(flags);
                    int attributeIndex = signature.indexOf(59);
                    signature = attributeIndex == -1 ? signature + ";" + first + second : signature.substring(0, attributeIndex + 1) + first + second + signature.substring(attributeIndex + 3);
                }
                document.addPair(RubyIndexer.FIELD_METHOD_NAME, signature, true, true);
            }
        }

        private void indexAttribute(AstElement child, IndexDocument document, boolean nodoc) {
            RubyType type;
            AstAttributeElement attributeElement = (AstAttributeElement)child;
            String attribute = attributeElement.getName();
            int flags = RubyIndexer.getModifiersFlag(child.getModifiers());
            boolean isDocumented = this.isDocumented(attributeElement.getNode());
            if (isDocumented) {
                flags |= 1;
            }
            if (nodoc) {
                flags |= 0x20;
            }
            if (flags != 0) {
                char first = IndexedElement.flagToFirstChar(flags);
                char second = IndexedElement.flagToSecondChar(flags);
                attribute = attribute + ";" + first + second;
            }
            if ((type = child.getType()).isKnown()) {
                attribute = attribute + ";;" + type.asIndexedString() + ";";
            }
            document.addPair(RubyIndexer.FIELD_ATTRIBUTE_NAME, attribute, true, true);
        }

        private void indexConstant(AstElement child, IndexDocument document, boolean nodoc) {
            RubyType type = child.getType();
            StringBuilder signature = new StringBuilder(child.getName() + ';');
            if (type.isKnown()) {
                signature.append(type.asIndexedString());
            }
            document.addPair(RubyIndexer.FIELD_CONSTANT_NAME, signature.toString(), true, true);
        }

        private void indexField(AstElement child, IndexDocument document, boolean nodoc) {
            RubyType type;
            StringBuilder signature = new StringBuilder(child.getName());
            int flags = RubyIndexer.getModifiersFlag(child.getModifiers());
            if (nodoc) {
                flags |= 0x20;
            }
            if (flags != 0) {
                signature.append(';');
                signature.append(IndexedElement.flagToFirstChar(flags));
                signature.append(IndexedElement.flagToSecondChar(flags));
            }
            if ((type = child.getType()).isKnown()) {
                signature.append(";;" + type.asIndexedString() + ";");
            }
            document.addPair(RubyIndexer.FIELD_FIELD_NAME, signature.toString(), true, true);
        }

        private void indexGlobal(AstElement child, IndexDocument document) {
            if (!this.platform || userSourcesTest) {
                String signature = child.getName();
                document.addPair(RubyIndexer.FIELD_GLOBAL_NAME, signature, true, true);
            }
        }

        private int getDocumentSize(Node node) {
            List<String> comments = AstUtilities.gatherDocumentation(this.result.getSnapshot(), node);
            if (comments != null && comments.size() > 0) {
                int size = 0;
                for (String line : comments) {
                    size += line.length();
                }
                return size;
            }
            return 0;
        }

        private boolean isDocumented(Node node) {
            List<String> comments = AstUtilities.gatherDocumentation(this.result.getSnapshot(), node);
            return comments != null && comments.size() > 0;
        }

        void addRequire(IndexDocument document) {
            String folder;
            String string = folder = this.file.getParent() != null && this.file.getParent().getParent() != null ? this.file.getParent().getParent().getNameExt() : "";
            if (folder.equals("rubystubs") && this.file.getName().startsWith("stub_")) {
                return;
            }
            String relative = this.indexable.getRelativePath();
            if (relative != null && relative.endsWith(".rb")) {
                relative = relative.substring(0, relative.length() - 3);
                document.addPair(RubyIndexer.FIELD_REQUIRE, relative, true, true);
            }
        }

        private String getExplicitTableName(Node node) {
            for (Node child : node.childNodes()) {
                if (child instanceof FCallNode && RubyIndexer.SET_TABLE_NAME.equals(AstUtilities.getName(child))) {
                    ArrayNode value;
                    Node arg = ((FCallNode)child).getArgsNode();
                    if (arg != null && arg instanceof ArrayNode && (value = (ArrayNode)arg).size() > 0) {
                        return AstUtilities.getNameOrValue(value.get(0));
                    }
                    return null;
                }
                String tableName = this.getExplicitTableName(child);
                if (tableName == null) continue;
                return tableName;
            }
            return null;
        }
    }

    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "ruby";
        public static final int VERSION = 9;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new RubyIndexer();
            }
            return null;
        }

        public int getIndexVersion() {
            return 9;
        }

        public String getIndexerName() {
            return NAME;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            String extension = snapshot.getSource().getFileObject().getExt();
            return extension.equals("rb");
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport support = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    support.removeDocuments(indexable);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void rootsRemoved(Iterable<? extends URL> removedRoots) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : dirty) {
                    is.markDirtyDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }
    }
}

