/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.elements.CommentElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.util.NbBundle;

final class RubyHttpStatusCodeCompleter
extends RubyBaseCompleter {
    private static final String[] STATUS_CODE_KEYS = new String[]{"100", "101", "200", "201", "202", "203", "204", "205", "206", "300", "301", "302", "303", "304", "305", "307", "400", "401", "403", "404", "405", "406", "407", "408", "409", "410", "411", "412", "413", "414", "415", "416", "417", "500", "501", "502", "503", "504", "505"};
    private static final List<StatusCode> STATUS_CODES = RubyHttpStatusCodeCompleter.initStatusCodes();
    private final IndexedMethod target;

    private RubyHttpStatusCodeCompleter(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive, IndexedMethod target) {
        super(proposals, request, anchor, caseSensitive);
        this.target = target;
    }

    static boolean complete(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive, IndexedMethod target) {
        RubyHttpStatusCodeCompleter rsc = new RubyHttpStatusCodeCompleter(proposals, request, anchor, caseSensitive, target);
        return rsc.complete();
    }

    private boolean complete() {
        String prefix = this.request.prefix;
        boolean completed = false;
        for (StatusCode statusCode : STATUS_CODES) {
            if (!statusCode.code.startsWith(prefix)) continue;
            CommentElement element = new CommentElement(statusCode.longDesc);
            RubyCompletionItem.ParameterItem item = new RubyCompletionItem.ParameterItem(element, statusCode.shortDesc, statusCode.code, statusCode.code, this.anchor, this.request);
            item.setSmart(true);
            this.proposals.add(item);
            completed = true;
        }
        return completed;
    }

    private static List<StatusCode> initStatusCodes() {
        ArrayList<StatusCode> result = new ArrayList<StatusCode>(STATUS_CODE_KEYS.length);
        NbBundle.getBundle(RubyHttpStatusCodeCompleter.class);
        for (String key : STATUS_CODE_KEYS) {
            String shortDesc = NbBundle.getMessage(RubyHttpStatusCodeCompleter.class, (String)("SC_" + key));
            String longDesc = NbBundle.getMessage(RubyHttpStatusCodeCompleter.class, (String)("SC_" + key + "_DESC"));
            result.add(new StatusCode(key, shortDesc, longDesc));
        }
        return result;
    }

    private static class StatusCode {
        private final String code;
        private final String shortDesc;
        private final String longDesc;

        public StatusCode(String code, String shortDesc, String longDesc) {
            this.code = code;
            this.shortDesc = shortDesc;
            this.longDesc = longDesc;
        }
    }
}

