/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.scanner;

import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.insane.impl.InsaneEngine;
import org.netbeans.insane.scanner.CountingVisitor;
import org.netbeans.insane.scanner.Filter;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.Visitor;

public final class ScannerUtils {
    private ScannerUtils() {
        assert (false);
    }

    public static Visitor compoundVisitor(final Visitor[] parts) {
        return new Visitor(){
            private final Visitor[] sub;
            {
                this.sub = (Visitor[])parts.clone();
            }

            public void visitClass(Class cls) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitClass(cls);
                }
            }

            @Override
            public void visitObject(ObjectMap map, Object object) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitObject(map, object);
                }
            }

            @Override
            public void visitObjectReference(ObjectMap map, Object from, Object to, Field ref) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitObjectReference(map, from, to, ref);
                }
            }

            @Override
            public void visitArrayReference(ObjectMap map, Object from, Object to, int index) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitArrayReference(map, from, to, index);
                }
            }

            @Override
            public void visitStaticReference(ObjectMap map, Object to, Field ref) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitStaticReference(map, to, ref);
                }
            }
        };
    }

    public static Filter compoundFilter(final Filter[] parts) {
        return new Filter(){
            private final Filter[] sub;
            {
                this.sub = (Filter[])parts.clone();
            }

            @Override
            public boolean accept(Object o, Object r, Field ref) {
                for (int i = 0; i < this.sub.length; ++i) {
                    if (this.sub[i].accept(o, r, ref)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Filter skipObjectsFilter(Collection<Object> except, final boolean include) {
        class Except
        implements Filter {
            private final IdentityHashMap<Object, Boolean> skip = new IdentityHashMap();

            Except(Collection<Object> col) {
                Iterator<Object> it = col.iterator();
                while (it.hasNext()) {
                    this.skip.put(it.next(), Boolean.TRUE);
                }
            }

            @Override
            public boolean accept(Object o, Object refFrom, Field ref) {
                return !this.skip.containsKey(include ? refFrom : o);
            }
        }
        return new Except(except);
    }

    public static Filter skipReferencesFilter(final Collection<Field> except) {
        return new Filter(){
            private final Set<Field> skip;
            {
                this.skip = new HashSet<Field>(except);
            }

            @Override
            public boolean accept(Object o, Object r, Field ref) {
                return !this.skip.contains(ref);
            }
        };
    }

    public static Filter skipNonStrongReferencesFilter() {
        Class<Reference> clsReference = Reference.class;
        try {
            Field referentOfReference = clsReference.getDeclaredField("referent");
            return ScannerUtils.skipReferencesFilter(Collections.singleton(referentOfReference));
        }
        catch (NoSuchFieldException x) {
            NoSuchFieldError err = new NoSuchFieldError(x.toString());
            err.initCause(x);
            throw err;
        }
    }

    public static Filter noFilter() {
        return new Filter(){

            @Override
            public boolean accept(Object o, Object r, Field ref) {
                return true;
            }
        };
    }

    public static int sizeOf(Object o) {
        return ClassInfo.sizeOf(o);
    }

    public static int recursiveSizeOf(Collection roots, Filter f) throws Exception {
        CountingVisitor counter = new CountingVisitor();
        ScannerUtils.scan(f, counter, roots, false);
        return counter.getTotalSize();
    }

    public static void scan(Filter f, Visitor v, Collection roots, boolean analyzeStaticData) throws Exception {
        new InsaneEngine(f, v, analyzeStaticData).traverse(roots);
    }

    public static Set<Object> interestingRoots() {
        return new HashSet<Object>(Arrays.asList(Thread.currentThread(), ScannerUtils.class.getClassLoader()));
    }

    public static void scanExclusivelyInAWT(final Filter f, final Visitor v, final Set roots) throws Exception {
        Thread me = Thread.currentThread();
        final Exception[] ret = new Exception[1];
        Runnable performer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ScannerUtils.scan(f, v, roots, true);
                }
                catch (Exception e) {
                    ret[0] = e;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            performer.run();
        } else {
            SwingUtilities.invokeAndWait(performer);
        }
        if (ret[0] != null) {
            throw ret[0];
        }
    }

    private static Thread[] getAllThreads() {
        ThreadGroup act = Thread.currentThread().getThreadGroup();
        while (act.getParent() != null) {
            act = act.getParent();
        }
        Thread[] all = new Thread[2 * act.activeCount() + 5];
        int cnt = act.enumerate(all);
        Thread[] ret = new Thread[cnt];
        System.arraycopy(all, 0, ret, 0, cnt);
        return ret;
    }

    private static void suspendAllThreads(Set except) {
        Thread[] threads = ScannerUtils.getAllThreads();
        for (int i = 0; i < threads.length; ++i) {
            if (except.contains(threads[i]) || threads[i].getName().indexOf("VM") != -1 || threads[i].getName().indexOf("CompilerTh") != -1 || threads[i].getName().indexOf("Signal") != -1) continue;
            System.out.println("suspending " + threads[i]);
            threads[i].suspend();
        }
    }

    private static void resumeAllThreads() {
        Thread[] threads = ScannerUtils.getAllThreads();
        for (int i = 0; i < threads.length; ++i) {
            threads[i].resume();
        }
    }

    private static class ClassInfo {
        private static Map<Class, ClassInfo> classInfoRegistry = new WeakHashMap<Class, ClassInfo>();
        private int size;

        private ClassInfo(Class cls) {
            if (cls.isArray()) {
                Class<?> base = cls.getComponentType();
                this.size = -ClassInfo.getSize(base, true);
            } else {
                int sum = 0;
                for (Class act = cls; act != null; act = act.getSuperclass()) {
                    Field[] flds = act.getDeclaredFields();
                    for (int i = 0; i < flds.length; ++i) {
                        if ((flds[i].getModifiers() & 8) != 0) continue;
                        sum += ClassInfo.getSize(flds[i].getType(), false);
                    }
                }
                this.size = sum + 8 + 7 & 0xFFFFFFF8;
            }
        }

        static int sizeOf(Object o) {
            Class<?> cls = o.getClass();
            ClassInfo info = classInfoRegistry.get(cls);
            if (info == null) {
                info = new ClassInfo(cls);
                classInfoRegistry.put(cls, info);
            }
            return info.size > 0 ? info.size : 19 - info.size * Array.getLength(o) & 0xFFFFFFF8;
        }

        private static int getSize(Class type, boolean array) {
            if (array) {
                if (type == Byte.TYPE || type == Boolean.TYPE) {
                    return 1;
                }
                if (type == Short.TYPE || type == Character.TYPE) {
                    return 2;
                }
                if (type == Integer.TYPE || type == Float.TYPE) {
                    return 4;
                }
                if (type == Long.TYPE || type == Double.TYPE) {
                    return 8;
                }
                return 4;
            }
            if (type == Long.TYPE || type == Double.TYPE) {
                return 8;
            }
            return 4;
        }
    }
}

