/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTBuilder;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public class APTDriverImpl {
    private static final ConcurrentHashMap<CharSequence, APTSyncCreator> file2creator = new ConcurrentHashMap();
    private static Map<CharSequence, Reference<APTFile>> file2ref2apt = new ConcurrentHashMap<CharSequence, Reference<APTFile>>();
    private static Map<CharSequence, APTFile> file2apt = new ConcurrentHashMap<CharSequence, APTFile>();

    private APTDriverImpl() {
    }

    public static APTFile findAPT(APTFileBuffer buffer, boolean withTokens, String lang) throws IOException {
        CharSequence path = buffer.getAbsolutePath();
        APTFile apt = APTDriverImpl._getAPTFile(path, withTokens);
        if (apt == null) {
            APTSyncCreator old;
            APTSyncCreator creator = file2creator.get(path);
            if (creator == null && (old = file2creator.putIfAbsent(path, creator = new APTSyncCreator())) != null) {
                creator = old;
            }
            assert (creator != null);
            apt = creator.findAPT(buffer, withTokens, lang);
            file2creator.remove(path);
        }
        return apt;
    }

    public static void invalidateAPT(APTFileBuffer buffer) {
        CharSequence path = buffer.getAbsolutePath();
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            file2ref2apt.remove(path);
        } else {
            file2apt.remove(path);
        }
    }

    public static void invalidateAll() {
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            file2ref2apt.clear();
        } else {
            file2apt.clear();
        }
    }

    private static APTFile _getAPTFile(CharSequence path, boolean withTokens) {
        Reference<APTFile> aptRef;
        if (withTokens) {
            return null;
        }
        APTFile apt = APTTraceFlags.APT_USE_SOFT_REFERENCE ? ((aptRef = file2ref2apt.get(path)) == null ? null : aptRef.get()) : file2apt.get(path);
        return apt;
    }

    private static void _putAPTFile(CharSequence path, APTFile apt, boolean withTokens) {
        if (withTokens) {
            return;
        }
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            file2ref2apt.put(path, new SoftReference<APTFile>(apt));
        } else {
            file2apt.put(path, apt);
        }
    }

    public static void close() {
        APTDriverImpl.invalidateAll();
    }

    private static class APTSyncCreator {
        private APTFile fullAPT = null;
        private APTFile lightAPT = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TokenStream getTokenStream(APTFileBuffer buffer, String lang, boolean isLight) throws IOException {
            if (buffer.isFileBased()) {
                TokenStream tokenStream;
                block14: {
                    Reader reader;
                    block12: {
                        TokenStream tokenStream2;
                        block13: {
                            reader = null;
                            try {
                                reader = buffer.getReader();
                                if (!isLight) break block12;
                                tokenStream2 = APTTokenStreamBuilder.buildLightTokenStream((CharSequence)((Object)buffer.getAbsolutePath()).toString(), reader, lang);
                                if (reader == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException ex) {
                                        APTUtils.LOG.log(Level.SEVERE, "exception on closing stream\n{0}", new Object[]{ex});
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                reader.close();
                            }
                            catch (IOException ex) {
                                APTUtils.LOG.log(Level.SEVERE, "exception on closing stream\n{0}", new Object[]{ex});
                            }
                        }
                        return tokenStream2;
                    }
                    tokenStream = APTTokenStreamBuilder.buildTokenStream((CharSequence)((Object)buffer.getAbsolutePath()).toString(), reader, lang);
                    if (reader == null) break block14;
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        APTUtils.LOG.log(Level.SEVERE, "exception on closing stream\n{0}", new Object[]{ex});
                    }
                }
                return tokenStream;
            }
            if (isLight) {
                return APTTokenStreamBuilder.buildLightTokenStream((CharSequence)((Object)buffer.getAbsolutePath()).toString(), buffer.getCharBuffer(), lang);
            }
            return APTTokenStreamBuilder.buildTokenStream((CharSequence)((Object)buffer.getAbsolutePath()).toString(), buffer.getCharBuffer(), lang);
        }

        public synchronized APTFile findAPT(APTFileBuffer buffer, boolean withTokens, String lang) throws IOException {
            CharSequence path = buffer.getAbsolutePath();
            if (withTokens && this.fullAPT != null) {
                return this.fullAPT;
            }
            if (!withTokens && this.lightAPT != null) {
                return this.lightAPT;
            }
            APTFile apt = APTDriverImpl._getAPTFile(path, withTokens);
            if (apt == null) {
                TokenStream ts = this.getTokenStream(buffer, lang, !withTokens);
                apt = APTBuilder.buildAPT(path, ts);
                if (!withTokens) {
                    this.fullAPT = null;
                    if (apt != null) {
                        if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                            APTFile test = (APTFile)APTSerializeUtils.testAPTSerialization(buffer, apt);
                            if (test != null) {
                                apt = test;
                            } else {
                                System.err.println("error on serialization apt for file " + path);
                            }
                        }
                        this.lightAPT = apt;
                        APTDriverImpl._putAPTFile(path, this.lightAPT, false);
                    }
                } else {
                    this.fullAPT = apt;
                    if (apt != null) {
                        if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                            APTFile test = (APTFile)APTSerializeUtils.testAPTSerialization(buffer, apt);
                            if (test != null) {
                                apt = test;
                            } else {
                                System.err.println("error on serialization apt for file " + path);
                            }
                        }
                        APTDriverImpl._putAPTFile(path, this.fullAPT, true);
                        this.lightAPT = (APTFile)APTBuilder.buildAPTLight(apt);
                        APTDriverImpl._putAPTFile(path, this.lightAPT, false);
                    }
                }
            }
            return apt;
        }
    }
}

