/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public final class FileBasedURLMapper
extends URLMapper {
    public final URL getURL(FileObject fo, int type) {
        if (type == 2) {
            return null;
        }
        URL retVal = null;
        try {
            if (fo instanceof BaseFileObj) {
                BaseFileObj bfo = (BaseFileObj)fo;
                retVal = FileBasedURLMapper.fileToURL(bfo.getFileName().getFile(), fo);
            } else if (fo instanceof RootObj) {
                RootObj rfo = (RootObj)fo;
                return this.getURL((FileObject)rfo.getRealRoot(), type);
            }
        }
        catch (MalformedURLException e) {
            retVal = null;
        }
        return retVal;
    }

    public final FileObject[] getFileObjects(URL url) {
        File file;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        if (url.getPath().equals("//") || url.getPath().equals("////")) {
            return null;
        }
        FileObject retVal = null;
        try {
            file = FileUtil.normalizeFile((File)new File(url.toURI()));
        }
        catch (URISyntaxException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
        catch (IllegalArgumentException iax) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)iax, (String)("URL=" + url)));
            return null;
        }
        retVal = FileBasedFileSystem.getFileObject(file, FileObjectFactory.Caller.ToFileObject);
        return new FileObject[]{retVal};
    }

    private static URL fileToURL(File file, FileObject fo) throws MalformedURLException {
        URL retVal = FileBasedURLMapper.toURI(file, fo.isFolder()).toURL();
        if (fo.isFolder()) {
            String urlDef = retVal.toExternalForm();
            String pathSeparator = "/";
            if (!urlDef.endsWith("/")) {
                retVal = new URL(urlDef + "/");
            }
        }
        return retVal;
    }

    private static URI toURI(File file, boolean isDirectory) {
        try {
            File f = file.getAbsoluteFile();
            String sp = FileBasedURLMapper.slashify(f.getPath(), isDirectory);
            if (sp.startsWith("//")) {
                sp = "//" + sp;
            }
            return new URI("file", null, sp, null);
        }
        catch (URISyntaxException x) {
            throw new Error(x);
        }
    }

    private static String slashify(String path, boolean isDirectory) {
        String p = path;
        if (File.separatorChar != '/') {
            p = p.replace(File.separatorChar, '/');
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.endsWith("/") && isDirectory) {
            p = p + "/";
        }
        return p;
    }
}

