/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.parsing.impl.indexing.EventKind;
import org.netbeans.modules.parsing.impl.indexing.PathKind;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryEvent;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class PathRegistry
implements Runnable {
    private static final boolean FIRE_UNKNOWN_ALWAYS = false;
    private static PathRegistry instance;
    private static final RequestProcessor firer;
    private static final Logger LOGGER;
    private final RequestProcessor.Task firerTask;
    private final GlobalPathRegistry regs;
    private final List<PathRegistryEvent.Change> changes = new LinkedList<PathRegistryEvent.Change>();
    private Set<ClassPath> activeCps;
    private Map<URL, SourceForBinaryQuery.Result2> sourceResults;
    private Map<URL, URL[]> translatedRoots;
    private Map<URL, WeakValue> unknownRoots;
    private long timeStamp;
    private volatile Runnable debugCallBack;
    private volatile boolean useLibraries = true;
    private Collection<URL> sourcePaths;
    private Collection<URL> libraryPath;
    private Collection<URL> binaryLibraryPath;
    private Collection<URL> unknownSourcePath;
    private Map<URL, PathIds> rootPathIds;
    private Map<String, Set<URL>> pathIdToRoots;
    private final Listener listener;
    private final List<PathRegistryListener> listeners;

    private PathRegistry() {
        this.firerTask = firer.create((Runnable)this, true);
        this.regs = GlobalPathRegistry.getDefault();
        assert (this.regs != null);
        this.listener = new Listener();
        this.timeStamp = -1L;
        this.activeCps = Collections.emptySet();
        this.sourceResults = Collections.emptyMap();
        this.unknownRoots = new HashMap<URL, WeakValue>();
        this.translatedRoots = new HashMap<URL, URL[]>();
        this.listeners = new CopyOnWriteArrayList<PathRegistryListener>();
        this.regs.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.listener, (Object)this.regs));
    }

    public static synchronized PathRegistry getDefault() {
        if (instance == null) {
            instance = new PathRegistry();
        }
        return instance;
    }

    void setDebugCallBack(Runnable r) {
        this.debugCallBack = r;
    }

    public void addPathRegistryListener(PathRegistryListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    public void removePathRegistryListener(PathRegistryListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] sourceForBinaryQuery(URL binaryRoot, ClassPath definingClassPath, boolean fire) {
        URL[] result = this.translatedRoots.get(binaryRoot);
        if (result != null) {
            if (result.length > 0) {
                return result;
            }
            return null;
        }
        if (definingClassPath != null) {
            Collection<URL> unknownRes;
            ArrayList<URL> cacheRoots = new ArrayList<URL>();
            try {
                unknownRes = PathRegistry.getSources(SourceForBinaryQuery.findSourceRoots2((URL)binaryRoot), cacheRoots, null);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Defining cp URLs: " + definingClassPath.entries(), iae);
            }
            if (unknownRes.isEmpty()) {
                return null;
            }
            result = new URL[unknownRes.size()];
            PathRegistry pathRegistry = this;
            synchronized (pathRegistry) {
                int i = 0;
                for (URL u : unknownRes) {
                    result[i++] = u;
                    this.unknownRoots.put(u, new WeakValue(definingClassPath, u));
                }
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUnknownSourceRoots(ClassPath owner, Iterable<? extends URL> roots) {
        assert (owner != null);
        assert (roots != null);
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            for (URL uRL : roots) {
                this.unknownRoots.put(uRL, new WeakValue(owner, uRL));
            }
            this.unknownSourcePath = new HashSet<URL>(this.unknownRoots.keySet());
            this.changes.add(new PathRegistryEvent.Change(EventKind.PATHS_ADDED, PathKind.UNKNOWN_SOURCE, null, Collections.singleton(owner)));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LinkedList<URL> l = new LinkedList<URL>();
            for (URL uRL : roots) {
                l.add(uRL);
            }
            LOGGER.log(Level.FINE, "registerUnknownSourceRoots: {0}", l);
        }
        this.firerTask.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends URL> getSources() {
        Request request;
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.sourcePaths != null) {
                return this.sourcePaths;
            }
            LOGGER.fine("Computing data due to getSources");
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        Result res = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry2 = this;
        synchronized (pathRegistry2) {
            if (this.getTimeStamp() == res.timeStamp) {
                if (this.sourcePaths == null) {
                    this.sourcePaths = res.sourcePath;
                    this.libraryPath = res.libraryPath;
                    this.binaryLibraryPath = res.binaryLibraryPath;
                    this.unknownSourcePath = res.unknownSourcePath;
                    this.activeCps = res.newCps;
                    this.sourceResults = res.newSR;
                    this.translatedRoots = res.translatedRoots;
                    this.unknownRoots = res.unknownRoots;
                    this.rootPathIds = res.rootPathIds;
                    this.pathIdToRoots = res.pathIdToRoots;
                }
                return this.sourcePaths;
            }
            return res.sourcePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends URL> getLibraries() {
        Request request;
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.libraryPath != null) {
                return this.libraryPath;
            }
            LOGGER.fine("Computing data due to getLibraries");
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        Result res = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry2 = this;
        synchronized (pathRegistry2) {
            if (this.getTimeStamp() == res.timeStamp) {
                if (this.libraryPath == null) {
                    this.sourcePaths = res.sourcePath;
                    this.libraryPath = res.libraryPath;
                    this.binaryLibraryPath = res.binaryLibraryPath;
                    this.unknownSourcePath = res.unknownSourcePath;
                    this.activeCps = res.newCps;
                    this.sourceResults = res.newSR;
                    this.translatedRoots = res.translatedRoots;
                    this.unknownRoots = res.unknownRoots;
                    this.rootPathIds = res.rootPathIds;
                    this.pathIdToRoots = res.pathIdToRoots;
                }
                return this.libraryPath;
            }
            return res.libraryPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends URL> getBinaryLibraries() {
        Request request;
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.binaryLibraryPath != null) {
                return this.binaryLibraryPath;
            }
            LOGGER.fine("Computing data due to getBinaryLibraries");
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        Result res = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry2 = this;
        synchronized (pathRegistry2) {
            if (this.getTimeStamp() == res.timeStamp) {
                if (this.binaryLibraryPath == null) {
                    this.sourcePaths = res.sourcePath;
                    this.libraryPath = res.libraryPath;
                    this.binaryLibraryPath = res.binaryLibraryPath;
                    this.unknownSourcePath = res.unknownSourcePath;
                    this.activeCps = res.newCps;
                    this.sourceResults = res.newSR;
                    this.translatedRoots = res.translatedRoots;
                    this.unknownRoots = res.unknownRoots;
                    this.rootPathIds = res.rootPathIds;
                    this.pathIdToRoots = res.pathIdToRoots;
                }
                return this.binaryLibraryPath;
            }
            return res.binaryLibraryPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends URL> getUnknownRoots() {
        Request request;
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.unknownSourcePath != null) {
                return this.unknownSourcePath;
            }
            LOGGER.fine("Computing data due to getUnknownRoots");
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        Result res = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry2 = this;
        synchronized (pathRegistry2) {
            if (this.getTimeStamp() == res.timeStamp) {
                if (this.unknownSourcePath == null) {
                    this.sourcePaths = res.sourcePath;
                    this.libraryPath = res.libraryPath;
                    this.binaryLibraryPath = res.binaryLibraryPath;
                    this.unknownSourcePath = res.unknownSourcePath;
                    this.activeCps = res.newCps;
                    this.sourceResults = res.newSR;
                    this.translatedRoots = res.translatedRoots;
                    this.unknownRoots = res.unknownRoots;
                    this.rootPathIds = res.rootPathIds;
                    this.pathIdToRoots = res.pathIdToRoots;
                }
                return this.unknownSourcePath;
            }
            return res.unknownSourcePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnownRoot(URL root) {
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            return this.rootPathIds != null && this.rootPathIds.containsKey(root) || this.unknownSourcePath != null && this.unknownSourcePath.contains(root);
        }
    }

    public Set<String> getSourceIdsFor(URL root) {
        PathIds pathIds = this.getRootPathIds().get(root);
        return pathIds != null ? pathIds.getSids() : null;
    }

    public Set<String> getLibraryIdsFor(URL root) {
        PathIds pathIds = this.getRootPathIds().get(root);
        return pathIds != null ? pathIds.getLids() : null;
    }

    public Set<URL> getRootsMarkedAs(String ... pathIds) {
        Map<String, Set<URL>> rootsByPathIds = this.getPathIdToRoots();
        HashSet<URL> roots = new HashSet<URL>();
        for (String id : pathIds) {
            Set<URL> idRoots = rootsByPathIds.get(id);
            if (idRoots == null) continue;
            roots.addAll(idRoots);
        }
        return roots;
    }

    public Set<String> getMimeTypesFor(URL root) {
        PathIds pathIds = this.getRootPathIds().get(root);
        return pathIds != null ? pathIds.getMimeTypes() : null;
    }

    public boolean isFinished() {
        return this.firerTask.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<PathRegistryEvent.Change> ch;
        assert (firer.isRequestProcessorThread());
        long now = System.currentTimeMillis();
        try {
            LOGGER.log(Level.FINE, "resetCacheAndFire waiting for projects");
            OpenProjects.getDefault().openProjects().get();
            LOGGER.log(Level.FINE, "resetCacheAndFire blocked for {0} ms", System.currentTimeMillis() - now);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "resetCacheAndFire timeout", ex);
        }
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            ch = new ArrayList<PathRegistryEvent.Change>(this.changes);
            this.changes.clear();
        }
        this.fire(ch);
        LOGGER.log(Level.FINE, "resetCacheAndFire, firing done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URL, PathIds> getRootPathIds() {
        Request request;
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.rootPathIds != null) {
                return this.rootPathIds;
            }
            LOGGER.fine("Computing data due to getRootPathIds");
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        Result res = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry2 = this;
        synchronized (pathRegistry2) {
            if (this.getTimeStamp() == res.timeStamp) {
                if (this.rootPathIds == null) {
                    this.sourcePaths = res.sourcePath;
                    this.libraryPath = res.libraryPath;
                    this.binaryLibraryPath = res.binaryLibraryPath;
                    this.unknownSourcePath = res.unknownSourcePath;
                    this.activeCps = res.newCps;
                    this.sourceResults = res.newSR;
                    this.translatedRoots = res.translatedRoots;
                    this.unknownRoots = res.unknownRoots;
                    this.rootPathIds = res.rootPathIds;
                    this.pathIdToRoots = res.pathIdToRoots;
                }
                return this.rootPathIds;
            }
            return res.rootPathIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<URL>> getPathIdToRoots() {
        Request request;
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            if (this.pathIdToRoots != null) {
                return this.pathIdToRoots;
            }
            LOGGER.fine("Computing data due to getPathIdToRoots");
            request = new Request(this.getTimeStamp(), this.getSourcePaths(), this.getLibraryPaths(), this.getBinaryLibraryPaths(), new HashSet<ClassPath>(this.activeCps), new HashMap<URL, SourceForBinaryQuery.Result2>(this.sourceResults), new HashMap<URL, WeakValue>(this.unknownRoots), this.listener, this.listener);
        }
        Result res = PathRegistry.createResources(request);
        if (this.debugCallBack != null) {
            this.debugCallBack.run();
        }
        PathRegistry pathRegistry2 = this;
        synchronized (pathRegistry2) {
            if (this.getTimeStamp() == res.timeStamp) {
                if (this.pathIdToRoots == null) {
                    this.sourcePaths = res.sourcePath;
                    this.libraryPath = res.libraryPath;
                    this.binaryLibraryPath = res.binaryLibraryPath;
                    this.unknownSourcePath = res.unknownSourcePath;
                    this.activeCps = res.newCps;
                    this.sourceResults = res.newSR;
                    this.translatedRoots = res.translatedRoots;
                    this.unknownRoots = res.unknownRoots;
                    this.rootPathIds = res.rootPathIds;
                    this.pathIdToRoots = res.pathIdToRoots;
                }
                return this.pathIdToRoots;
            }
            return res.pathIdToRoots;
        }
    }

    private static Result createResources(Request request) {
        boolean notContained;
        URL root;
        boolean isNew;
        ClassPath cp;
        assert (request != null);
        HashSet<URL> sourceResult = new HashSet<URL>();
        HashSet<URL> unknownResult = new HashSet<URL>();
        HashSet<URL> libraryResult = new HashSet<URL>();
        HashSet<URL> binaryLibraryResult = new HashSet<URL>();
        HashMap<URL, URL[]> translatedRoots = new HashMap<URL, URL[]>();
        HashSet<ClassPath> newCps = new HashSet<ClassPath>();
        HashMap<URL, SourceForBinaryQuery.Result2> newSR = new HashMap<URL, SourceForBinaryQuery.Result2>();
        HashMap<URL, PathIds> pathIdsResult = new HashMap<URL, PathIds>();
        HashMap<String, Set<URL>> pathIdToRootsResult = new HashMap<String, Set<URL>>();
        for (TaggedClassPath taggedClassPath : request.sourceCps) {
            cp = taggedClassPath.getClasspath();
            isNew = !request.oldCps.remove(cp);
            for (ClassPath.Entry entry : cp.entries()) {
                root = entry.getURL();
                sourceResult.add(root);
                PathRegistry.updatePathIds(root, taggedClassPath, pathIdsResult, pathIdToRootsResult);
            }
            notContained = newCps.add(cp);
            if (!isNew || !notContained) continue;
            cp.addPropertyChangeListener(request.propertyListener);
        }
        for (TaggedClassPath taggedClassPath : request.libraryCps) {
            cp = taggedClassPath.getClasspath();
            isNew = !request.oldCps.remove(cp);
            for (ClassPath.Entry entry : cp.entries()) {
                root = entry.getURL();
                libraryResult.add(root);
                PathRegistry.updatePathIds(root, taggedClassPath, pathIdsResult, pathIdToRootsResult);
            }
            notContained = newCps.add(cp);
            if (!isNew || !notContained) continue;
            cp.addPropertyChangeListener(request.propertyListener);
        }
        for (TaggedClassPath taggedClassPath : request.binaryLibraryCps) {
            cp = taggedClassPath.getClasspath();
            isNew = !request.oldCps.remove(cp);
            for (ClassPath.Entry entry : cp.entries()) {
                boolean isNewSR;
                URL binRoot = entry.getURL();
                if (translatedRoots.containsKey(binRoot)) continue;
                PathRegistry.updatePathIds(binRoot, taggedClassPath, pathIdsResult, pathIdToRootsResult);
                SourceForBinaryQuery.Result2 sr = request.oldSR.remove(binRoot);
                if (sr == null) {
                    sr = SourceForBinaryQuery.findSourceRoots2((URL)binRoot);
                    isNewSR = true;
                } else {
                    isNewSR = false;
                }
                assert (!newSR.containsKey(binRoot));
                newSR.put(binRoot, sr);
                LOGGER.log(Level.FINE, "{0}: preferSources={1}", new Object[]{binRoot, sr.preferSources()});
                ArrayList<URL> cacheURLs = new ArrayList<URL>();
                Collection<URL> srcRoots = PathRegistry.getSources(sr, cacheURLs, request.unknownRoots);
                if (srcRoots.isEmpty()) {
                    binaryLibraryResult.add(binRoot);
                } else {
                    libraryResult.addAll(srcRoots);
                    PathRegistry.updateTranslatedPathIds(srcRoots, taggedClassPath, pathIdsResult, pathIdToRootsResult);
                }
                translatedRoots.put(binRoot, cacheURLs.toArray(new URL[cacheURLs.size()]));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("T: " + binRoot + " -> " + cacheURLs);
                }
                if (!isNewSR) continue;
                sr.addChangeListener(request.changeListener);
            }
            notContained = newCps.add(cp);
            if (!isNew || !notContained) continue;
            cp.addPropertyChangeListener(request.propertyListener);
        }
        for (ClassPath classPath : request.oldCps) {
            classPath.removePropertyChangeListener(request.propertyListener);
        }
        for (Map.Entry entry : request.oldSR.entrySet()) {
            ((SourceForBinaryQuery.Result2)entry.getValue()).removeChangeListener(request.changeListener);
        }
        unknownResult.addAll(request.unknownRoots.keySet());
        return new Result(request.timeStamp, sourceResult, libraryResult, binaryLibraryResult, unknownResult, newCps, newSR, translatedRoots, request.unknownRoots, pathIdsResult, pathIdToRootsResult);
    }

    private static Collection<URL> getSources(SourceForBinaryQuery.Result2 sr, List<URL> cacheDirs, Map<URL, WeakValue> unknownRoots) {
        assert (sr != null);
        if (sr.preferSources()) {
            FileObject[] roots = sr.getRoots();
            assert (roots != null);
            ArrayList<URL> result = new ArrayList<URL>(roots.length);
            for (int i = 0; i < roots.length; ++i) {
                try {
                    URL url = roots[i].getURL();
                    if (cacheDirs != null) {
                        cacheDirs.add(url);
                    }
                    if (unknownRoots != null) {
                        unknownRoots.remove(url);
                    }
                    result.add(url);
                    continue;
                }
                catch (FileStateInvalidException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            return result;
        }
        return Collections.emptySet();
    }

    private static void updatePathIds(URL root, TaggedClassPath tcp, Map<URL, PathIds> pathIdsResult, Map<String, Set<URL>> pathIdToRootsResult) {
        PathIds pathIds = pathIdsResult.get(root);
        if (pathIds == null) {
            pathIds = new PathIds();
            pathIdsResult.put(root, pathIds);
        }
        pathIds.addAll(tcp.getPathIds());
        for (String id : tcp.getPathIds().getAllIds()) {
            Set<URL> rootsWithId = pathIdToRootsResult.get(id);
            if (rootsWithId == null) {
                rootsWithId = new HashSet<URL>();
                pathIdToRootsResult.put(id, rootsWithId);
            }
            rootsWithId.add(root);
        }
        LOGGER.log(Level.FINE, "Root {0} associated with {1}", new Object[]{root, tcp.getPathIds()});
    }

    private static void updateTranslatedPathIds(Collection<URL> roots, TaggedClassPath tcp, Map<URL, PathIds> pathIdsResult, Map<String, Set<URL>> pathIdToRootsResult) {
        HashSet<String> sids = new HashSet<String>();
        HashSet<String> mimeTypes = new HashSet<String>();
        for (String blid : tcp.getPathIds().getBlids()) {
            Set<String> mts;
            Set<String> ids = PathRecognizerRegistry.getDefault().getSourceIdsForBinaryLibraryId(blid);
            if (ids != null) {
                sids.addAll(ids);
            }
            if ((mts = PathRecognizerRegistry.getDefault().getMimeTypesForBinaryLibraryId(blid)) == null) continue;
            mimeTypes.addAll(mts);
        }
        for (URL root : roots) {
            PathIds pathIds = pathIdsResult.get(root);
            if (pathIds == null) {
                pathIds = new PathIds();
                pathIdsResult.put(root, pathIds);
            }
            pathIds.getSids().addAll(sids);
            pathIds.getMimeTypes().addAll(mimeTypes);
            for (String id : sids) {
                Set<URL> rootsWithId = pathIdToRootsResult.get(id);
                if (rootsWithId == null) {
                    rootsWithId = new HashSet<URL>();
                    pathIdToRootsResult.put(id, rootsWithId);
                }
                rootsWithId.add(root);
            }
            LOGGER.log(Level.FINE, "Root {0} associated with {1}", new Object[]{root, tcp.getPathIds()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCacheAndFire(EventKind eventKind, PathKind pathKind, String pathId, Set<? extends ClassPath> paths) {
        PathRegistry pathRegistry = this;
        synchronized (pathRegistry) {
            this.sourcePaths = null;
            this.libraryPath = null;
            this.binaryLibraryPath = null;
            this.unknownSourcePath = null;
            this.rootPathIds = null;
            this.pathIdToRoots = null;
            ++this.timeStamp;
            this.changes.add(new PathRegistryEvent.Change(eventKind, pathKind, pathId, paths));
        }
        LOGGER.log(Level.FINE, "resetCacheAndFire: eventKind={0}, pathKind={1}, pathId={2}, paths={3}", new Object[]{eventKind, pathKind, pathId, paths});
        this.firerTask.schedule(0);
    }

    private void fire(Iterable<? extends PathRegistryEvent.Change> changes) {
        PathRegistryEvent event = new PathRegistryEvent(this, changes);
        for (PathRegistryListener l : this.listeners) {
            l.pathsChanged(event);
        }
    }

    private PathKind getPathKind(String pathId) {
        assert (pathId != null);
        if (pathId == null) {
            return null;
        }
        Set<String> sIds = PathRecognizerRegistry.getDefault().getSourceIds();
        if (sIds.contains(pathId)) {
            return PathKind.SOURCE;
        }
        Set<String> lIds = PathRecognizerRegistry.getDefault().getLibraryIds();
        if (lIds.contains(pathId)) {
            return PathKind.LIBRARY;
        }
        Set<String> bIds = PathRecognizerRegistry.getDefault().getBinaryLibraryIds();
        if (bIds.contains(pathId)) {
            return PathKind.BINARY_LIBRARY;
        }
        return null;
    }

    private Collection<TaggedClassPath> getSourcePaths() {
        return this.getPaths(PathKind.SOURCE);
    }

    private Collection<TaggedClassPath> getLibraryPaths() {
        return this.getPaths(PathKind.LIBRARY);
    }

    private Collection<TaggedClassPath> getBinaryLibraryPaths() {
        return this.getPaths(PathKind.BINARY_LIBRARY);
    }

    private Collection<TaggedClassPath> getPaths(PathKind kind) {
        Set<String> ids;
        switch (kind) {
            case SOURCE: {
                ids = PathRecognizerRegistry.getDefault().getSourceIds();
                break;
            }
            case LIBRARY: {
                ids = PathRecognizerRegistry.getDefault().getLibraryIds();
                break;
            }
            case BINARY_LIBRARY: {
                ids = PathRecognizerRegistry.getDefault().getBinaryLibraryIds();
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Not expecting PathKind of {0}", (Object)kind);
                return Collections.emptySet();
            }
        }
        HashMap<ClassPath, TaggedClassPath> result = new HashMap<ClassPath, TaggedClassPath>();
        for (String id : ids) {
            for (ClassPath cp : this.regs.getPaths(id)) {
                TaggedClassPath tcp = (TaggedClassPath)result.get(cp);
                if (tcp == null) {
                    tcp = new TaggedClassPath(cp);
                    result.put(cp, tcp);
                }
                switch (kind) {
                    case SOURCE: {
                        tcp.associateWithSourceId(id);
                        tcp.associateWithMimeTypes(PathRecognizerRegistry.getDefault().getMimeTypesForSourceId(id));
                        break;
                    }
                    case LIBRARY: {
                        tcp.associateWithLibraryId(id);
                        tcp.associateWithMimeTypes(PathRecognizerRegistry.getDefault().getMimeTypesForLibraryId(id));
                        break;
                    }
                    case BINARY_LIBRARY: {
                        tcp.associateWithBinaryLibraryId(id);
                    }
                }
            }
        }
        return result.values();
    }

    private long getTimeStamp() {
        return this.timeStamp;
    }

    private static String s2s(Object o) {
        return o == null ? "null" : o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    static {
        firer = new RequestProcessor("Path Registry Request Processor");
        LOGGER = Logger.getLogger(PathRegistry.class.getName());
    }

    private static final class PathIds {
        private final Set<String> sourcePathIds = new HashSet<String>();
        private final Set<String> libraryPathIds = new HashSet<String>();
        private final Set<String> binaryLibraryPathIds = new HashSet<String>();
        private final Set<String> mimeTypes = new HashSet<String>();

        private PathIds() {
        }

        public Set<String> getSids() {
            return this.sourcePathIds;
        }

        public Set<String> getLids() {
            return this.libraryPathIds;
        }

        public Set<String> getBlids() {
            return this.binaryLibraryPathIds;
        }

        public Set<String> getMimeTypes() {
            return this.mimeTypes;
        }

        public Set<String> getAllIds() {
            HashSet<String> allIds = new HashSet<String>();
            allIds.addAll(this.sourcePathIds);
            allIds.addAll(this.libraryPathIds);
            allIds.addAll(this.binaryLibraryPathIds);
            return allIds;
        }

        public void addAll(PathIds pathIds) {
            this.sourcePathIds.addAll(pathIds.getSids());
            this.libraryPathIds.addAll(pathIds.getLids());
            this.binaryLibraryPathIds.addAll(pathIds.getBlids());
            this.mimeTypes.addAll(pathIds.getMimeTypes());
        }

        public String toString() {
            return super.toString() + ";sids=" + this.sourcePathIds + ", lids=" + this.libraryPathIds + ", blids=" + this.binaryLibraryPathIds;
        }
    }

    private static final class TaggedClassPath {
        private final ClassPath classpath;
        private final PathIds pathIds = new PathIds();

        public TaggedClassPath(ClassPath classpath) {
            this.classpath = classpath;
        }

        public ClassPath getClasspath() {
            return this.classpath;
        }

        public PathIds getPathIds() {
            return this.pathIds;
        }

        public void associateWithSourceId(String id) {
            this.pathIds.getSids().add(id);
        }

        public void associateWithLibraryId(String id) {
            this.pathIds.getLids().add(id);
        }

        public void associateWithBinaryLibraryId(String id) {
            this.pathIds.getBlids().add(id);
        }

        public void associateWithMimeTypes(Set<String> mimeTypes) {
            this.pathIds.getMimeTypes().addAll(mimeTypes);
        }
    }

    private class Listener
    implements GlobalPathRegistryListener,
    PropertyChangeListener,
    ChangeListener {
        private WeakReference<Object> lastPropagationId;

        private Listener() {
        }

        public void pathsAdded(GlobalPathRegistryEvent event) {
            String pathId = event.getId();
            PathKind pk = PathRegistry.this.getPathKind(pathId);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("pathsAdded: " + event.getId() + ", paths=" + event.getChangedPaths());
                LOGGER.fine("'" + pathId + "' -> '" + (Object)((Object)pk) + "'");
            }
            if (pk != null) {
                PathRegistry.this.resetCacheAndFire(EventKind.PATHS_ADDED, pk, pathId, event.getChangedPaths());
            }
        }

        public void pathsRemoved(GlobalPathRegistryEvent event) {
            String pathId = event.getId();
            PathKind pk = PathRegistry.this.getPathKind(pathId);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("pathsRemoved: " + event.getId() + ", paths=" + event.getChangedPaths());
                LOGGER.fine("'" + pathId + "' -> '" + (Object)((Object)pk) + "'");
            }
            if (pk != null) {
                PathRegistry.this.resetCacheAndFire(EventKind.PATHS_REMOVED, pk, pathId, event.getChangedPaths());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName;
            if (LOGGER.isLoggable(Level.FINE)) {
                String msg = "propertyChange: " + evt.getPropertyName() + ", old=" + evt.getOldValue() + ", new=" + evt.getNewValue() + ", source=" + PathRegistry.s2s(evt.getSource());
                LOGGER.log(Level.FINE, msg);
            }
            if ("entries".equals(propName = evt.getPropertyName())) {
                PathRegistry.this.resetCacheAndFire(EventKind.PATHS_CHANGED, null, null, Collections.singleton((ClassPath)evt.getSource()));
            } else if ("includes".equals(propName)) {
                boolean fire;
                Object newPropagationId = evt.getPropagationId();
                Listener listener = this;
                synchronized (listener) {
                    fire = newPropagationId == null || this.lastPropagationId == null || this.lastPropagationId.get() != newPropagationId;
                    this.lastPropagationId = new WeakReference<Object>(newPropagationId);
                }
                if (fire) {
                    PathRegistry.this.resetCacheAndFire(EventKind.INCLUDES_CHANGED, PathKind.SOURCE, null, Collections.singleton((ClassPath)evt.getSource()));
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("stateChanged: " + event);
            }
            PathRegistry.this.resetCacheAndFire(EventKind.PATHS_CHANGED, PathKind.BINARY_LIBRARY, null, null);
        }
    }

    private class WeakValue
    extends WeakReference<ClassPath>
    implements Runnable {
        private URL key;

        public WeakValue(ClassPath ref, URL key) {
            super(ref, Utilities.activeReferenceQueue());
            assert (key != null);
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean fire = false;
            PathRegistry pathRegistry = PathRegistry.this;
            synchronized (pathRegistry) {
                fire = PathRegistry.this.unknownRoots.remove(this.key) != null;
            }
        }
    }

    private static class Result {
        final long timeStamp;
        final Collection<URL> sourcePath;
        final Collection<URL> libraryPath;
        final Collection<URL> binaryLibraryPath;
        final Collection<URL> unknownSourcePath;
        final Set<ClassPath> newCps;
        final Map<URL, SourceForBinaryQuery.Result2> newSR;
        final Map<URL, URL[]> translatedRoots;
        final Map<URL, WeakValue> unknownRoots;
        final Map<URL, PathIds> rootPathIds;
        final Map<String, Set<URL>> pathIdToRoots;

        public Result(long timeStamp, Collection<URL> sourcePath, Collection<URL> libraryPath, Collection<URL> binaryLibraryPath, Collection<URL> unknownSourcePath, Set<ClassPath> newCps, Map<URL, SourceForBinaryQuery.Result2> newSR, Map<URL, URL[]> translatedRoots, Map<URL, WeakValue> unknownRoots, Map<URL, PathIds> rootPathIds, Map<String, Set<URL>> pathIdToRoots) {
            assert (sourcePath != null);
            assert (libraryPath != null);
            assert (binaryLibraryPath != null);
            assert (unknownSourcePath != null);
            assert (newCps != null);
            assert (newSR != null);
            assert (translatedRoots != null);
            assert (rootPathIds != null);
            this.timeStamp = timeStamp;
            this.sourcePath = sourcePath;
            this.libraryPath = libraryPath;
            this.binaryLibraryPath = binaryLibraryPath;
            this.unknownSourcePath = unknownSourcePath;
            this.newCps = newCps;
            this.newSR = newSR;
            this.translatedRoots = translatedRoots;
            this.unknownRoots = unknownRoots;
            this.rootPathIds = rootPathIds;
            this.pathIdToRoots = pathIdToRoots;
        }
    }

    private static class Request {
        final long timeStamp;
        final Collection<TaggedClassPath> sourceCps;
        final Collection<TaggedClassPath> libraryCps;
        final Collection<TaggedClassPath> binaryLibraryCps;
        final Set<ClassPath> oldCps;
        final Map<URL, SourceForBinaryQuery.Result2> oldSR;
        final Map<URL, WeakValue> unknownRoots;
        final PropertyChangeListener propertyListener;
        final ChangeListener changeListener;

        public Request(long timeStamp, Collection<TaggedClassPath> sourceCps, Collection<TaggedClassPath> libraryCps, Collection<TaggedClassPath> binaryLibraryCps, Set<ClassPath> oldCps, Map<URL, SourceForBinaryQuery.Result2> oldSR, Map<URL, WeakValue> unknownRoots, PropertyChangeListener propertyListener, ChangeListener changeListener) {
            assert (sourceCps != null);
            assert (libraryCps != null);
            assert (binaryLibraryCps != null);
            assert (oldCps != null);
            assert (oldSR != null);
            assert (unknownRoots != null);
            assert (propertyListener != null);
            assert (changeListener != null);
            this.timeStamp = timeStamp;
            this.sourceCps = sourceCps;
            this.libraryCps = libraryCps;
            this.binaryLibraryCps = binaryLibraryCps;
            this.oldCps = oldCps;
            this.oldSR = oldSR;
            this.unknownRoots = unknownRoots;
            this.propertyListener = propertyListener;
            this.changeListener = changeListener;
        }
    }
}

